/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.util;

import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.PatternImage;

public class PatternImageUtil {
    private static long[] BIT_MASK = PatternImageUtil.initBitMasks();

    private static long[] initBitMasks() {
        int len = 64;
        long[] bitMasks = new long[len];
        int i = 0;
        while (i < len) {
            bitMasks[i] = 1L << i;
            ++i;
        }
        return bitMasks;
    }

    private static boolean validateIndex(int x, int y) {
        return x < 8 && x >= 0 && y < 8 && y >= 0;
    }

    public static boolean isPixelSet(long bitmap, int x, int y) {
        if (PatternImageUtil.validateIndex(x, y)) {
            int index = x + y * 8;
            return (bitmap & BIT_MASK[index]) != 0L;
        }
        return false;
    }

    public static long togglePixel(long bitmap, int x, int y) {
        if (PatternImageUtil.validateIndex(x, y)) {
            int index = x + y * 8;
            bitmap ^= BIT_MASK[index];
        }
        return bitmap;
    }

    public static byte[] createImageData(PatternImage pi, ByteColorModel colorModel) {
        byte[] valFore = colorModel.getColorValue(pi.getForeColor());
        byte[] valBack = colorModel.getColorValue(pi.getBackColor());
        byte[] data = new byte[256];
        long bitmap = pi.getBitmap();
        int offset = 0;
        int i = 0;
        while (i < 64) {
            byte[] val = (bitmap & BIT_MASK[i]) != 0L ? valFore : valBack;
            System.arraycopy(val, 0, data, offset, 4);
            offset += 4;
            ++i;
        }
        return data;
    }

    public static int[] createImageData(PatternImage pi, IntColorModel colorModel) {
        int valFore = colorModel.getColorValue(pi.getForeColor());
        int valBack = colorModel.getColorValue(pi.getBackColor());
        int[] data = new int[64];
        long bitmap = pi.getBitmap();
        int i = 0;
        while (i < 64) {
            data[i] = (bitmap & BIT_MASK[i]) != 0L ? valFore : valBack;
            ++i;
        }
        return data;
    }

    public static enum ByteColorModel {
        BGRA{

            @Override
            public byte[] getColorValue(ColorDefinition color) {
                byte[] data = new byte[]{(byte)color.getBlue(), (byte)color.getGreen(), (byte)color.getRed(), (byte)color.getTransparency()};
                return data;
            }
        }
        ,
        RGBA{

            @Override
            public byte[] getColorValue(ColorDefinition color) {
                byte[] data = new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue(), (byte)color.getTransparency()};
                return data;
            }
        };


        public abstract byte[] getColorValue(ColorDefinition var1);
    }

    public static enum IntColorModel {
        BGRA{

            @Override
            public int getColorValue(ColorDefinition color) {
                return color.getBlue() << 24 | color.getGreen() << 16 | color.getRed() << 8 | color.getTransparency();
            }
        }
        ,
        RGBA{

            @Override
            public int getColorValue(ColorDefinition color) {
                return color.getTransparency() << 24 | color.getBlue() << 16 | color.getGreen() << 8 | color.getRed();
            }
        };


        public abstract int getColorValue(ColorDefinition var1);
    }
}

