/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.core.internal;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.internal.IClient;
import org.eclipse.wst.server.core.internal.Trace;
import org.eclipse.wst.server.core.model.ClientDelegate;

public class Client
implements IClient {
    private IConfigurationElement element;
    private ClientDelegate delegate;

    public Client(IConfigurationElement element) {
        this.element = element;
    }

    @Override
    public String getId() {
        return this.element.getAttribute("id");
    }

    public int getPriority() {
        try {
            return Integer.parseInt(this.element.getAttribute("priority"));
        }
        catch (Exception exception) {
            return 0;
        }
    }

    @Override
    public String getDescription() {
        return this.element.getAttribute("description");
    }

    protected String getLaunchable() {
        return this.element.getAttribute("launchable");
    }

    @Override
    public String getName() {
        String label = this.element.getAttribute("name");
        if (label == null) {
            return "n/a";
        }
        return label;
    }

    public ClientDelegate getDelegate() {
        block3: {
            if (this.delegate == null) {
                try {
                    this.delegate = (ClientDelegate)this.element.createExecutableExtension("class");
                }
                catch (Exception e) {
                    if (!Trace.SEVERE) break block3;
                    Trace.trace("/severe", "Could not create delegate" + this.toString(), e);
                }
            }
        }
        return this.delegate;
    }

    @Override
    public boolean supports(IServer server, Object launchable, String launchMode) {
        if (launchable == null) {
            return false;
        }
        try {
            return this.getDelegate().supports(server, launchable, launchMode);
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate " + this.toString(), e);
            }
            return false;
        }
    }

    @Override
    public IStatus launch(IServer server, Object launchable, String launchMode, ILaunch launch) {
        try {
            return this.getDelegate().launch(server, launchable, launchMode, launch);
        }
        catch (Exception e) {
            if (Trace.SEVERE) {
                Trace.trace("/severe", "Error calling delegate " + this.toString(), e);
            }
            return new Status(4, "org.eclipse.wst.server.core", e.getMessage(), (Throwable)e);
        }
    }

    public String toString() {
        return "Client[" + this.getId() + "]";
    }
}

