/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.editor.icon;

import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.wb.core.editor.icon.AbstractClasspathImageProcessor;
import org.eclipse.wb.core.model.IGenericProperty;
import org.eclipse.wb.core.model.IImageProcessor;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.internal.core.editor.icon.ImageProcessorHelper;
import org.eclipse.wb.internal.core.model.clipboard.IClipboardSourceProvider;
import org.eclipse.wb.internal.core.model.property.GenericProperty;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.editor.TextDialogPropertyEditor;
import org.eclipse.wb.internal.core.utils.ast.AstEditor;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.AbstractImageDialog;
import org.eclipse.wb.internal.core.utils.ui.dialogs.image.ImageInfo;

public abstract class AbstractImagePropertyEditor
extends TextDialogPropertyEditor
implements IClipboardSourceProvider {
    private final Class<?> imageType;

    protected AbstractImagePropertyEditor(Class<?> imageType) {
        this.imageType = imageType;
    }

    protected abstract AbstractImageDialog createImageDialog(IJavaProject var1);

    protected String getText(Property property) throws Exception {
        if (property.getValue() != Property.UNKNOWN_VALUE) {
            String[] value = new String[1];
            ImageProcessorHelper.process(this.imageType, p -> p.process((GenericProperty)property, value));
            return value[0];
        }
        return null;
    }

    @Override
    public String getClipboardSource(GenericProperty property) throws Exception {
        String[] text;
        IImageProcessor imageProcessor;
        if (property.getValue() != Property.UNKNOWN_VALUE && (imageProcessor = ImageProcessorHelper.process(this.imageType, arg_0 -> AbstractImagePropertyEditor.lambda$1(property, text = new String[1], arg_0))) != null) {
            Object[] path = new Object[1];
            imageProcessor.preOpen(property, text[0], path);
            String[] source = new String[1];
            if (imageProcessor instanceof AbstractClasspathImageProcessor) {
                AbstractClasspathImageProcessor classpathProcessor = (AbstractClasspathImageProcessor)imageProcessor;
                classpathProcessor.postOpen((IGenericProperty)property, (String)path[0], source);
            } else {
                ImageInfo imageInfo = new ImageInfo(imageProcessor.getPageId(), path[0], null, 0L);
                imageProcessor.postOpen(property, imageInfo, source);
            }
            return source[0];
        }
        return null;
    }

    protected void openDialog(Property property) throws Exception {
        Object[] input;
        GenericProperty genericProperty = (GenericProperty)property;
        JavaInfo javaInfo = genericProperty.getJavaInfo();
        AstEditor editor = javaInfo.getEditor();
        IJavaProject javaProject = editor.getJavaProject();
        AbstractImageDialog imageDialog = this.createImageDialog(javaProject);
        String text = this.getText(property);
        IImageProcessor imageProcessor = ImageProcessorHelper.process(this.imageType, arg_0 -> AbstractImagePropertyEditor.lambda$2(genericProperty, text, input = new Object[1], arg_0));
        if (imageProcessor != null) {
            imageDialog.setInput(imageProcessor.getPageId(), input[0]);
        }
        if (imageDialog.open() == 0) {
            ImageInfo imageInfo = imageDialog.getImageInfo();
            String[] source = new String[1];
            ImageProcessorHelper.process(this.imageType, p -> p.postOpen(genericProperty, imageInfo, source));
            genericProperty.setExpression(source[0], Property.UNKNOWN_VALUE);
        }
    }

    private static /* synthetic */ boolean lambda$1(GenericProperty genericProperty, String[] stringArray, IImageProcessor p) {
        return p.process(genericProperty, stringArray);
    }

    private static /* synthetic */ boolean lambda$2(GenericProperty genericProperty, String string, Object[] objectArray, IImageProcessor p) {
        return p.preOpen(genericProperty, string, objectArray);
    }
}

