/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryresult;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.viatra.query.runtime.api.IPatternMatch;
import org.eclipse.viatra.query.tooling.ui.queryresult.IQueryResultViewModelListener;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeInput;
import org.eclipse.viatra.query.tooling.ui.queryresult.QueryResultTreeMatcher;
import org.eclipse.viatra.query.tooling.ui.queryresult.util.QueryResultViewUtil;
import org.eclipse.xtext.xbase.lib.Conversions;

class QueryResultTreeContentProvider
implements ITreeContentProvider,
IQueryResultViewModelListener {
    protected TreeViewer viewer;
    protected QueryResultTreeInput input;
    protected AdapterFactoryContentProvider adapterFactoryContentProvider;

    public QueryResultTreeContentProvider() {
        AdapterFactoryContentProvider _adapterFactoryContentProvider;
        AdapterFactory adapterFactory = QueryResultViewUtil.getGenericAdapterFactory();
        this.adapterFactoryContentProvider = _adapterFactoryContentProvider = new AdapterFactoryContentProvider(adapterFactory);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        Preconditions.checkArgument((boolean)(viewer instanceof TreeViewer));
        this.viewer = (TreeViewer)viewer;
        if (oldInput instanceof QueryResultTreeInput) {
            ((QueryResultTreeInput)oldInput).removeListener(this);
        }
        if (newInput instanceof QueryResultTreeInput) {
            this.input = (QueryResultTreeInput)newInput;
            ((QueryResultTreeInput)newInput).addListener(this);
        } else if (newInput != null) {
            String _format = String.format("Invalid input type %s for List Viewer.", newInput.getClass().getName());
            throw new IllegalArgumentException(_format);
        }
    }

    public void dispose() {
        QueryResultTreeInput _input = this.input;
        if (_input != null) {
            _input.removeListener(this);
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        return this.getChildrenInternal(parentElement);
    }

    protected Object[] _getChildrenInternal(QueryResultTreeInput inputElement) {
        return (Object[])Conversions.unwrapArray(inputElement.getMatchers().values(), Object.class);
    }

    protected Object[] _getChildrenInternal(QueryResultTreeMatcher<?> inputElement) {
        boolean _tripleNotEquals;
        Exception _exception = inputElement.getException();
        boolean bl = _tripleNotEquals = _exception != null;
        if (_tripleNotEquals) {
            return null;
        }
        return (Object[])Conversions.unwrapArray(inputElement.getFilteredMatches(), Object.class);
    }

    protected Object[] _getChildrenInternal(IPatternMatch inputElement) {
        boolean _not;
        boolean _isEmpty = inputElement.parameterNames().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            return inputElement.toArray();
        }
        return null;
    }

    protected Object[] _getChildrenInternal(Object inputElement) {
        return null;
    }

    public Object getParent(Object element) {
        return this.getParentInternal(element);
    }

    protected Object _getParentInternal(QueryResultTreeInput inputElement) {
        return null;
    }

    protected Object _getParentInternal(QueryResultTreeMatcher<?> inputElement) {
        return inputElement.getParent();
    }

    protected Object _getParentInternal(IPatternMatch inputElement) {
        return this.input.getMatchers().get(inputElement.specification().getFullyQualifiedName());
    }

    protected Object _getParentInternal(Object inputElement) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return this.hasChildrenInternal(element);
    }

    protected boolean _hasChildrenInternal(QueryResultTreeInput inputElement) {
        boolean _isEmpty = inputElement.getMatchers().isEmpty();
        return !_isEmpty;
    }

    protected boolean _hasChildrenInternal(QueryResultTreeMatcher<?> inputElement) {
        boolean _tripleNotEquals;
        Exception _exception = inputElement.getException();
        boolean bl = _tripleNotEquals = _exception != null;
        if (_tripleNotEquals) {
            return false;
        }
        int _matchCount = inputElement.getMatchCount();
        return _matchCount > 0;
    }

    protected boolean _hasChildrenInternal(IPatternMatch inputElement) {
        boolean _not;
        boolean _isEmpty = inputElement.parameterNames().isEmpty();
        boolean bl = _not = !_isEmpty;
        return _not;
    }

    protected boolean _hasChildrenInternal(Object inputElement) {
        return false;
    }

    @Override
    public void matcherAdded(QueryResultTreeMatcher<?> matcher) {
        Runnable _function = () -> {
            boolean _not;
            boolean _isDisposed = this.viewer.getTree().isDisposed();
            boolean bl = _not = !_isDisposed;
            if (_not) {
                this.viewer.add((Object)matcher.getParent(), (Object)matcher);
            }
        };
        this.viewer.getTree().getDisplay().asyncExec(_function);
    }

    @Override
    public void matcherFilterUpdated(QueryResultTreeMatcher<?> matcher) {
        matcher.setMatchCount(matcher.countFilteredMatches());
        Runnable _function = () -> {
            boolean _not;
            boolean _isDisposed = this.viewer.getTree().isDisposed();
            boolean bl = _not = !_isDisposed;
            if (_not) {
                this.viewer.refresh((Object)matcher);
            }
        };
        this.viewer.getTree().getDisplay().asyncExec(_function);
    }

    @Override
    public void matcherRemoved(QueryResultTreeMatcher<?> matcher) {
        Runnable _function = () -> {
            boolean _not;
            boolean _isDisposed = this.viewer.getTree().isDisposed();
            boolean bl = _not = !_isDisposed;
            if (_not) {
                this.viewer.remove((Object)matcher);
            }
        };
        this.viewer.getTree().getDisplay().asyncExec(_function);
    }

    @Override
    public void matchAdded(QueryResultTreeMatcher<?> matcher, IPatternMatch match) {
        boolean _isCompatibleWith = matcher.getFilterMatch().isCompatibleWith(match);
        if (_isCompatibleWith) {
            int _matchCount = matcher.getMatchCount();
            int _plus = _matchCount + 1;
            matcher.setMatchCount(_plus);
        }
        Runnable _function = () -> {
            boolean _not;
            boolean _isDisposed = this.viewer.getTree().isDisposed();
            boolean bl = _not = !_isDisposed;
            if (_not) {
                this.viewer.add((Object)matcher, (Object)match);
                this.viewer.update((Object)matcher, null);
            }
        };
        this.viewer.getTree().getDisplay().asyncExec(_function);
    }

    @Override
    public void matchUpdated(QueryResultTreeMatcher<?> matcher, IPatternMatch match) {
        Runnable _function = () -> {
            boolean _not;
            boolean _isDisposed = this.viewer.getTree().isDisposed();
            boolean bl = _not = !_isDisposed;
            if (_not) {
                this.viewer.refresh((Object)match);
                this.viewer.update((Object)matcher, null);
            }
        };
        this.viewer.getTree().getDisplay().asyncExec(_function);
    }

    @Override
    public void matchRemoved(QueryResultTreeMatcher<?> matcher, IPatternMatch match) {
        boolean _isCompatibleWith = matcher.getFilterMatch().isCompatibleWith(match);
        if (_isCompatibleWith) {
            int _matchCount = matcher.getMatchCount();
            int _minus = _matchCount - 1;
            matcher.setMatchCount(_minus);
        }
        Runnable _function = () -> {
            boolean _not;
            boolean _isDisposed = this.viewer.getTree().isDisposed();
            boolean bl = _not = !_isDisposed;
            if (_not) {
                this.viewer.remove((Object)match);
                this.viewer.update((Object)matcher, null);
            }
        };
        this.viewer.getTree().getDisplay().asyncExec(_function);
    }

    public Object[] getChildrenInternal(Object inputElement) {
        if (inputElement instanceof IPatternMatch) {
            return this._getChildrenInternal((IPatternMatch)inputElement);
        }
        if (inputElement instanceof QueryResultTreeInput) {
            return this._getChildrenInternal((QueryResultTreeInput)inputElement);
        }
        if (inputElement instanceof QueryResultTreeMatcher) {
            return this._getChildrenInternal((QueryResultTreeMatcher)inputElement);
        }
        if (inputElement != null) {
            return this._getChildrenInternal(inputElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputElement).toString());
    }

    public Object getParentInternal(Object inputElement) {
        if (inputElement instanceof IPatternMatch) {
            return this._getParentInternal((IPatternMatch)inputElement);
        }
        if (inputElement instanceof QueryResultTreeInput) {
            return this._getParentInternal((QueryResultTreeInput)inputElement);
        }
        if (inputElement instanceof QueryResultTreeMatcher) {
            return this._getParentInternal((QueryResultTreeMatcher)inputElement);
        }
        if (inputElement != null) {
            return this._getParentInternal(inputElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputElement).toString());
    }

    public boolean hasChildrenInternal(Object inputElement) {
        if (inputElement instanceof IPatternMatch) {
            return this._hasChildrenInternal((IPatternMatch)inputElement);
        }
        if (inputElement instanceof QueryResultTreeInput) {
            return this._hasChildrenInternal((QueryResultTreeInput)inputElement);
        }
        if (inputElement instanceof QueryResultTreeMatcher) {
            return this._hasChildrenInternal((QueryResultTreeMatcher)inputElement);
        }
        if (inputElement != null) {
            return this._hasChildrenInternal(inputElement);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(inputElement).toString());
    }
}

