/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.patternlanguage.emf.ui;

import com.google.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.viatra.query.tooling.core.project.ProjectGenerationHelper;
import org.eclipse.viatra.query.tooling.ui.migrator.JavaProjectMigrator;
import org.eclipse.viatra.query.tooling.ui.migrator.metadata.NatureUpdaterJob;
import org.eclipse.xtext.builder.EclipseOutputConfigurationProvider;
import org.eclipse.xtext.builder.nature.NatureAddingEditorCallback;
import org.eclipse.xtext.ui.editor.XtextEditor;

public class EMFPatternLanguageEditorCallback
extends NatureAddingEditorCallback {
    @Inject
    private Logger logger;
    @Inject
    private EclipseOutputConfigurationProvider outputConfigurationProvider;

    public void afterCreatePartControl(XtextEditor editor) {
        try {
            IProject project;
            IResource resource = editor.getResource();
            if (resource != null && (project = resource.getProject()).isAccessible() && !project.isHidden() && !project.hasNature("org.eclipse.viatra.query.projectnature")) {
                String question;
                String string = question = ProjectGenerationHelper.isOpenPDEProject((IProject)project) ? String.format("Do you want to convert project %s to a VIATRA Query Project?", project.getName()) : String.format("Do you want to convert project %s to a VIATRA Query Project? (Note: dependencies to VIATRA Query runtime will have to be set up manually.)", project.getName());
                if (MessageDialog.openQuestion((Shell)editor.getShell(), (String)"Invalid VIATRA Query Project", (String)question)) {
                    NatureUpdaterJob job = new NatureUpdaterJob(project, this.outputConfigurationProvider);
                    job.schedule();
                    JavaProjectMigrator migrator = new JavaProjectMigrator(project);
                    migrator.migrate((IProgressMonitor)new NullProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            this.logger.error((Object)"Error checking project nature", (Throwable)e);
        }
    }
}

