/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.ImageCache;
import org.eclipse.tcf.internal.debug.ui.commands.AbstractActionDelegate;
import org.eclipse.tcf.internal.debug.ui.model.ICastToType;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExpression;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.ISymbols;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchWindow;

public class CastToArrayCommand
extends AbstractActionDelegate {
    private String base_type_name;
    private String cur_length;
    private TCFNode cur_node;

    private void getBaseTypeName() {
        this.base_type_name = null;
        this.cur_length = null;
        this.cur_node = this.getSelectedNode();
        if (this.cur_node == null) {
            return;
        }
        if (!(this.cur_node instanceof ICastToType)) {
            return;
        }
        if (this.cur_node instanceof TCFNodeExpression && !((TCFNodeExpression)this.cur_node).isEnabled()) {
            return;
        }
        try {
            new TCFTask<Boolean>(this.cur_node.getChannel()){

                public void run() {
                    String cast = CastToArrayCommand.this.cur_node.getModel().getCastToType(CastToArrayCommand.this.cur_node.getID());
                    if (cast != null) {
                        int i;
                        if (cast.endsWith("]") && (i = cast.lastIndexOf(91)) > 0) {
                            CastToArrayCommand.this.base_type_name = cast.substring(0, i);
                            CastToArrayCommand.this.cur_length = cast.substring(i + 1, cast.length() - 1);
                            this.done(Boolean.TRUE);
                            return;
                        }
                        this.done(Boolean.FALSE);
                        return;
                    }
                    TCFDataCache<ISymbols.Symbol> type_cache = ((ICastToType)((Object)CastToArrayCommand.this.cur_node)).getType();
                    if (!type_cache.validate((Runnable)((Object)this))) {
                        return;
                    }
                    ISymbols.Symbol type_data = (ISymbols.Symbol)type_cache.getData();
                    if (type_data != null && type_data.getTypeClass() == ISymbols.TypeClass.pointer) {
                        int i = 0;
                        while (true) {
                            TCFDataCache<ISymbols.Symbol> base_type_cache;
                            if (!(base_type_cache = CastToArrayCommand.this.cur_node.getModel().getSymbolInfoCache(type_data.getBaseTypeID())).validate((Runnable)((Object)this))) {
                                return;
                            }
                            ISymbols.Symbol base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                            if (base_type_data == null) {
                                this.done(Boolean.FALSE);
                                return;
                            }
                            if (base_type_data.getName() != null) {
                                CastToArrayCommand.this.base_type_name = this.makePtrTypeName(base_type_data.getName(), i);
                                this.done(Boolean.TRUE);
                                return;
                            }
                            if (base_type_data.getTypeClass() != ISymbols.TypeClass.pointer) {
                                if (!base_type_data.getID().equals(base_type_data.getTypeID())) {
                                    base_type_cache = CastToArrayCommand.this.cur_node.getModel().getSymbolInfoCache(base_type_data.getTypeID());
                                    if (!base_type_cache.validate((Runnable)((Object)this))) {
                                        return;
                                    }
                                    base_type_data = (ISymbols.Symbol)base_type_cache.getData();
                                    if (base_type_data != null && base_type_data.getName() != null) {
                                        CastToArrayCommand.this.base_type_name = this.makePtrTypeName(base_type_data.getName(), i);
                                        this.done(Boolean.TRUE);
                                    } else {
                                        this.done(Boolean.FALSE);
                                    }
                                    return;
                                }
                                this.done(Boolean.FALSE);
                                return;
                            }
                            type_data = base_type_data;
                            ++i;
                        }
                    }
                    this.done(Boolean.FALSE);
                }

                private String makePtrTypeName(String base, int cnt) {
                    StringBuffer bf = new StringBuffer();
                    bf.append(base);
                    if (cnt > 0) {
                        bf.append(' ');
                        while (cnt > 0) {
                            bf.append('*');
                            --cnt;
                        }
                    }
                    return bf.toString();
                }
            }.get();
        }
        catch (Throwable x) {
            Activator.log(x);
        }
    }

    @Override
    protected void run() {
        IWorkbenchWindow window = Activator.getDefault().getWorkbench().getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        this.getBaseTypeName();
        if (this.base_type_name == null) {
            return;
        }
        CastToTypeDialog dialog = new CastToTypeDialog(window.getShell(), this.cur_length);
        if (dialog.open() != 0) {
            return;
        }
        final String new_type = dialog.getValue().trim();
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                CastToArrayCommand.this.cur_node.getModel().setCastToType(CastToArrayCommand.this.cur_node.getID(), String.valueOf(CastToArrayCommand.this.base_type_name) + "[" + new_type + "]");
            }
        });
    }

    @Override
    protected void selectionChanged() {
        this.getBaseTypeName();
        this.setEnabled(this.base_type_name != null);
    }

    private static class CastToTypeDialog
    extends InputDialog {
        public CastToTypeDialog(Shell shell, String initial_value) {
            super(shell, "Cast To Array", "Enter array length", initial_value, (IInputValidator)new CastToTypeInputValidator());
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setImage(ImageCache.getImage("icons/tcf"));
        }
    }

    private static class CastToTypeInputValidator
    implements IInputValidator {
        private CastToTypeInputValidator() {
        }

        public String isValid(String new_text) {
            block4: {
                try {
                    if (new_text.length() != 0) break block4;
                    return "";
                }
                catch (Exception x) {
                    return "Invalid number";
                }
            }
            int i = Integer.parseInt(new_text);
            if (i < 1) {
                return "Array length must be >= 1";
            }
            return null;
        }
    }
}

