/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner;

import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.qvtd.compiler.ProblemHandler;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.trace.Element2MiddleProperty;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionsAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionClassAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.analysis.PartialRegionPropertyAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.LegacyPartitioningStrategy;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartitionFactory;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.NonPartitioningStrategy;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitionedTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.PartitioningStrategy;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.ReachabilityPartitioningStrategy;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtschedule.BasicPartition;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.DispatchRegion;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.MappingRegion;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigationEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.Region;
import org.eclipse.qvtd.pivot.qvtschedule.Role;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.VerdictRegion;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;

public class MappingPartitioner
implements Nameable {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    protected final @NonNull RegionAnalysis regionAnalysis;
    protected final @NonNull MappingRegion region;
    private final @NonNull Set<@NonNull Edge> alreadyConstantEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Edge> alreadyLoadedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Edge> alreadyCheckedEdges = new HashSet<Edge>();
    private final @NonNull Set<@NonNull Node> alreadyCheckedNodes = new HashSet<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull BasicPartition> alreadyRealizedEdges = new HashMap<Edge, BasicPartition>();
    private final @NonNull Set<@NonNull Node> alreadyRealizedNodes = new HashSet<Node>();
    private final @NonNull Map<@NonNull Edge, @NonNull List<@NonNull BasicPartition>> debugEdge2partitions = new HashMap<Edge, List<BasicPartition>>();

    public MappingPartitioner(@NonNull TransformationPartitioner transformationPartitioner, @NonNull RegionAnalysis regionAnalysis) {
        this.scheduleManager = transformationPartitioner.getScheduleManager();
        this.transformationAnalysis = transformationPartitioner.getTransformationAnalysis();
        this.regionAnalysis = regionAnalysis;
        this.region = (MappingRegion)regionAnalysis.getRegion();
    }

    public boolean addCheckedNode(@NonNull Node node) {
        return this.alreadyCheckedNodes.add(node);
    }

    public void addEdge(@NonNull Edge edge, @NonNull Role newEdgeRole, @NonNull BasicPartition partition) {
        if (newEdgeRole == Role.CONSTANT) {
            this.alreadyConstantEdges.add(edge);
        } else if (newEdgeRole == Role.LOADED) {
            this.alreadyLoadedEdges.add(edge);
        } else if (newEdgeRole == Role.PREDICATED) {
            this.alreadyCheckedEdges.add(edge);
        } else if (newEdgeRole == Role.SPECULATED) {
            this.alreadyCheckedEdges.add(edge);
        } else if (newEdgeRole == Role.REALIZED) {
            this.alreadyRealizedEdges.put(edge, partition);
        }
        List<@NonNull BasicPartition> partitions = this.debugEdge2partitions.get(edge);
        if (partitions == null) {
            partitions = new ArrayList<BasicPartition>();
            this.debugEdge2partitions.put(edge, partitions);
        }
        assert (!partitions.contains(partition));
        partitions.add(partition);
    }

    public boolean addRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.add(node);
    }

    public @Nullable Node basicGetDispatchNode() {
        return this.regionAnalysis.basicGetDispatchNode();
    }

    public @Nullable SuccessEdge basicGetGlobalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetGlobalSuccessEdge(traceNode);
    }

    public @Nullable Node basicGetGlobalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetGlobalSuccessNode(traceNode);
    }

    public @Nullable SuccessEdge basicGetLocalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetLocalSuccessEdge(traceNode);
    }

    public @Nullable Node basicGetLocalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.basicGetLocalSuccessNode(traceNode);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    void check() {
        for (Node node : QVTscheduleUtil.getOwnedNodes((Region)this.region)) {
            if ((!node.isSpeculated() || node.isHead()) && !node.isRealized() || this.hasRealizedNode(node)) continue;
            CompilerUtil.addRegionError(this.getProblemHandler(), (Region)this.region, "Should have realized " + node, new Object[0]);
        }
        HashSet<@NonNull Edge> allPrimaryEdges = new HashSet<Edge>();
        for (Edge edge : QVTscheduleUtil.getOwnedEdges((Region)this.region)) {
            if (edge.isSecondary()) continue;
            allPrimaryEdges.add(edge);
            if (!edge.isRealized() || this.hasRealizedEdge(edge) || edge.isExpression()) continue;
            CompilerUtil.addRegionError(this.getProblemHandler(), (Region)this.region, "Should have realized " + edge, new Object[0]);
        }
        Set<@NonNull Node> deadNodes = this.computeDeadNodes(QVTscheduleUtil.getOwnedNodes((Region)this.region));
        Set<@NonNull Edge> deadEdges = this.computeDeadEdges(deadNodes);
        allPrimaryEdges.removeAll(deadEdges);
        HashSet<@NonNull Edge> partitionedEdges = new HashSet<Edge>(this.debugEdge2partitions.keySet());
        if (!partitionedEdges.equals(allPrimaryEdges)) {
            @NonNull HashSet extraEdgesSet = Sets.newHashSet(partitionedEdges);
            CompilerUtil.removeAll(extraEdgesSet, allPrimaryEdges);
            for (Edge edge : extraEdgesSet) {
                if (edge.isSecondary()) continue;
                List<@NonNull BasicPartition> extraPartitions = this.debugEdge2partitions.get(edge);
                CompilerUtil.addRegionWarning(this.getProblemHandler(), (Region)this.region, "Extra " + edge, new Object[0]);
            }
            @NonNull HashSet missingEdgesSet = Sets.newHashSet(allPrimaryEdges);
            missingEdgesSet.removeAll(partitionedEdges);
            for (Edge edge : missingEdgesSet) {
                if (edge instanceof NavigationEdge && this.transformationAnalysis.getCorollaryOf((NavigationEdge)edge) != null) continue;
                CompilerUtil.addRegionWarning(this.getProblemHandler(), (Region)this.region, "Missing " + edge, new Object[0]);
            }
        }
    }

    private @NonNull Set<@NonNull Edge> computeDeadEdges(@NonNull Iterable<@NonNull Node> deadNodes) {
        HashSet<@NonNull Edge> deadEdges = new HashSet<Edge>();
        for (Node node : deadNodes) {
            Iterables.addAll(deadEdges, (Iterable)QVTscheduleUtil.getIncomingEdges((Node)node));
            Iterables.addAll(deadEdges, (Iterable)QVTscheduleUtil.getOutgoingEdges((Node)node));
        }
        return deadEdges;
    }

    /*
     * Unable to fully structure code
     */
    private @NonNull Set<@NonNull Node> computeDeadNodes(@NonNull Iterable<@NonNull Node> nodes) {
        deadNodes = new HashSet<Node>();
        moreDeadNodes = null;
        for (Node node : nodes) {
            if (node.isHead() || !this.isDead(node, null)) continue;
            if (moreDeadNodes == null) {
                moreDeadNodes = new HashSet<Node>();
            }
            moreDeadNodes.add(node);
        }
        if (moreDeadNodes != null) ** GOTO lbl27
        return deadNodes;
lbl-1000:
        // 1 sources

        {
            deadNodes.addAll((Collection<Node>)moreDeadNodes);
            moreDeadNodesList = new ArrayList<E>(moreDeadNodes);
            moreDeadNodes = null;
            for (Node deadNode : moreDeadNodesList) {
                for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)deadNode)) {
                    sourceNode = edge.getEdgeSource();
                    if (sourceNode.isHead() || !this.isDead(sourceNode, deadNodes)) continue;
                    if (moreDeadNodes == null) {
                        moreDeadNodes = new HashSet<E>();
                    }
                    moreDeadNodes.add(sourceNode);
                }
            }
            if (moreDeadNodes == null) break;
lbl27:
            // 2 sources

            ** while (moreDeadNodes.size() > 0)
        }
lbl28:
        // 2 sources

        return deadNodes;
    }

    private @NonNull PartitioningStrategy createPartitioningStrategy(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        boolean useActivators = this.scheduleManager.useActivators();
        if (useActivators) {
            Element2MiddleProperty relation2GlobalSuccessProperty = this.regionAnalysis.getRuleAnalysis().getRule2TraceGroup().basicGetRelation2GlobalSuccessProperty();
            if (relation2GlobalSuccessProperty == null) {
                return new NonPartitioningStrategy(partitionedTransformationAnalysis, this);
            }
            return new ReachabilityPartitioningStrategy(partitionedTransformationAnalysis, this);
        }
        return new LegacyPartitioningStrategy(partitionedTransformationAnalysis, this);
    }

    public @NonNull Iterable<@NonNull Edge> getAlreadyRealizedEdges() {
        return this.alreadyRealizedEdges.keySet();
    }

    public @NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis> getClassAnalysis(@NonNull Node traceNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)traceNode);
        return this.transformationAnalysis.getClassAnalysis(classDatum);
    }

    public @NonNull Iterable<@NonNull Node> getConstantInputNodes() {
        return this.regionAnalysis.getConstantInputNodes();
    }

    public @NonNull Iterable<@NonNull Node> getConstantOutputNodes() {
        return this.regionAnalysis.getConstantOutputNodes();
    }

    public @Nullable Iterable<@NonNull PartialRegionClassAnalysis<@NonNull RegionsAnalysis>> getConsumedClassAnalyses() {
        return this.regionAnalysis.getConsumedClassAnalyses();
    }

    public @Nullable Iterable<@NonNull PartialRegionPropertyAnalysis<@NonNull RegionsAnalysis>> getConsumedPropertyAnalyses() {
        return this.regionAnalysis.getConsumedPropertyAnalyses();
    }

    public @Nullable List<@NonNull Region> getCorollaryOf(@NonNull NavigationEdge edge) {
        return this.transformationAnalysis.getCorollaryOf(edge);
    }

    public @NonNull Iterable<@NonNull Node> getExecutionNodes() {
        return Iterables.concat(this.getPredicatedExecutionNodes(), this.getRealizedExecutionNodes());
    }

    public @NonNull SuccessEdge getGlobalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.getGlobalSuccessEdge(traceNode);
    }

    public @NonNull Node getGlobalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.getGlobalSuccessNode(traceNode);
    }

    public @NonNull SuccessEdge getLocalSuccessEdge(@NonNull Node traceNode) {
        return this.regionAnalysis.getLocalSuccessEdge(traceNode);
    }

    public @NonNull Node getLocalSuccessNode(@NonNull Node traceNode) {
        return this.regionAnalysis.getLocalSuccessNode(traceNode);
    }

    public String getName() {
        return this.region.getName();
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getOldPrimaryNavigableEdges() {
        return this.regionAnalysis.getOldPrimaryNavigableEdges();
    }

    public @NonNull Iterable<@NonNull Edge> getPredicatedEdges() {
        return this.regionAnalysis.getPredicatedEdges();
    }

    public @NonNull List<@NonNull Node> getPredicatedExecutionNodes() {
        ArrayList<@NonNull Node> predicatedExecutionNodes = new ArrayList<Node>();
        for (Node node : this.getPredicatedMiddleNodes()) {
            if (!"trace".equals(node.getName())) continue;
            assert (node.isTrace());
            predicatedExecutionNodes.add(node);
        }
        return predicatedExecutionNodes;
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedMiddleNodes() {
        return this.regionAnalysis.getPredicatedMiddleNodes();
    }

    public @NonNull Iterable<@NonNull Node> getPredicatedOutputNodes() {
        return this.regionAnalysis.getPredicatedOutputNodes();
    }

    public @NonNull List<@NonNull Node> getPredicatedWhenNodes() {
        ArrayList<@NonNull Node> predicatedWhenNodes = new ArrayList<Node>();
        for (Node node : this.getPredicatedMiddleNodes()) {
            if (!node.getName().startsWith("when_")) continue;
            predicatedWhenNodes.add(node);
        }
        return predicatedWhenNodes;
    }

    public @NonNull ProblemHandler getProblemHandler() {
        return this.scheduleManager.getProblemHandler();
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedEdges() {
        return this.regionAnalysis.getRealizedEdges();
    }

    public @NonNull List<@NonNull Node> getRealizedExecutionNodes() {
        ArrayList<@NonNull Node> realizedExecutionNodes = new ArrayList<Node>();
        for (Node node : this.getRealizedMiddleNodes()) {
            if (!"trace".equals(node.getName())) continue;
            realizedExecutionNodes.add(node);
        }
        return realizedExecutionNodes;
    }

    public @NonNull Iterable<@NonNull Node> getRealizedMiddleNodes() {
        return this.regionAnalysis.getRealizedMiddleNodes();
    }

    public @NonNull Iterable<@NonNull NavigableEdge> getRealizedOutputEdges() {
        return this.regionAnalysis.getRealizedOutputEdges();
    }

    public @NonNull Iterable<@NonNull Node> getRealizedOutputNodes() {
        return this.regionAnalysis.getRealizedOutputNodes();
    }

    public @NonNull List<@NonNull Node> getRealizedWhenNodes() {
        ArrayList<@NonNull Node> realizedWhenNodes = new ArrayList<Node>();
        for (Node node : this.getRealizedMiddleNodes()) {
            if (!node.getName().startsWith("when_")) continue;
            realizedWhenNodes.add(node);
        }
        return realizedWhenNodes;
    }

    public @NonNull List<@NonNull Node> getRealizedWhereNodes() {
        ArrayList<@NonNull Node> realizedWhereNodes = new ArrayList<Node>();
        for (Node node : this.getRealizedMiddleNodes()) {
            if (!node.getName().startsWith("where_")) continue;
            realizedWhereNodes.add(node);
        }
        return realizedWhereNodes;
    }

    public @Nullable BasicPartition getRealizingPartition(@NonNull Edge edge) {
        return this.alreadyRealizedEdges.get(edge);
    }

    public @NonNull MappingRegion getRegion() {
        return this.region;
    }

    public @NonNull RegionAnalysis getRegionAnalysis() {
        return this.regionAnalysis;
    }

    protected @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    public @NonNull Iterable<@NonNull SuccessEdge> getSuccessEdges() {
        return this.regionAnalysis.getSuccessEdges();
    }

    public @Nullable Node getThisNode() {
        return this.regionAnalysis.getThisNode();
    }

    public @Nullable Edge getTraceEdge(@NonNull Node node) {
        return this.regionAnalysis.getTraceEdge(node);
    }

    public @NonNull Node getTraceNode() {
        List<@NonNull Node> traceNodes = this.getTraceNodes();
        assert (traceNodes.size() == 1);
        return (Node)ClassUtil.nonNullState((Object)traceNodes.get(0));
    }

    public @NonNull List<@NonNull Node> getTraceNodes() {
        return this.regionAnalysis.getTraceNodes();
    }

    public @NonNull AbstractTransformationAnalysis getTransformationAnalysis() {
        return this.transformationAnalysis;
    }

    public boolean hasCheckedEdge(@NonNull Edge edge) {
        return this.alreadyCheckedEdges.contains(edge);
    }

    public boolean hasCheckedNode(@NonNull Node node) {
        return this.alreadyCheckedNodes.contains(node);
    }

    public boolean hasConstantEdge(@NonNull Edge edge) {
        return this.alreadyConstantEdges.contains(edge);
    }

    public boolean hasLoadedEdge(@NonNull Edge edge) {
        return this.alreadyLoadedEdges.contains(edge);
    }

    public boolean hasRealizedEdge(@NonNull Edge edge) {
        return this.alreadyRealizedEdges.containsKey(edge);
    }

    public boolean hasRealizedNode(@NonNull Node node) {
        return this.alreadyRealizedNodes.contains(node);
    }

    public boolean isCyclic(@NonNull Node traceNode) {
        ClassDatum classDatum = QVTscheduleUtil.getClassDatum((Node)traceNode);
        return this.transformationAnalysis.isCyclic(classDatum);
    }

    private boolean isDead(@NonNull Node node, @Nullable Set<@NonNull Node> knownDeadNodes) {
        if (node.isHead()) {
            return false;
        }
        for (Edge edge : QVTscheduleUtil.getIncomingEdges((Node)node)) {
            assert (!edge.isCast());
            if (!edge.isNavigation() && (!edge.isPredicate() || edge.isPartial()) || knownDeadNodes != null && knownDeadNodes.contains(edge.getEdgeSource())) continue;
            return false;
        }
        for (Edge edge : QVTscheduleUtil.getOutgoingEdges((Node)node)) {
            assert (!edge.isCast());
            if (!edge.isNavigation() && !edge.isExpression() || knownDeadNodes != null && knownDeadNodes.contains(edge.getEdgeTarget())) continue;
            return false;
        }
        return true;
    }

    public @NonNull Iterable<@NonNull PartitionAnalysis> partition(@NonNull PartitionedTransformationAnalysis partitionedTransformationAnalysis) {
        if (this.region instanceof DispatchRegion || this.region instanceof VerdictRegion) {
            return Collections.singletonList(new NonPartitionFactory(this).createPartitionAnalysis(partitionedTransformationAnalysis));
        }
        PartitioningStrategy partitioningStrategy = this.createPartitioningStrategy(partitionedTransformationAnalysis);
        return partitioningStrategy.partition();
    }

    public String toString() {
        return this.region.getName();
    }
}

