/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.widgets;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.infra.nattable.model.nattable.Table;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxis.ITreeItemAxis;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.AxisManagerRepresentation;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisconfiguration.TableHeaderAxisConfiguration;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.AbstractAxisProvider;
import org.eclipse.papyrus.infra.nattable.model.nattable.nattableaxisprovider.NattableaxisproviderPackage;
import org.eclipse.papyrus.infra.nattable.tree.ITreeItemAxisHelper;
import org.eclipse.papyrus.infra.nattable.utils.HeaderAxisConfigurationManagementUtils;
import org.eclipse.papyrus.infra.nattable.utils.TableHelper;
import org.eclipse.papyrus.uml.properties.widgets.NattablePropertyEditor;
import org.eclipse.swt.widgets.Composite;

public class TreeNattablePropertyEditor
extends NattablePropertyEditor {
    public TreeNattablePropertyEditor(Composite parent, int style) {
        super(parent, style);
    }

    @Override
    protected void configureTable(TransactionalEditingDomain domain, Table table, EObject sourceElement, EStructuralFeature synchronizedFeature, Collection<?> rows, CompoundCommand command) {
        super.configureTable(domain, table, sourceElement, synchronizedFeature, rows, command);
        if (TableHelper.isTreeTable((Table)table) && rows != null && !rows.isEmpty()) {
            AbstractAxisProvider axisProvider = table.getCurrentRowAxisProvider();
            TableHeaderAxisConfiguration conf = (TableHeaderAxisConfiguration)HeaderAxisConfigurationManagementUtils.getRowAbstractHeaderAxisInTableConfiguration((Table)table);
            AxisManagerRepresentation rep = (AxisManagerRepresentation)conf.getAxisManagers().get(0);
            for (Object context : rows) {
                this.addTreeItemAxis(domain, axisProvider, rep, context, command);
            }
        }
    }

    protected void addTreeItemAxis(TransactionalEditingDomain domain, AbstractAxisProvider axisProvider, AxisManagerRepresentation rep, Object object, CompoundCommand command) {
        ITreeItemAxis axis = ITreeItemAxisHelper.createITreeItemAxis(null, null, (Object)object, (AxisManagerRepresentation)rep);
        Command addCommand = AddCommand.create((EditingDomain)this.getTableEditingDomain(), (Object)axisProvider, (Object)NattableaxisproviderPackage.eINSTANCE.getAxisProvider_Axis(), Collections.singleton(axis));
        command.append(addCommand);
    }
}

