/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.labels;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.uml.domain.services.labels.IDomainBasedEdgeEndLabelProvider;
import org.eclipse.papyrus.uml.domain.services.labels.INamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.LabelUtils;
import org.eclipse.papyrus.uml.domain.services.labels.domains.DefaultNamedElementNameProvider;
import org.eclipse.papyrus.uml.domain.services.labels.domains.MultiplicityLabelHelper;
import org.eclipse.papyrus.uml.domain.services.labels.domains.VisibilityLabelHelper;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.MultiplicityElement;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ElementDomainBasedEdgeSourceLabelProvider
implements IDomainBasedEdgeEndLabelProvider {
    private INamedElementNameProvider namedElementNameProvider;

    public ElementDomainBasedEdgeSourceLabelProvider(INamedElementNameProvider namedElementNameProvider) {
        this.namedElementNameProvider = namedElementNameProvider;
    }

    public static ElementDomainBasedEdgeSourceLabelProvider buildDefault() {
        return new ElementDomainBasedEdgeSourceLabelProvider(new DefaultNamedElementNameProvider());
    }

    @Override
    public String getLabel(EObject element, EObject semanticEnd) {
        String label = (String)new ElementDomainBasedEdgeSourceLabelProviderSwitch(this.namedElementNameProvider).doSwitch(element);
        if (label == null) {
            label = "";
        }
        return label;
    }

    public static final class ElementDomainBasedEdgeSourceLabelProviderSwitch
    extends UMLSwitch<String> {
        private MultiplicityLabelHelper multiplicityLabelHelper;
        private VisibilityLabelHelper visibilityLabelHelper;

        public ElementDomainBasedEdgeSourceLabelProviderSwitch(INamedElementNameProvider namedElementNameProvider) {
            this.multiplicityLabelHelper = new MultiplicityLabelHelper(namedElementNameProvider);
            this.visibilityLabelHelper = new VisibilityLabelHelper();
        }

        public String caseAssociation(Association association) {
            EList memberEnds = association.getMemberEnds();
            if (memberEnds.size() > 1) {
                StringBuilder associationSourceLabel = new StringBuilder();
                Property propert = (Property)memberEnds.get(1);
                associationSourceLabel.append(LabelUtils.getNonNullString(this.visibilityLabelHelper.getVisibilityAsSign((NamedElement)propert)));
                associationSourceLabel.append(" ");
                associationSourceLabel.append(propert.getName());
                associationSourceLabel.append(" ");
                associationSourceLabel.append(this.multiplicityLabelHelper.formatMultiplicityNoBrackets((MultiplicityElement)propert, false));
                return associationSourceLabel.toString();
            }
            return (String)super.caseAssociation(association);
        }

        public String caseConnector(Connector connector) {
            EList ends = connector.getEnds();
            if (ends.size() > 0) {
                return this.multiplicityLabelHelper.formatMultiplicityNoBrackets((MultiplicityElement)ends.get(0), false);
            }
            return (String)super.caseConnector(connector);
        }
    }
}

