/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.domain.services.drop.diagrams;

import java.util.Collections;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.ECrossReferenceAdapter;
import org.eclipse.papyrus.uml.domain.services.IEditableChecker;
import org.eclipse.papyrus.uml.domain.services.drop.DnDStatus;
import org.eclipse.papyrus.uml.domain.services.drop.IExternalSourceToRepresentationDropBehaviorProvider;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Comment;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Enumeration;
import org.eclipse.uml2.uml.EnumerationLiteral;
import org.eclipse.uml2.uml.Interface;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Relationship;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.util.UMLSwitch;

public class ClassExternalSourceToRepresentationDropBehaviorProvider
implements IExternalSourceToRepresentationDropBehaviorProvider {
    @Override
    public DnDStatus drop(EObject droppedElement, EObject target, ECrossReferenceAdapter crossRef, IEditableChecker editableChecker) {
        return (DnDStatus)new ClassDropInsideRepresentationBehaviorProviderSwitch(target).doSwitch(droppedElement);
    }

    static class ClassDropInsideRepresentationBehaviorProviderSwitch
    extends UMLSwitch<DnDStatus> {
        private EObject newSemanticContainer;

        ClassDropInsideRepresentationBehaviorProviderSwitch(EObject target) {
            this.newSemanticContainer = target;
        }

        public DnDStatus caseClassifier(Classifier classifier) {
            if (this.newSemanticContainer instanceof Package || this.newSemanticContainer instanceof Classifier) {
                return DnDStatus.createNothingStatus(Set.of(classifier));
            }
            return (DnDStatus)super.caseClassifier(classifier);
        }

        public DnDStatus caseComment(Comment comment) {
            if (this.newSemanticContainer instanceof Package) {
                return DnDStatus.createNothingStatus(Set.of(comment));
            }
            return (DnDStatus)super.caseComment(comment);
        }

        public DnDStatus caseConstraint(Constraint constraint) {
            if (this.newSemanticContainer instanceof Package) {
                return DnDStatus.createNothingStatus(Set.of(constraint));
            }
            return (DnDStatus)super.caseConstraint(constraint);
        }

        public DnDStatus caseEnumerationLiteral(EnumerationLiteral enumerationLiteral) {
            if (this.newSemanticContainer instanceof Enumeration) {
                return DnDStatus.createNothingStatus(Set.of(enumerationLiteral));
            }
            return (DnDStatus)super.caseEnumerationLiteral(enumerationLiteral);
        }

        public DnDStatus caseOperation(Operation operation) {
            EObject target = this.newSemanticContainer;
            if (target instanceof Operation) {
                target = target.eContainer();
            }
            if (target instanceof Class || target instanceof Interface || target instanceof DataType && !(target instanceof Enumeration)) {
                return DnDStatus.createNothingStatus(Set.of(operation));
            }
            return (DnDStatus)super.caseOperation(operation);
        }

        public DnDStatus casePackage(Package pack) {
            if (this.newSemanticContainer instanceof Package) {
                return DnDStatus.createNothingStatus(Set.of(pack));
            }
            return (DnDStatus)super.casePackage(pack);
        }

        public DnDStatus caseProperty(Property property) {
            boolean isPropertyHolder;
            EObject target = this.newSemanticContainer;
            if (target instanceof Property) {
                target = target.eContainer();
            }
            boolean bl = isPropertyHolder = target instanceof Class || target instanceof Interface || target instanceof DataType || target instanceof Signal;
            if (isPropertyHolder && !(target instanceof Enumeration)) {
                return DnDStatus.createNothingStatus(Set.of(property));
            }
            return (DnDStatus)super.caseProperty(property);
        }

        public DnDStatus caseRelationship(Relationship relationship) {
            return DnDStatus.createNothingStatus(Set.of(relationship));
        }

        public DnDStatus defaultCase(EObject object) {
            return DnDStatus.createFailingStatus("DnD is forbidden.", Collections.emptySet());
        }
    }
}

