/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.infra.gmfdiag.common.editpolicies;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.tools.ResizeTracker;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.papyrus.infra.gmfdiag.common.editpolicies.PapyrusResizableShapeEditPolicy;
import org.eclipse.papyrus.infra.gmfdiag.common.snap.ResizeTrackerWithPreferences;

public class PapyrusReflowableShapeEditPolicy
extends PapyrusResizableShapeEditPolicy {
    @Override
    protected ResizeTracker getResizeTracker(int direction) {
        return new ResizeTrackerWithPreferences(this.getHost(), direction);
    }

    protected void showChangeBoundsFeedback(ChangeBoundsRequest request) {
        IFigure feedback = this.getDragSourceFeedbackFigure();
        PrecisionRectangle rect = new PrecisionRectangle(this.getInitialFeedbackBounds().getCopy());
        this.getHostFigure().translateToAbsolute((Translatable)rect);
        rect.translate(request.getMoveDelta());
        rect.resize(request.getSizeDelta());
        IFigure f = this.getHostFigure();
        Dimension min = this.computeMinimumSizeFor(rect.getSize());
        Dimension max = f.getMaximumSize().getCopy();
        IMapMode mmode = MapModeUtil.getMapMode((IFigure)f);
        min.height = mmode.LPtoDP(min.height);
        min.width = mmode.LPtoDP(min.width);
        max.height = mmode.LPtoDP(max.height);
        max.width = mmode.LPtoDP(max.width);
        if (min.width > rect.width) {
            rect.width = min.width;
        } else if (max.width < rect.width) {
            rect.width = max.width;
        }
        if (min.height > rect.height) {
            rect.height = min.height;
        } else if (max.height < rect.height) {
            rect.height = max.height;
        }
        feedback.translateToRelative((Translatable)rect);
        feedback.setBounds((Rectangle)rect);
    }

    protected Dimension computeMinimumSizeFor(Dimension suggestedSize) {
        IFigure f = this.getHostFigure();
        return f.getMinimumSize(suggestedSize.width, -1);
    }
}

