/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.git.impl;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.egit.core.EclipseGitProgressTransformer;
import org.eclipse.egit.core.settings.GitSettings;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.jgit.api.CheckoutCommand;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.CreateBranchCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ReflogCommand;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.StatusCommand;
import org.eclipse.jgit.api.errors.InvalidRefNameException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.submodule.SubmoduleWalk;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.SetupTaskContext;
import org.eclipse.oomph.setup.git.ConfigProperty;
import org.eclipse.oomph.setup.git.ConfigSection;
import org.eclipse.oomph.setup.git.ConfigSubsection;
import org.eclipse.oomph.setup.git.GitCloneTask;
import org.eclipse.oomph.setup.git.GitConfigurationTask;
import org.eclipse.oomph.setup.git.GitFactory;
import org.eclipse.oomph.setup.git.GitPackage;
import org.eclipse.oomph.setup.git.impl.GitConfigurationTaskImpl;
import org.eclipse.oomph.setup.git.impl.Messages;
import org.eclipse.oomph.setup.impl.SetupTaskImpl;
import org.eclipse.oomph.setup.util.FileUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.oomph.util.ObjectUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.osgi.util.NLS;

public class GitCloneTaskImpl
extends SetupTaskImpl
implements GitCloneTask {
    protected static final String LOCATION_EDEFAULT = "";
    protected String location = "";
    protected static final String LOCATION_QUALIFIER_EDEFAULT = " ";
    protected String locationQualifier = " ";
    protected static final String REMOTE_NAME_EDEFAULT = "origin";
    protected String remoteName = "origin";
    protected static final String REMOTE_URI_EDEFAULT = null;
    protected String remoteURI = REMOTE_URI_EDEFAULT;
    protected static final String PUSH_URI_EDEFAULT = null;
    protected String pushURI = PUSH_URI_EDEFAULT;
    protected static final String CHECKOUT_BRANCH_EDEFAULT = "${scope.project.stream.name}";
    protected String checkoutBranch = "${scope.project.stream.name}";
    protected static final boolean RECURSIVE_EDEFAULT = false;
    protected boolean recursive = false;
    protected EList<ConfigSection> configSections;
    protected static final boolean RESTRICT_TO_CHECKOUT_BRANCH_EDEFAULT = false;
    protected boolean restrictToCheckoutBranch = false;
    protected EList<GitConfigurationTask> configurations;
    private boolean workDirExisted;
    private boolean bypassCloning;
    private int timeout;

    protected GitCloneTaskImpl() {
    }

    protected EClass eStaticClass() {
        return GitPackage.Literals.GIT_CLONE_TASK;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void setLocation(String newLocation) {
        String oldLocation = this.location;
        this.location = newLocation;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 10, (Object)oldLocation, (Object)this.location));
        }
    }

    @Override
    public String getLocationQualifier() {
        return this.locationQualifier;
    }

    @Override
    public void setLocationQualifier(String newLocationQualifier) {
        String oldLocationQualifier = this.locationQualifier;
        this.locationQualifier = newLocationQualifier;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 11, (Object)oldLocationQualifier, (Object)this.locationQualifier));
        }
    }

    @Override
    public String getRemoteName() {
        return this.remoteName;
    }

    @Override
    public void setRemoteName(String newRemoteName) {
        String oldRemoteName = this.remoteName;
        this.remoteName = newRemoteName;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 12, (Object)oldRemoteName, (Object)this.remoteName));
        }
    }

    @Override
    public String getRemoteURI() {
        return this.remoteURI;
    }

    @Override
    public void setRemoteURI(String newRemoteURI) {
        String oldRemoteURI = this.remoteURI;
        this.remoteURI = newRemoteURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 13, (Object)oldRemoteURI, (Object)this.remoteURI));
        }
    }

    @Override
    public String getCheckoutBranch() {
        return this.checkoutBranch;
    }

    @Override
    public void setCheckoutBranch(String newCheckoutBranch) {
        String oldCheckoutBranch = this.checkoutBranch;
        this.checkoutBranch = newCheckoutBranch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 15, (Object)oldCheckoutBranch, (Object)this.checkoutBranch));
        }
    }

    @Override
    public boolean isRecursive() {
        return this.recursive;
    }

    @Override
    public void setRecursive(boolean newRecursive) {
        boolean oldRecursive = this.recursive;
        this.recursive = newRecursive;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 16, oldRecursive, this.recursive));
        }
    }

    @Override
    public EList<ConfigSection> getConfigSections() {
        if (this.configSections == null) {
            this.configSections = new EObjectContainmentEList(ConfigSection.class, (InternalEObject)this, 17);
        }
        return this.configSections;
    }

    @Override
    public boolean isRestrictToCheckoutBranch() {
        return this.restrictToCheckoutBranch;
    }

    @Override
    public void setRestrictToCheckoutBranch(boolean newRestrictToCheckoutBranch) {
        boolean oldRestrictToCheckoutBranch = this.restrictToCheckoutBranch;
        this.restrictToCheckoutBranch = newRestrictToCheckoutBranch;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 18, oldRestrictToCheckoutBranch, this.restrictToCheckoutBranch));
        }
    }

    @Override
    public EList<GitConfigurationTask> getConfigurations() {
        if (this.configurations == null) {
            this.configurations = new EObjectContainmentEList(GitConfigurationTask.class, (InternalEObject)this, 19);
        }
        return this.configurations;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 17: {
                return ((InternalEList)this.getConfigSections()).basicRemove((Object)otherEnd, msgs);
            }
            case 19: {
                return ((InternalEList)this.getConfigurations()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    @Override
    public String getPushURI() {
        return this.pushURI;
    }

    @Override
    public void setPushURI(String newPushURI) {
        String oldPushURI = this.pushURI;
        this.pushURI = newPushURI;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 14, (Object)oldPushURI, (Object)this.pushURI));
        }
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 10: {
                return this.getLocation();
            }
            case 11: {
                return this.getLocationQualifier();
            }
            case 12: {
                return this.getRemoteName();
            }
            case 13: {
                return this.getRemoteURI();
            }
            case 14: {
                return this.getPushURI();
            }
            case 15: {
                return this.getCheckoutBranch();
            }
            case 16: {
                return this.isRecursive();
            }
            case 17: {
                return this.getConfigSections();
            }
            case 18: {
                return this.isRestrictToCheckoutBranch();
            }
            case 19: {
                return this.getConfigurations();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 10: {
                this.setLocation((String)newValue);
                return;
            }
            case 11: {
                this.setLocationQualifier((String)newValue);
                return;
            }
            case 12: {
                this.setRemoteName((String)newValue);
                return;
            }
            case 13: {
                this.setRemoteURI((String)newValue);
                return;
            }
            case 14: {
                this.setPushURI((String)newValue);
                return;
            }
            case 15: {
                this.setCheckoutBranch((String)newValue);
                return;
            }
            case 16: {
                this.setRecursive((Boolean)newValue);
                return;
            }
            case 17: {
                this.getConfigSections().clear();
                this.getConfigSections().addAll((Collection)newValue);
                return;
            }
            case 18: {
                this.setRestrictToCheckoutBranch((Boolean)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 10: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 11: {
                this.setLocationQualifier(LOCATION_QUALIFIER_EDEFAULT);
                return;
            }
            case 12: {
                this.setRemoteName(REMOTE_NAME_EDEFAULT);
                return;
            }
            case 13: {
                this.setRemoteURI(REMOTE_URI_EDEFAULT);
                return;
            }
            case 14: {
                this.setPushURI(PUSH_URI_EDEFAULT);
                return;
            }
            case 15: {
                this.setCheckoutBranch(CHECKOUT_BRANCH_EDEFAULT);
                return;
            }
            case 16: {
                this.setRecursive(false);
                return;
            }
            case 17: {
                this.getConfigSections().clear();
                return;
            }
            case 18: {
                this.setRestrictToCheckoutBranch(false);
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 10: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals(this.location);
            }
            case 11: {
                return LOCATION_QUALIFIER_EDEFAULT == null ? this.locationQualifier != null : !LOCATION_QUALIFIER_EDEFAULT.equals(this.locationQualifier);
            }
            case 12: {
                return REMOTE_NAME_EDEFAULT == null ? this.remoteName != null : !REMOTE_NAME_EDEFAULT.equals(this.remoteName);
            }
            case 13: {
                return REMOTE_URI_EDEFAULT == null ? this.remoteURI != null : !REMOTE_URI_EDEFAULT.equals(this.remoteURI);
            }
            case 14: {
                return PUSH_URI_EDEFAULT == null ? this.pushURI != null : !PUSH_URI_EDEFAULT.equals(this.pushURI);
            }
            case 15: {
                return CHECKOUT_BRANCH_EDEFAULT == null ? this.checkoutBranch != null : !CHECKOUT_BRANCH_EDEFAULT.equals(this.checkoutBranch);
            }
            case 16: {
                return this.recursive;
            }
            case 17: {
                return this.configSections != null && !this.configSections.isEmpty();
            }
            case 18: {
                return this.restrictToCheckoutBranch;
            }
            case 19: {
                return this.configurations != null && !this.configurations.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (location: ");
        result.append(this.location);
        result.append(", locationQualifier: ");
        result.append(this.locationQualifier);
        result.append(", remoteName: ");
        result.append(this.remoteName);
        result.append(", remoteURI: ");
        result.append(this.remoteURI);
        result.append(", pushURI: ");
        result.append(this.pushURI);
        result.append(", checkoutBranch: ");
        result.append(this.checkoutBranch);
        result.append(", recursive: ");
        result.append(this.recursive);
        result.append(", restrictToCheckoutBranch: ");
        result.append(this.restrictToCheckoutBranch);
        result.append(')');
        return result.toString();
    }

    public Object getOverrideToken() {
        String token = this.getLocation();
        if (StringUtil.isEmpty((String)token)) {
            token = this.getRemoteURI();
        }
        return this.createToken(token);
    }

    public void overrideFor(SetupTask overriddenSetupTask) {
        super.overrideFor(overriddenSetupTask);
        GitCloneTask gitCloneTask = (GitCloneTask)overriddenSetupTask;
        if (!ObjectUtil.equals((Object)gitCloneTask.getRemoteURI(), (Object)this.getRemoteURI()) || !ObjectUtil.equals((Object)gitCloneTask.getCheckoutBranch(), (Object)this.getCheckoutBranch())) {
            Annotation errorAnnotation = BaseFactory.eINSTANCE.createErrorAnnotation(Messages.GitCloneTaskImpl_CloneCollision_message);
            this.getAnnotations().add((Object)errorAnnotation);
        }
    }

    public int getProgressMonitorWork() {
        return 100;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isNeeded(final SetupTaskContext context) throws Exception {
        boolean needsToBeAdded;
        String remoteURI = this.getRemoteURI();
        if (StringUtil.isEmpty((String)remoteURI)) {
            return false;
        }
        HashSet repositories = null;
        try {
            repositories = new HashSet(GitSettings.getConfiguredRepositoryDirectories());
            this.timeout = GitSettings.getRemoteConnectionTimeout();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        String location = this.getLocation();
        File workDir = new File(location);
        if (!workDir.isDirectory()) {
            return true;
        }
        this.workDirExisted = true;
        Path dotGitPath = GitCloneTaskImpl.getDotGitPath(workDir);
        boolean bl = needsToBeAdded = repositories != null && !repositories.contains(dotGitPath);
        if (workDir.list().length > 1 && !Files.isDirectory(dotGitPath, new LinkOption[0])) {
            throw new Exception(NLS.bind((String)Messages.GitCloneTaskImpl_NonEmptyTargetFolder_message, (Object)workDir));
        }
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_OpeningClone_message, (Object)workDir));
        try {
            Throwable throwable = null;
            Object var9_12 = null;
            try (Git git = Git.open((File)workDir);){
                boolean bl2;
                if (!GitCloneTaskImpl.hasWorkTree(git) || !GitCloneTaskImpl.hasReflog(git)) {
                    FileUtil.rename((File)workDir);
                    this.workDirExisted = false;
                    return true;
                }
                Repository repository = git.getRepository();
                String checkoutBranch = this.getCheckoutBranch();
                String remoteName = this.getRemoteName();
                String pushURI = this.getPushURI();
                LinkedHashMap<String, GitConfigurationTask> configurations = new LinkedHashMap<String, GitConfigurationTask>();
                boolean changed = GitCloneTaskImpl.configureRepository(context, configurations, true, repository, false, this.isRecursive(), false, checkoutBranch, this.isRestrictToCheckoutBranch(), remoteName, remoteURI, pushURI, this.getConfigSections(), GitCloneTaskImpl.getGerritPatterns(context));
                this.getConfigurations().addAll(configurations.values());
                this.bypassCloning = true;
                if (!changed && !needsToBeAdded) {
                    bl2 = false;
                    return bl2;
                }
                bl2 = true;
                return bl2;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                    throw throwable;
                }
                if (throwable == throwable2) throw throwable;
                throwable.addSuppressed(throwable2);
                throw throwable;
            }
        }
        catch (Throwable ex) {
            if (this.workDirExisted) throw new Exception(ex);
            FileUtil.delete((File)workDir, (IProgressMonitor)new NullProgressMonitor(){

                public boolean isCanceled() {
                    return context.isCanceled();
                }
            });
            throw new Exception(ex);
        }
    }

    public void perform(SetupTaskContext context) throws Exception {
        GitCloneTaskImpl.perform(context, context.getProgressMonitor(true), true, this.bypassCloning, this.workDirExisted, this.isRecursive(), this.isRestrictToCheckoutBranch(), this.timeout, new File(this.getLocation()), this.getRemoteURI(), this.getPushURI(), this.getCheckoutBranch(), this.getRemoteName(), this.getConfigSections());
        GitCloneTaskImpl.refresh();
    }

    /*
     * Exception decompiling
     */
    private static void perform(SetupTaskContext context, IProgressMonitor monitor, boolean root, boolean bypassCloning, boolean workDirExisted, boolean isRecursive, boolean isRestrictToCheckoutBranch, int timeout, File workDir, String remoteURI, String pushURI, String checkoutBranch, String remoteName, EList<ConfigSection> configSections) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 5[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static List<ConfigSection> applyGitTaskConfigurations(SetupTaskContext context, boolean root, Map<String, GitConfigurationTask> configurations, String remoteURI, List<? extends ConfigSection> configSections) {
        List result = (List)EcoreUtil.copyAll(configSections);
        if (!root) {
            GitCloneTaskImpl.removeNonRecursiveProperties(result);
        }
        List<GitConfigurationTask> gitConfigurationTasks = GitConfigurationTaskImpl.getGitConfigurationTasks(context);
        boolean matched = false;
        for (GitConfigurationTask gitConfigurationTask : gitConfigurationTasks) {
            String remoteURIPattern = gitConfigurationTask.getRemoteURIPattern();
            Pattern pattern = Pattern.compile(remoteURIPattern);
            Matcher matcher = pattern.matcher(remoteURI);
            if (!matcher.matches()) continue;
            matched = true;
            for (ConfigSection configSection : GitCloneTaskImpl.applySubstitutions(root, matcher, gitConfigurationTask.getConfigSections())) {
                String sectionName = configSection.getName();
                if (StringUtil.isEmpty((String)sectionName)) continue;
                EList<ConfigSubsection> subsections = configSection.getSubsections();
                for (ConfigSubsection configSubsection : subsections) {
                    String subSectionName = configSubsection.getName();
                    if (StringUtil.isEmpty((String)subSectionName)) continue;
                    GitCloneTaskImpl.applyConfigProperties(result, sectionName, subSectionName, configSubsection.getProperties());
                }
                GitCloneTaskImpl.applyConfigProperties(result, sectionName, null, configSection.getProperties());
            }
        }
        if (configurations != null && matched && !result.isEmpty()) {
            GitConfigurationTask gitConfigurationTask;
            gitConfigurationTask = GitFactory.eINSTANCE.createGitConfigurationTask();
            gitConfigurationTask.setRemoteURIPattern(remoteURI);
            gitConfigurationTask.getConfigSections().addAll(EcoreUtil.copyAll((Collection)result));
            configurations.put(remoteURI, gitConfigurationTask);
        }
        return result;
    }

    private static void removeNonRecursiveProperties(Collection<? extends ConfigSection> configSections) {
        ArrayList<EObject> nonRecursiveProperties = new ArrayList<EObject>();
        TreeIterator allContents = EcoreUtil.getAllContents(configSections);
        while (allContents.hasNext()) {
            EObject content = (EObject)allContents.next();
            if (!(content instanceof ConfigProperty) || ((ConfigProperty)content).isRecursive()) continue;
            nonRecursiveProperties.add(content);
        }
        for (EObject eObject : nonRecursiveProperties) {
            EObject eContainer = eObject.eContainer();
            EcoreUtil.delete((EObject)eObject);
            if (eContainer == null || !eContainer.eContents().isEmpty()) continue;
            EcoreUtil.delete((EObject)eContainer);
        }
        configSections.removeIf(configSection -> configSection.eContents().isEmpty());
    }

    private static Collection<ConfigSection> applySubstitutions(boolean root, Matcher matcher, EList<ConfigSection> configSections) {
        Collection result = EcoreUtil.copyAll(configSections);
        if (!root) {
            GitCloneTaskImpl.removeNonRecursiveProperties(result);
        }
        TreeIterator allContents = EcoreUtil.getAllContents((Collection)result);
        while (allContents.hasNext()) {
            EObject eObject = (EObject)allContents.next();
            for (EAttribute eAttribute : eObject.eClass().getEAllAttributes()) {
                String value;
                if (eAttribute.getEType().getInstanceClass() != String.class || StringUtil.isEmpty((String)(value = (String)eObject.eGet((EStructuralFeature)eAttribute)))) continue;
                value = value.replace("$$", "\u0000");
                int i = matcher.groupCount();
                while (i > 0) {
                    String replacement = matcher.group(i);
                    value = value.replace("$" + i, replacement);
                    --i;
                }
                value = value.replace("\u0000", "$");
                eObject.eSet((EStructuralFeature)eAttribute, (Object)value);
            }
        }
        return result;
    }

    private static void applyConfigProperties(List<ConfigSection> configSections, String sectionName, String subsectionName, EList<ConfigProperty> properties) {
        EList<ConfigProperty> targetProperties = null;
        block0: for (ConfigSection configSection : configSections) {
            if (!sectionName.equals(configSection.getName())) continue;
            if (subsectionName != null) {
                ConfigSubsection configSubsection2;
                EList<ConfigSubsection> configSubsections = configSection.getSubsections();
                for (ConfigSubsection configSubsection2 : configSubsections) {
                    if (!subsectionName.equals(configSubsection2.getName())) continue;
                    targetProperties = configSection.getProperties();
                    break block0;
                }
                configSubsection2 = GitFactory.eINSTANCE.createConfigSubsection();
                configSubsections.add((Object)configSubsection2);
                configSubsection2.setName(subsectionName);
                targetProperties = configSubsection2.getProperties();
                break;
            }
            targetProperties = configSection.getProperties();
            break;
        }
        if (targetProperties == null) {
            ConfigSection configSection;
            configSection = GitFactory.eINSTANCE.createConfigSection();
            configSections.add(configSection);
            configSection.setName(sectionName);
            if (subsectionName == null) {
                targetProperties = configSection.getProperties();
            } else {
                ConfigSubsection configSubsection = GitFactory.eINSTANCE.createConfigSubsection();
                configSection.getSubsections().add((Object)configSubsection);
                configSubsection.setName(subsectionName);
                targetProperties = configSubsection.getProperties();
            }
        }
        Set propertyNames = properties.stream().map(ConfigProperty::getKey).collect(Collectors.toSet());
        targetProperties.removeIf(property -> propertyNames.contains(property.getKey()));
        targetProperties.addAll(properties);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean configureRepository(SetupTaskContext context, Map<String, GitConfigurationTask> configurations, boolean root, Repository repository, boolean save, boolean isRecursive, boolean reconfigure, String checkoutBranch, boolean restrictToCheckoutBranch, String remoteName, String remoteURI, String pushURI, List<? extends ConfigSection> rawConfigSections, Set<String> gerritPatterns) throws Exception, IOException {
        List<ConfigSection> configSections = GitCloneTaskImpl.applyGitTaskConfigurations(context, root, configurations, remoteURI, rawConfigSections);
        if (context.isPerforming()) {
            context.log(NLS.bind((String)Messages.GitCloneTaskImpl_Configure_message, (Object)remoteURI));
        }
        LinkedHashSet<String> forcedProperties = new LinkedHashSet<String>();
        LinkedHashMap<String, Map<String, Map<String, List<String>>>> properties = new LinkedHashMap<String, Map<String, Map<String, List<String>>>>();
        for (ConfigSection section : configSections) {
            String sectionName = section.getName();
            if (StringUtil.isEmpty((String)sectionName)) continue;
            for (ConfigProperty property : section.getProperties()) {
                GitCloneTaskImpl.handleProperty(properties, forcedProperties, root, sectionName, null, property);
            }
            for (ConfigSubsection subsection : section.getSubsections()) {
                String subsectionName = subsection.getName();
                if (subsectionName == null) continue;
                for (ConfigProperty property : subsection.getProperties()) {
                    GitCloneTaskImpl.handleProperty(properties, forcedProperties, root, sectionName, subsectionName, property);
                }
            }
        }
        boolean changed = false;
        boolean hasAutoCRLFProperty = false;
        FileBasedConfig config = (FileBasedConfig)repository.getConfig();
        FileBasedConfig rawConfig = new FileBasedConfig(config.getFile(), repository.getFS());
        rawConfig.load();
        for (Map.Entry sectionEntry : properties.entrySet()) {
            String sectionName = (String)sectionEntry.getKey();
            for (Object subsectionEntry : ((Map)sectionEntry.getValue()).entrySet()) {
                String subsectionName = (String)subsectionEntry.getKey();
                for (Map.Entry propertyEntry : ((Map)subsectionEntry.getValue()).entrySet()) {
                    String key = (String)propertyEntry.getKey();
                    if ("core".equals(sectionName) && subsectionName == null && "autocrlf".equals(key)) {
                        hasAutoCRLFProperty = true;
                    }
                    List value = (List)propertyEntry.getValue();
                    List<String> oldValue = Arrays.asList(rawConfig.getStringList(sectionName, subsectionName, key));
                    String propertyName = GitCloneTaskImpl.getPropertyName(sectionName, subsectionName, key);
                    if (value.equals(oldValue)) continue;
                    if (value.isEmpty()) {
                        if (!forcedProperties.contains(propertyName)) continue;
                        if (context.isPerforming()) {
                            context.log(NLS.bind((String)Messages.GitCloneTaskImpl_UnsettingConfigProperty_message, (Object)propertyName));
                        }
                        config.unset(sectionName, subsectionName, key);
                        changed = true;
                        continue;
                    }
                    if (!oldValue.isEmpty() && !forcedProperties.contains(propertyName)) continue;
                    if (context.isPerforming()) {
                        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_SetttingConfigProperty_message, (Object)propertyName, (Object)String.join((CharSequence)", ", value)));
                    }
                    config.setStringList(sectionName, subsectionName, key, value);
                    changed = true;
                }
            }
        }
        if (reconfigure) {
            if (!hasAutoCRLFProperty) {
                changed |= GitCloneTaskImpl.configureLineEndingConversion(context, (StoredConfig)config);
            }
            if (!gerritPatterns.isEmpty()) {
                URI uri = URI.createURI((String)remoteURI);
                String uriString = uri.toString();
                for (String gerritPattern : gerritPatterns) {
                    if (!uriString.matches(gerritPattern)) continue;
                    changed |= GitCloneTaskImpl.addGerritPullRefSpec(context, (StoredConfig)config, remoteName);
                    changed |= GitCloneTaskImpl.addGerritPushRefSpec(context, (StoredConfig)config, checkoutBranch, remoteName);
                    break;
                }
            }
            changed |= GitCloneTaskImpl.addPushURI(context, (StoredConfig)config, remoteName, pushURI);
            if (restrictToCheckoutBranch) {
                changed |= GitCloneTaskImpl.setSingleFetchRefSpec(context, (StoredConfig)config, checkoutBranch, remoteName);
            }
        }
        if (isRecursive) {
            Object object = null;
            Object var22_25 = null;
            try (SubmoduleWalk generator = SubmoduleWalk.forIndex((Repository)repository);){
                while (generator.next()) {
                    String url;
                    if (generator.getModulesPath() == null || (url = generator.getConfigUrl()) == null) continue;
                    Object object2 = null;
                    Object var26_31 = null;
                    try (Repository subRepository = generator.getRepository();){
                        if (subRepository == null) continue;
                        changed |= GitCloneTaskImpl.configureRepository(context, configurations, false, subRepository, save, isRecursive, reconfigure, checkoutBranch, restrictToCheckoutBranch, remoteName, url, null, rawConfigSections, gerritPatterns);
                    }
                    catch (Throwable throwable) {
                        if (object2 == null) {
                            object2 = throwable;
                            throw object2;
                        }
                        if (object2 == throwable) throw object2;
                        ((Throwable)object2).addSuppressed(throwable);
                        throw object2;
                    }
                }
            }
            catch (Throwable throwable) {
                if (object == null) {
                    object = throwable;
                    throw object;
                }
                if (object == throwable) throw object;
                ((Throwable)object).addSuppressed(throwable);
                throw object;
            }
        }
        if (!changed) return changed;
        if (save) {
            config.save();
            return changed;
        }
        config.load();
        return changed;
    }

    private static String getPropertyName(String sectionName, String subsectionName, String key) {
        if (subsectionName == null) {
            return sectionName + "/" + key;
        }
        return sectionName + "/" + subsectionName + "/" + key;
    }

    private static void handleProperty(Map<String, Map<String, Map<String, List<String>>>> properties, Set<String> forcedProperties, boolean root, String sectionName, String subsectionName, ConfigProperty property) {
        String key;
        if ((root || property.isRecursive()) && !StringUtil.isEmpty((String)(key = property.getKey()))) {
            String value = property.getValue();
            if (StringUtil.isEmpty((String)value)) {
                value = null;
            }
            List values = properties.computeIfAbsent(sectionName, it -> new LinkedHashMap()).computeIfAbsent(subsectionName, it -> new LinkedHashMap()).computeIfAbsent(key, it -> new ArrayList());
            if (value != null) {
                values.add(value);
            }
            if (property.isForce()) {
                forcedProperties.add(GitCloneTaskImpl.getPropertyName(sectionName, subsectionName, key));
            }
        }
    }

    private static Git cloneRepository(SetupTaskContext context, File workDir, String checkoutBranch, boolean restrictToCheckoutBranch, String remoteName, String remoteURI, boolean recursive, int timeout, IProgressMonitor monitor) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CloningRepo_message, (Object)remoteURI, (Object)workDir));
        CloneCommand command = Git.cloneRepository();
        command.setNoCheckout(true);
        command.setURI(remoteURI);
        command.setRemote(remoteName);
        command.setBranch(checkoutBranch);
        command.setCloneAllBranches(!restrictToCheckoutBranch);
        command.setCloneSubmodules(recursive);
        command.setDirectory(workDir);
        command.setTimeout(timeout <= 0 ? 60 : timeout);
        command.setProgressMonitor((ProgressMonitor)new EclipseGitProgressTransformer(monitor));
        if (restrictToCheckoutBranch) {
            command.setBranchesToClone(Collections.singleton("refs/heads/" + checkoutBranch));
        }
        return command.call();
    }

    private static Set<String> getGerritPatterns(SetupTaskContext context) {
        LinkedHashSet<String> gerritPatterns = new LinkedHashSet<String>();
        for (Object key : context.keySet()) {
            Object value;
            if (!(key instanceof String) || !key.toString().endsWith(".gerrit.uri.pattern") || !((value = context.get(key)) instanceof String)) continue;
            gerritPatterns.add(value.toString());
        }
        return gerritPatterns;
    }

    private static boolean setSingleFetchRefSpec(SetupTaskContext context, StoredConfig config, String checkoutBranch, String remoteName) throws Exception {
        RemoteConfig remoteConfig = GitCloneTaskImpl.getRemoteConfig(config, remoteName);
        if (remoteConfig != null) {
            RefSpec oldRrefSpec = new RefSpec();
            oldRrefSpec = oldRrefSpec.setForceUpdate(true);
            oldRrefSpec = oldRrefSpec.setSourceDestination("refs/heads/*", "refs/remotes/" + remoteName + "/*");
            String src = "refs/heads/" + checkoutBranch;
            String dst = "refs/remotes/" + remoteName + "/" + checkoutBranch;
            RefSpec newRefSpec = new RefSpec();
            newRefSpec = newRefSpec.setForceUpdate(true);
            if (remoteConfig.addFetchRefSpec(newRefSpec = newRefSpec.setSourceDestination(src, dst)) && remoteConfig.removeFetchRefSpec(oldRrefSpec) && context.isPerforming()) {
                context.log(Messages.GitCloneTaskImpl_FetchingRefSpec_message);
            }
            remoteConfig.update((Config)config);
            return true;
        }
        return false;
    }

    private static boolean configureLineEndingConversion(SetupTaskContext context, StoredConfig config) throws Exception {
        OS os = context.getOS();
        if (os.isLineEndingConversionNeeded() && !"true".equals(config.getString("core", null, "autocrlf"))) {
            if (context.isPerforming()) {
                context.log(NLS.bind((String)Messages.GitCloneTaskImpl_SettingConfig_message, (Object)"autocrlf"));
            }
            config.setEnum("core", null, "autocrlf", (Enum)CoreConfig.AutoCRLF.TRUE);
            return true;
        }
        return false;
    }

    private static boolean addGerritPullRefSpec(SetupTaskContext context, StoredConfig config, String remoteName) throws Exception {
        RefSpec refSpec;
        boolean changed;
        RemoteConfig remoteConfig = GitCloneTaskImpl.getRemoteConfig(config, remoteName);
        if (remoteConfig != null && (changed = remoteConfig.addFetchRefSpec(refSpec = new RefSpec("refs/notes/*:refs/notes/*")))) {
            if (context.isPerforming()) {
                context.log(NLS.bind((String)Messages.GitCloneTaskImpl_AddingFetchRefSpec_message, (Object)refSpec));
            }
            remoteConfig.update((Config)config);
            return true;
        }
        return false;
    }

    private static boolean addGerritPushRefSpec(SetupTaskContext context, StoredConfig config, String checkoutBranch, String remoteName) throws Exception {
        RefSpec refSpec;
        boolean changed;
        RemoteConfig remoteConfig = GitCloneTaskImpl.getRemoteConfig(config, remoteName);
        if (remoteConfig != null && (changed = remoteConfig.addPushRefSpec(refSpec = new RefSpec("HEAD:refs/for/" + checkoutBranch)))) {
            if (context.isPerforming()) {
                context.log(NLS.bind((String)Messages.GitCloneTaskImpl_AddingPushRefSpec_message, (Object)refSpec));
            }
            remoteConfig.update((Config)config);
            return true;
        }
        return false;
    }

    private static boolean addPushURI(SetupTaskContext context, StoredConfig config, String remoteName, String pushURI) throws Exception {
        boolean uriAdded = false;
        if (!StringUtil.isEmpty((String)pushURI)) {
            URIish uri = new URIish(pushURI);
            RemoteConfig remoteConfig = GitCloneTaskImpl.getRemoteConfig(config, remoteName);
            if (remoteConfig != null) {
                if (context.isPerforming()) {
                    context.log(NLS.bind((String)Messages.GitCloneTaskImpl_AddingPushURI_message, (Object)pushURI));
                }
                if (uriAdded = remoteConfig.addPushURI(uri)) {
                    remoteConfig.update((Config)config);
                }
            }
        }
        return uriAdded;
    }

    private static RemoteConfig getRemoteConfig(StoredConfig config, String remoteName) throws Exception {
        for (RemoteConfig remoteConfig : RemoteConfig.getAllRemoteConfigs((Config)config)) {
            if (!remoteName.equals(remoteConfig.getName())) continue;
            return remoteConfig;
        }
        return null;
    }

    private static void createBranch(SetupTaskContext context, Git git, String checkoutBranch, String remoteName) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CreatingLocalBranch_message, (Object)checkoutBranch));
        if (GitCloneTaskImpl.findRef(git.getRepository(), "refs/heads/" + checkoutBranch) == null) {
            CreateBranchCommand command = git.branchCreate();
            command.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM);
            command.setName(checkoutBranch);
            command.setStartPoint("refs/remotes/" + remoteName + "/" + checkoutBranch);
            command.call();
        }
        StoredConfig config = git.getRepository().getConfig();
        config.setBoolean("branch", checkoutBranch, "rebase", true);
        config.save();
    }

    private static void createTag(SetupTaskContext context, Git git, String checkoutTag) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CreatingLocalTag_message, (Object)checkoutTag));
        Repository repository = git.getRepository();
        if (GitCloneTaskImpl.findRef(repository, "refs/heads/" + checkoutTag) == null) {
            CreateBranchCommand command = git.branchCreate();
            command.setUpstreamMode(CreateBranchCommand.SetupUpstreamMode.SET_UPSTREAM);
            command.setName(checkoutTag);
            command.setStartPoint("refs/tags/" + checkoutTag);
            command.call();
        }
        StoredConfig config = repository.getConfig();
        config.setBoolean("branch", checkoutTag, "rebase", true);
        config.save();
    }

    private static void checkoutTag(SetupTaskContext context, Git git, String checkoutTag) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CheckingOutLocalBranch_message, (Object)checkoutTag));
        CheckoutCommand command = git.checkout();
        command.setName("refs/heads/" + checkoutTag);
        command.call();
    }

    private static void checkoutBranch(SetupTaskContext context, Git git, String checkoutBranch) throws Exception {
        context.log(NLS.bind((String)Messages.GitCloneTaskImpl_CheckingOutLocalBranch_message, (Object)checkoutBranch));
        CheckoutCommand command = git.checkout();
        command.setName(checkoutBranch);
        command.call();
    }

    private static void resetHard(SetupTaskContext context, Git git) throws Exception {
        context.log(Messages.GitCloneTaskImpl_ResettingHard_message);
        ResetCommand command = git.reset();
        command.setMode(ResetCommand.ResetType.HARD);
        command.call();
    }

    private static boolean hasWorkTree(Git git) throws Exception {
        try {
            StatusCommand statusCommand = git.status();
            statusCommand.call();
            return true;
        }
        catch (NoWorkTreeException ex) {
            return false;
        }
    }

    private static final Ref findRef(Repository repository, String name) throws IOException {
        return repository.getRefDatabase().findRef(name);
    }

    private static boolean hasReflog(Git git) throws Exception {
        try {
            ReflogCommand reflogCommand = git.reflog();
            Collection reflog = reflogCommand.call();
            return !reflog.isEmpty();
        }
        catch (InvalidRefNameException ex) {
            return false;
        }
    }

    private static Path getDotGitPath(File workDir) {
        return new File(workDir, ".git").toPath();
    }

    private static void refresh() {
        try {
            Method findAllViewsMethod = ReflectUtil.getMethod((Class)CommonPlugin.loadClass((String)"org.eclipse.oomph.ui", (String)"org.eclipse.oomph.ui.UIUtil"), (String)"findViews", (Class[])new Class[]{String.class});
            List views = (List)ReflectUtil.invokeMethod((Method)findAllViewsMethod, null, (Object[])new Object[]{"org.eclipse.egit.ui.RepositoriesView"});
            for (Object view : views) {
                ReflectUtil.invokeMethod((String)"refresh", view);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

