/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.impactanalyzer.instanceScope;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.ocl.ecore.OCLExpression;
import org.eclipse.ocl.ecore.opposites.OppositeEndFinder;
import org.eclipse.ocl.examples.impactanalyzer.impl.OperationBodyToCallMapper;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.AbstractPathCache;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.BranchingNavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.HashCodeChangeListener;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.IndirectingStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStep;
import org.eclipse.ocl.examples.impactanalyzer.instanceScope.NavigationStepSequence;
import org.eclipse.ocl.examples.impactanalyzer.util.OCLFactory;
import org.eclipse.ocl.examples.impactanalyzer.util.SemanticIdentity;

public class PathCache
extends AbstractPathCache<NavigationStep>
implements HashCodeChangeListener {
    private final Map<SemanticIdentity, NavigationStep> allNavigationSteps = new HashMap<SemanticIdentity, NavigationStep>();

    public PathCache(OppositeEndFinder oppositeEndFinder) {
        super(oppositeEndFinder);
    }

    @Override
    public void put(OCLExpression subexpression, Stack<String> tupleLiteralPartNamesToLookFor, NavigationStep path) {
        super.put(subexpression, tupleLiteralPartNamesToLookFor, path);
        if (!this.allNavigationSteps.containsKey(path.getSemanticIdentity())) {
            this.allNavigationSteps.put(path.getSemanticIdentity(), path);
            path.addHashCodeChangeListener(this);
        }
    }

    protected NavigationStep navigationStepFromSequence(OCLExpression expression, Stack<String> tupleLiteralPartNamesToLookFor, NavigationStep ... steps) {
        NavigationStep result = (NavigationStep)this.getPathForNode(expression, tupleLiteralPartNamesToLookFor);
        if (result == null) {
            if (steps.length == 1) {
                result = steps[0];
            } else {
                int firstAbsoluteStep = 0;
                int i = 0;
                while (i < steps.length) {
                    if (steps[i].isAbsolute()) {
                        firstAbsoluteStep = i;
                        break;
                    }
                    ++i;
                }
                if (firstAbsoluteStep == steps.length - 1) {
                    result = steps[steps.length - 1];
                } else {
                    NavigationStep[] tail;
                    if (firstAbsoluteStep > 0) {
                        tail = new NavigationStep[steps.length - firstAbsoluteStep];
                        System.arraycopy(steps, firstAbsoluteStep, tail, 0, steps.length - firstAbsoluteStep);
                    } else {
                        tail = steps;
                    }
                    result = new NavigationStepSequence(expression, tail);
                }
            }
            this.put(expression, tupleLiteralPartNamesToLookFor, result);
        }
        return result;
    }

    protected NavigationStep navigationStepForBranch(EClass sourceType, EClass targetType, OCLExpression expression, Stack<String> tupleLiteralPartNamesToLookFor, boolean requireExactMatchForSourceType, NavigationStep ... steps) {
        NavigationStep result = steps.length == 1 && !requireExactMatchForSourceType ? steps[0] : new BranchingNavigationStep(sourceType, targetType, expression, requireExactMatchForSourceType, steps);
        return result;
    }

    private boolean incrementallyReduceSteps(List<NavigationStep> steps, EClass sourceType, EClass targetType) {
        BranchingNavigationStep replacementStep;
        List<NavigationStep> stepsToDelete;
        boolean somethingHasChanged = false;
        List<SemanticIdentity> newStepListIdentities = this.getSemanticIdentities(steps);
        ArrayList<BranchingNavigationStep> subSetBranches = new ArrayList<BranchingNavigationStep>();
        for (SemanticIdentity identity : this.allNavigationSteps.keySet()) {
            if (!(identity.getStep() instanceof BranchingNavigationStep)) continue;
            BranchingNavigationStep oldStep = (BranchingNavigationStep)identity.getStep();
            List<SemanticIdentity> oldStepListIdentities = this.getSemanticIdentities(Arrays.asList(oldStep.getSteps()));
            if (sourceType == null || oldStep.getSourceType() == null || !sourceType.equals(oldStep.getSourceType()) || targetType == null || oldStep.getTargetType() == null || !targetType.equals(oldStep.getTargetType()) || !newStepListIdentities.containsAll(oldStepListIdentities)) continue;
            subSetBranches.add(oldStep);
        }
        if (subSetBranches.size() > 0 && steps.removeAll(stepsToDelete = Arrays.asList((replacementStep = this.getBranchingStepWithHighestNumberOfSteps(subSetBranches)).getSteps()))) {
            steps.add(replacementStep);
            somethingHasChanged = true;
        }
        return somethingHasChanged;
    }

    public BranchingNavigationStep getBranchingStepWithHighestNumberOfSteps(List<BranchingNavigationStep> list) {
        BranchingNavigationStep biggestStep = list.get(0);
        for (BranchingNavigationStep step : list) {
            if (step.getSteps().length <= biggestStep.getSteps().length) continue;
            biggestStep = step;
        }
        return biggestStep;
    }

    public List<SemanticIdentity> getSemanticIdentities(List<NavigationStep> steps) {
        ArrayList<SemanticIdentity> result = new ArrayList<SemanticIdentity>(steps.size());
        for (NavigationStep step : steps) {
            result.add(step.getSemanticIdentity());
        }
        return result;
    }

    public NavigationStep reduceToCachedStep(NavigationStep step) {
        if (this.allNavigationSteps.containsKey(step.getSemanticIdentity())) {
            return this.allNavigationSteps.get(step.getSemanticIdentity());
        }
        this.allNavigationSteps.put(step.getSemanticIdentity(), step);
        return step;
    }

    public IndirectingStep createIndirectingStepFor(OCLExpression expr, Stack<String> tupleLiteralPartNamesToLookFor) {
        IndirectingStep result = new IndirectingStep(expr);
        this.put(expr, tupleLiteralPartNamesToLookFor, result);
        return result;
    }

    @Override
    public void beforeHashCodeChange(NavigationStep step, int token) {
        this.allNavigationSteps.remove(step.getSemanticIdentity());
    }

    @Override
    public void afterHashCodeChange(NavigationStep step, int token) {
        this.allNavigationSteps.put(step.getSemanticIdentity(), step);
    }

    @Override
    protected NavigationStep createStep(OCLExpression sourceExpression, EClass context, OperationBodyToCallMapper operationBodyToCallMapper, Stack<String> tupleLiteralNamesToLookFor, OCLFactory oclFactory) {
        NavigationStep result = this.getInstanceScopeAnalysis().createTracer(sourceExpression, tupleLiteralNamesToLookFor, oclFactory).traceback(context, this, operationBodyToCallMapper);
        NavigationStep existingEqualStep = this.allNavigationSteps.get(result);
        if (existingEqualStep != null) {
            result = existingEqualStep;
            result.addExpressionForWhichThisIsNavigationStep(sourceExpression);
        }
        return result;
    }
}

