/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.parser.model;

import java.util.ArrayList;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.snapshot.ClassHistogramRecord;
import org.eclipse.mat.snapshot.ClassLoaderHistogramRecord;
import org.eclipse.mat.snapshot.ISnapshot;
import org.eclipse.mat.snapshot.model.IClassLoader;
import org.eclipse.mat.snapshot.model.IObject;
import org.eclipse.mat.util.IProgressListener;

public final class XClassLoaderHistogramRecord
extends ClassLoaderHistogramRecord {
    private static final long serialVersionUID = 1L;

    public XClassLoaderHistogramRecord(String label, int classLoaderId, ArrayList<ClassHistogramRecord> classHistogramRecords, long numberOfObjects, long usedHeapSize, long retainedHeapSize) {
        super(label, classLoaderId, classHistogramRecords, numberOfObjects, usedHeapSize, retainedHeapSize);
    }

    public long calculateRetainedSize(ISnapshot snapshot, boolean calculateIfNotAvailable, boolean approximation, IProgressListener listener) throws SnapshotException {
        if (this.retainedHeapSize > 0L || !calculateIfNotAvailable) {
            return this.retainedHeapSize;
        }
        if (this.retainedHeapSize < 0L && approximation) {
            return this.retainedHeapSize;
        }
        IObject object = snapshot.getObject(this.classLoaderId);
        if (object instanceof IClassLoader) {
            this.retainedHeapSize = ((IClassLoader)object).getRetainedHeapSizeOfObjects(calculateIfNotAvailable, approximation, listener);
            return this.retainedHeapSize;
        }
        return super.calculateRetainedSize(snapshot, calculateIfNotAvailable, approximation, listener);
    }
}

