/*******************************************************************************
 * Copyright (c) 2004 INRIA.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *    INRIA - initial API and implementation
 *******************************************************************************/
package org.eclipse.m2m.atl.adt.ui;

/**
 * Defines status codes relevant to the Atl UI plug-in. When a Core exception is thrown, it contain a status
 * object describing the cause of the exception. The status objects originating from the Atl UI plug-in use
 * the codes defined in this interface.
 */
public interface IAtlStatusConstants {

	// Atl UI status constants start at 10000 to make sure that we don't
	// collide with resource and Atl model constants.

	/**
	 * Atl UI status constants start at 10000 to make sure that we don't collide with resource and Atl model
	 * constants.
	 */
	int INTERNAL_ERROR = 10001;

	/**
	 * Status constant indicating that an exception occurred on storing or loading templates.
	 */
	int TEMPLATE_IO_EXCEPTION = 10002;

	/**
	 * Status constant indicating that an validateEdit call has changed the content of a file on disk.
	 */
	int VALIDATE_EDIT_CHANGED_CONTENT = 10003;

	/**
	 * Status constant indicating that a <tt>ChangeAbortException</tt> has been caught.
	 */
	int CHANGE_ABORTED = 10004;

	/**
	 * Status constant indicating that an exception occurred while parsing template file.
	 */
	int TEMPLATE_PARSE_EXCEPTION = 10005;

}
