/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.axis.consumption.core.command;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.HashMap;
import org.apache.axis.tools.ant.wsdl.Java2WsdlAntTask;
import org.apache.axis.tools.ant.wsdl.NamespaceMapping;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Target;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.ws.internal.axis.consumption.core.AxisConsumptionCoreMessages;
import org.eclipse.jst.ws.internal.axis.consumption.core.common.JavaWSDLParameter;
import org.eclipse.jst.ws.internal.axis.consumption.core.context.AxisEmitterContext;
import org.eclipse.jst.ws.internal.axis.consumption.core.context.AxisEmitterDefaults;
import org.eclipse.jst.ws.internal.axis.consumption.core.plugin.WebServiceAxisConsumptionCorePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.command.internal.env.common.FileResourceUtils;
import org.eclipse.wst.command.internal.env.core.common.ProgressUtils;
import org.eclipse.wst.command.internal.env.core.common.StatusUtils;
import org.eclipse.wst.command.internal.env.core.context.ResourceContext;
import org.eclipse.wst.command.internal.env.eclipse.BaseEclipseEnvironment;
import org.eclipse.wst.common.environment.IEnvironment;
import org.eclipse.wst.common.environment.ILog;
import org.eclipse.wst.common.environment.IStatusHandler;
import org.eclipse.wst.common.frameworks.datamodel.AbstractDataModelOperation;

public class Java2WSDLCommand
extends AbstractDataModelOperation {
    private JavaWSDLParameter javaWSDLParam_;
    private File tempOutputWsdlFile;
    private final String TEMP = "temp";
    private final String WSDL_EXT = ".wsdl";

    public Java2WSDLCommand() {
    }

    public Java2WSDLCommand(JavaWSDLParameter javaWSDLParam) {
        this.javaWSDLParam_ = javaWSDLParam;
    }

    public IStatus execute(IProgressMonitor monitor, IAdaptable adaptable) {
        IEnvironment environment = this.getEnvironment();
        if (this.javaWSDLParam_ == null) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        if (this.javaWSDLParam_.getBeanName() == null) {
            IStatus status = StatusUtils.errorStatus((String)AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_PARAM_NOT_SET);
            environment.getStatusHandler().reportError(status);
            return status;
        }
        ProgressUtils.report((IProgressMonitor)monitor, (String)NLS.bind((String)AxisConsumptionCoreMessages.MSG_GENERATE_WSDL, (Object)this.javaWSDLParam_.getBeanName()));
        return this.executeAntTask(environment, monitor);
    }

    protected IStatus executeAntTask(IEnvironment environment, IProgressMonitor monitor) {
        HashMap mappings;
        IStatus status = Status.OK_STATUS;
        ILog envLog = environment.getLog();
        final class Emitter
        extends Java2WsdlAntTask {
            public Emitter() {
                super.setProject(new Project());
                super.getProject().init();
                super.setTaskType("axis");
                super.setTaskName("axis-java2wsdl");
                super.setOwningTarget(new Target());
            }
        }
        Emitter emitter = new Emitter();
        emitter.createClasspath().setPath(this.javaWSDLParam_.getClasspath());
        envLog.log(1, 5008, (Object)this, "executeAntTask", (Object)("Class Path = " + this.javaWSDLParam_.getClasspath()));
        emitter.setPortTypeName(this.javaWSDLParam_.getPortTypeName());
        envLog.log(1, 5009, (Object)this, "executeAntTask", (Object)("Port Type Name = " + this.javaWSDLParam_.getPortTypeName()));
        emitter.setServiceElementName(this.javaWSDLParam_.getServiceName());
        envLog.log(1, 5010, (Object)this, "executeAntTask", (Object)("Service Name = " + this.javaWSDLParam_.getServiceName()));
        emitter.setLocation(this.javaWSDLParam_.getUrlLocation());
        envLog.log(1, 5011, (Object)this, "executeAntTask", (Object)("URL Location = " + this.javaWSDLParam_.getUrlLocation()));
        emitter.setMethods(this.javaWSDLParam_.getMethodString());
        envLog.log(1, 5012, (Object)this, "executeAntTask", (Object)("Methods = " + this.javaWSDLParam_.getMethodString()));
        emitter.setStyle(this.javaWSDLParam_.getStyle());
        envLog.log(1, 5013, (Object)this, "executeAntTask", (Object)("Style = " + this.javaWSDLParam_.getStyle()));
        emitter.setUse(this.javaWSDLParam_.getUse());
        envLog.log(1, 5014, (Object)this, "executeAntTask", (Object)("Use = " + this.javaWSDLParam_.getUse()));
        IPath pluginStateLoc = WebServiceAxisConsumptionCorePlugin.getInstance().getStateLocation();
        File tempDir = new File(pluginStateLoc.toString());
        File newTempFile = null;
        try {
            this.tempOutputWsdlFile = newTempFile = File.createTempFile("temp", ".wsdl", tempDir);
        }
        catch (Exception exception) {
            this.tempOutputWsdlFile = new File(pluginStateLoc.append("temp.wsdl").toString());
        }
        emitter.setOutput(this.tempOutputWsdlFile);
        envLog.log(1, 5015, (Object)this, "executeAntTask", (Object)("WSDL Location = " + this.javaWSDLParam_.getOutputWsdlLocation()));
        emitter.setNamespace(this.javaWSDLParam_.getNamespace());
        envLog.log(1, 5016, (Object)this, "executeAntTask", (Object)("Name Space = " + this.javaWSDLParam_.getNamespace()));
        emitter.setClassName(this.javaWSDLParam_.getBeanName());
        envLog.log(1, 5017, (Object)this, "executeAntTask", (Object)("Bean name = " + this.javaWSDLParam_.getBeanName()));
        emitter.setImplClass(this.javaWSDLParam_.getBeanName());
        AxisEmitterContext context = WebServiceAxisConsumptionCorePlugin.getInstance().getAxisEmitterContext();
        if (context.isUseInheritedMethodsEnabled() != AxisEmitterDefaults.getUseInheritedMethodsDefault()) {
            emitter.setUseInheritedMethods(context.isUseInheritedMethodsEnabled());
            envLog.log(1, 5099, (Object)this, "executeAntTask", (Object)(" set UseInheritedMethods : " + context.isUseInheritedMethodsEnabled()));
        }
        if ((mappings = this.javaWSDLParam_.getMappings()) != null) {
            for (String pakage : mappings.keySet()) {
                String namespace = (String)mappings.get(pakage);
                NamespaceMapping map = new NamespaceMapping();
                map.setPackage(pakage);
                map.setNamespace(namespace);
                emitter.addMapping(map);
            }
        }
        try {
            try {
                emitter.execute();
                status = this.moveGeneratedWSDL(environment, monitor);
            }
            catch (BuildException e) {
                envLog.log(4, 5018, (Object)this, "executeAntTask", (Throwable)e);
                status = StatusUtils.errorStatus((String)(AxisConsumptionCoreMessages.MSG_ERROR_JAVA_WSDL_GENERATE + " " + e.getCause().toString()), (Throwable)e.getCause());
                environment.getStatusHandler().reportError(status);
                IStatus iStatus = status;
                if (this.tempOutputWsdlFile.exists()) {
                    this.tempOutputWsdlFile.delete();
                }
                return iStatus;
            }
        }
        finally {
            if (this.tempOutputWsdlFile.exists()) {
                this.tempOutputWsdlFile.delete();
            }
        }
        return status;
    }

    public IStatus moveGeneratedWSDL(IEnvironment environment, IProgressMonitor monitor) {
        IStatus status;
        block15: {
            status = Status.OK_STATUS;
            FileInputStream finStream = null;
            ResourceContext context = ((BaseEclipseEnvironment)environment).getResourceContext();
            IStatusHandler statusHandler = environment.getStatusHandler();
            String outputWsdlLocation = this.javaWSDLParam_.getOutputWsdlLocation();
            Path targetPath = new Path(outputWsdlLocation);
            try {
                try {
                    finStream = new FileInputStream(this.tempOutputWsdlFile);
                    if (finStream != null) {
                        FileResourceUtils.createFileAtLocation((ResourceContext)context, (IPath)targetPath.makeAbsolute(), (InputStream)finStream, (IProgressMonitor)monitor, (IStatusHandler)statusHandler);
                        finStream.close();
                    }
                }
                catch (Exception e) {
                    status = StatusUtils.errorStatus((String)NLS.bind((String)AxisConsumptionCoreMessages.MSG_ERROR_MOVE_RESOURCE, (Object[])new String[]{e.getLocalizedMessage()}), (Throwable)e);
                    environment.getStatusHandler().reportError(status);
                    try {
                        if (finStream != null) {
                            finStream.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (finStream != null) {
                        finStream.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (finStream != null) {
                    finStream.close();
                }
            }
            catch (IOException iOException) {}
        }
        return status;
    }

    public Status undo(IEnvironment environment) {
        return null;
    }

    public Status redo(IEnvironment environment) {
        return null;
    }

    public JavaWSDLParameter getJavaWSDLParam() {
        return this.javaWSDLParam_;
    }

    public void setJavaWSDLParam(JavaWSDLParameter javaWSDLParm) {
        this.javaWSDLParam_ = javaWSDLParm;
    }

    public String getWsdlURI() {
        File file = new File(this.getJavaWSDLParam().getOutputWsdlLocation());
        String url = "";
        try {
            url = file.toURL().toString();
        }
        catch (MalformedURLException malformedURLException) {}
        return url;
    }
}

