/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.ui.internal.classpath;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension2;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.jst.jsf.core.internal.jsflibraryconfig.JSFLibraryRegistryUtil;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.JSFLibrary;
import org.eclipse.jst.jsf.core.internal.jsflibraryregistry.PluginProvidedJSFLibrary;
import org.eclipse.jst.jsf.core.jsfappconfig.JSFAppConfigUtils;
import org.eclipse.jst.jsf.core.jsflibraryconfiguration.JSFLibraryConfigurationHelper;
import org.eclipse.jst.jsf.ui.internal.JSFUiPlugin;
import org.eclipse.jst.jsf.ui.internal.Messages;
import org.eclipse.jst.jsf.ui.internal.classpath.JSFLibraryWizard;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class JSFLibraryContainerWizardPage
extends WizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension,
IClasspathContainerPageExtension2 {
    private CheckboxTableViewer lv;
    private JSFLibrariesTableViewerAdapter lvAdapter;
    private JSFLibrariesListLabelProvider lvLabelProvider;
    private boolean isJSFProject = false;
    private IClasspathEntry containerEntry;
    private IClasspathEntry[] currentEntries;
    private Map _currentLibs;
    private JSFLibrary currentLib;
    private IProject _iproject;

    public JSFLibraryContainerWizardPage() {
        super(Messages.JSFLibraryContainerWizardPage_PageName);
        this.setTitle(Messages.JSFLibraryContainerWizardPage_Title);
        this.setDescription(Messages.JSFLibraryContainerWizardPage_Description);
        this.setImageDescriptor(JSFUiPlugin.getImageDescriptor("full/wizban/addlibrary_wiz.gif"));
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries_) {
        this.currentEntries = currentEntries_;
        this._iproject = project.getProject();
        this.isJSFProject = JSFAppConfigUtils.isValidJSFProject((IProject)this._iproject);
    }

    public boolean finish() {
        return true;
    }

    public IClasspathEntry[] getNewContainers() {
        Path cp = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer");
        ArrayList<IClasspathEntry> res = new ArrayList<IClasspathEntry>();
        Object[] items = this.lv.getCheckedElements();
        int i = 0;
        while (i < items.length) {
            JSFLibrary jsfLib = (JSFLibrary)items[i];
            if (this.getSelectedJSFLibariesForProject().get(jsfLib.getID()) == null) {
                IPath path = cp.append((IPath)new Path(jsfLib.getID()));
                IClasspathEntry entry = JavaCore.newContainerEntry((IPath)path);
                res.add(entry);
            }
            ++i;
        }
        return res.toArray(new IClasspathEntry[0]);
    }

    public boolean isPageComplete() {
        if (!this.isJSFProject) {
            return false;
        }
        if (this.isEditReference() && !this.selectionHasChanged()) {
            return false;
        }
        return this.isValid();
    }

    private boolean isValid() {
        return this.isCheckedItems() && this.getErrorMessage() == null;
    }

    private boolean selectionHasChanged() {
        JSFLibrary lib = this.getCurrentLibrarySelection();
        if (lib == null) {
            return false;
        }
        return this.getJSFLibraryForEdit(this.containerEntry) != lib;
    }

    private JSFLibrary getCurrentLibrarySelection() {
        JSFLibrary lib = null;
        StructuredSelection ssel = (StructuredSelection)this.lv.getSelection();
        if (ssel != null && !ssel.isEmpty()) {
            lib = (JSFLibrary)ssel.getFirstElement();
        }
        return lib;
    }

    private boolean isCheckedItems() {
        return this.lv.getCheckedElements().length > 0;
    }

    public IClasspathEntry getSelection() {
        IClasspathEntry entry = null;
        if (this.isEditReference()) {
            if (this.lv.getCheckedElements().length == 0) {
                return this.containerEntry;
            }
            JSFLibrary lib = (JSFLibrary)this.lv.getCheckedElements()[0];
            if (lib != null) {
                if (lib == this.getJSFLibraryForEdit(this.containerEntry)) {
                    return this.containerEntry;
                }
                IPath path = new Path("org.eclipse.jst.jsf.core.internal.jsflibrarycontainer").append((IPath)new Path(lib.getID()));
                entry = JavaCore.newContainerEntry((IPath)path, (IAccessRule[])this.containerEntry.getAccessRules(), (IClasspathAttribute[])this.containerEntry.getExtraAttributes(), (boolean)this.containerEntry.isExported());
            }
        }
        return entry;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.containerEntry = containerEntry;
    }

    public void createControl(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayout((Layout)new GridLayout(2, false));
        c.setLayoutData((Object)new GridData(1808));
        if (!this.isJSFProject) {
            Label warning = new Label(c, 0);
            warning.setText(Messages.JSFLibraryContainerWizardPage_WarningNoJSFFacet);
            this.setControl((Control)c);
            return;
        }
        Label lblViewer = new Label(c, 0);
        lblViewer.setText(Messages.JSFLibraryContainerWizardPage_JSFLibraries);
        GridData gd1 = new GridData(1);
        gd1.horizontalSpan = 2;
        lblViewer.setLayoutData((Object)gd1);
        this.lv = this.createTableViewer(c);
        this.lv.getControl().setLayoutData((Object)new GridData(1808));
        this.lvAdapter = new JSFLibrariesTableViewerAdapter();
        this.lvLabelProvider = new JSFLibrariesListLabelProvider();
        this.lv.setContentProvider((IContentProvider)this.lvAdapter);
        this.lv.setLabelProvider((IBaseLabelProvider)this.lvLabelProvider);
        this.lv.addSelectionChangedListener((ISelectionChangedListener)this.lvAdapter);
        this.lv.addDoubleClickListener((IDoubleClickListener)this.lvAdapter);
        this.lv.setComparator((ViewerComparator)this.lvAdapter);
        Composite buttons = new Composite(c, 0);
        buttons.setLayout((Layout)new GridLayout(1, false));
        buttons.setLayoutData((Object)new GridData(1040));
        Button addButton = new Button(buttons, 0);
        addButton.setText(Messages.JSFLibraryContainerWizardPage_Add);
        addButton.setLayoutData((Object)new GridData(3));
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JSFLibraryContainerWizardPage.this.openJSFLibraryWizard(null);
            }
        });
        final Button editButton = new Button(buttons, 0);
        editButton.setText(Messages.JSFLibraryContainerWizardPage_Edit);
        editButton.setLayoutData((Object)new GridData(3));
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection sel = (StructuredSelection)JSFLibraryContainerWizardPage.this.lv.getSelection();
                if ((sel == null || sel.isEmpty()) && JSFLibraryContainerWizardPage.this.containerEntry != null) {
                    JSFLibrary jsfLib = JSFLibraryContainerWizardPage.this.getJSFLibraryForEdit(JSFLibraryContainerWizardPage.this.containerEntry);
                    sel = new StructuredSelection((Object)jsfLib);
                }
                JSFLibraryContainerWizardPage.this.openJSFLibraryWizard((IStructuredSelection)sel);
            }
        });
        editButton.setVisible(false);
        this.lv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                this.setEditButton(event.getSelection());
            }

            private void setEditButton(ISelection selection) {
                IStructuredSelection sel = (IStructuredSelection)selection;
                editButton.setVisible(sel.size() == 1);
                if (sel.size() == 1) {
                    JSFLibrary lib = (JSFLibrary)sel.getFirstElement();
                    boolean pp = lib instanceof PluginProvidedJSFLibrary;
                    editButton.setEnabled(!pp);
                    if (JSFLibraryContainerWizardPage.this.isEditReference()) {
                        JSFLibraryContainerWizardPage.this.lv.setAllChecked(false);
                        JSFLibraryContainerWizardPage.this.lv.setChecked((Object)lib, true);
                    }
                }
            }
        });
        this.setControl((Control)c);
        if (this.isEditReference()) {
            JSFLibrary lib = this.getJSFLibraryForEdit(this.containerEntry);
            this.lv.setInput(this.getAllUnselectedJSFLibrariesExceptReferencedLib(lib));
            this.selectAndCheckCurrentLib(lib);
            this.setDescription(Messages.JSFLibraryContainerWizardPage_EditLibrary_DescriptionText);
        } else {
            this.lv.setInput((Object)this.getAllJSFLibraries());
            this.lv.setCheckedElements(this.getSelectedJSFLibariesForProject().values().toArray(new Object[0]));
        }
    }

    private void selectAndCheckCurrentLib(JSFLibrary lib) {
        if (lib != null) {
            StructuredSelection ssel = new StructuredSelection((Object)lib);
            this.lv.setSelection((ISelection)ssel);
            this.lv.setChecked((Object)lib, true);
        }
    }

    private Object getAllUnselectedJSFLibrariesExceptReferencedLib(JSFLibrary referenceLib) {
        List allLibs = this.getAllJSFLibraries();
        Collection selLibs = this.getSelectedJSFLibariesForProject().values();
        for (JSFLibrary aLib : selLibs) {
            int i = allLibs.indexOf(aLib);
            if (i < 0 || referenceLib != null && (aLib == null || aLib.getID().equals(referenceLib.getID()))) continue;
            allLibs.remove(i);
        }
        return allLibs;
    }

    private List getJSFLibraryEntries(IClasspathEntry[] entries) {
        ArrayList<JSFLibrary> jsfLibs = new ArrayList<JSFLibrary>();
        int i = 0;
        while (i < entries.length) {
            JSFLibrary lib;
            IClasspathEntry entry = entries[i];
            if (JSFLibraryConfigurationHelper.isJSFLibraryContainer((IClasspathEntry)entry) && (lib = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getJSFLibraryByID(this.getLibraryId(entry))) != null) {
                jsfLibs.add(lib);
            }
            ++i;
        }
        return jsfLibs;
    }

    private String getLibraryId(IClasspathEntry entry) {
        return entry.getPath().segment(1);
    }

    private void openJSFLibraryWizard(IStructuredSelection element) {
        JSFLibraryWizard wizard = new JSFLibraryWizard();
        IWorkbench wb = PlatformUI.getWorkbench();
        wizard.init(wb, element);
        WizardDialog dialog = new WizardDialog(wb.getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
        int ret = dialog.open();
        if (ret == 0) {
            if (this.containerEntry == null) {
                this.lv.setInput((Object)this.getAllJSFLibraries());
            } else {
                this.lv.setInput(this.getAllUnselectedJSFLibrariesExceptReferencedLib(this.getJSFLibraryForEdit(this.containerEntry)));
                this.lv.refresh(true);
            }
            this.lv.refresh();
        }
    }

    private CheckboxTableViewer createTableViewer(Composite parent) {
        Table table = new Table(parent, 2850);
        table.setFont(parent.getFont());
        CheckboxTableViewer tableViewer = new CheckboxTableViewer(table);
        tableViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent e) {
                if (!JSFLibraryContainerWizardPage.this.isEditReference()) {
                    if (JSFLibraryContainerWizardPage.this.getSelectedJSFLibariesForProject().get(((JSFLibrary)e.getElement()).getID()) != null) {
                        if (JSFLibraryContainerWizardPage.this.containerEntry == null) {
                            e.getCheckable().setChecked(e.getElement(), true);
                        } else {
                            JSFLibraryContainerWizardPage.this.lv.setAllChecked(true);
                        }
                    }
                } else {
                    JSFLibraryContainerWizardPage.this.lv.setAllChecked(false);
                    JSFLibraryContainerWizardPage.this.lv.setChecked(e.getElement(), true);
                    if (JSFLibraryContainerWizardPage.this.isEditReference()) {
                        JSFLibraryContainerWizardPage.this.lv.setSelection((ISelection)new StructuredSelection(e.getElement()));
                    }
                }
                JSFLibraryContainerWizardPage.this.validate();
            }
        });
        return tableViewer;
    }

    private Map getSelectedJSFLibariesForProject() {
        if (this._currentLibs == null) {
            List allLibs = this.getAllJSFLibraries();
            List curLibs = this.getJSFLibraryEntries(this.currentEntries);
            this._currentLibs = new HashMap(curLibs.size());
            for (JSFLibrary lib : curLibs) {
                int index = this.getIndex(allLibs, lib);
                if (index < 0) continue;
                this._currentLibs.put(lib.getID(), allLibs.get(index));
            }
        }
        return this._currentLibs;
    }

    private List getAllJSFLibraries() {
        EList allLibs = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getAllJSFLibraries();
        return allLibs;
    }

    private JSFLibrary getJSFLibraryForEdit(IClasspathEntry containerEntry_) {
        if (this.currentLib == null) {
            String id = this.getLibraryId(containerEntry_);
            this.currentLib = JSFLibraryRegistryUtil.getInstance().getJSFLibraryRegistry().getJSFLibraryByID(id);
        }
        return this.currentLib;
    }

    private int getIndex(List libs, JSFLibrary lib) {
        int i = 0;
        while (i < libs.size()) {
            if (lib.getID().equals(((JSFLibrary)libs.get(i)).getID())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private void validate() {
        this.setErrorMessage(null);
        int implChosenCount = this.implSelectedCount();
        if (implChosenCount > 1) {
            this.setErrorMessage(Messages.JSFLibraryContainerWizardPage_ImplAlreadyPresent);
        }
        this.setPageComplete(this.isPageComplete());
    }

    private boolean isEditReference() {
        return this.containerEntry != null;
    }

    private int implSelectedCount() {
        int count = 0;
        int i = 0;
        while (i < this.lv.getCheckedElements().length) {
            JSFLibrary lib = (JSFLibrary)this.lv.getCheckedElements()[i];
            if (lib.isImplementation()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    private void doDoubleClick(DoubleClickEvent event) {
        StructuredSelection ssel = (StructuredSelection)event.getSelection();
        if (ssel != null && !((JSFLibrary)ssel.getFirstElement() instanceof PluginProvidedJSFLibrary)) {
            this.openJSFLibraryWizard((IStructuredSelection)event.getSelection());
        }
    }

    private static class JSFLibrariesListLabelProvider
    implements ILabelProvider {
        Image libImg;

        private JSFLibrariesListLabelProvider() {
        }

        public Image getImage(Object element) {
            if (this.libImg == null) {
                ImageDescriptor libImgDesc = JSFUiPlugin.getImageDescriptor("obj16/library_obj.gif");
                this.libImg = libImgDesc.createImage();
            }
            return this.libImg;
        }

        public String getText(Object element) {
            if (element instanceof JSFLibrary) {
                JSFLibrary lib = (JSFLibrary)element;
                if (lib.isImplementation()) {
                    return lib.getLabel() + " " + Messages.JSFLibrariesPreferencePage_IMPL_DESC;
                }
                return lib.getLabel();
            }
            return null;
        }

        public void dispose() {
            if (this.libImg != null) {
                this.libImg.dispose();
            }
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    private class JSFLibrariesTableViewerAdapter
    extends ViewerComparator
    implements IStructuredContentProvider,
    ISelectionChangedListener,
    IDoubleClickListener {
        private Object input;

        private JSFLibrariesTableViewerAdapter() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return ((List)this.input).toArray();
        }

        public void selectionChanged(SelectionChangedEvent event) {
            if (JSFLibraryContainerWizardPage.this.isEditReference()) {
                JSFLibraryContainerWizardPage.this.setPageComplete(JSFLibraryContainerWizardPage.this.isPageComplete());
            }
        }

        public void doubleClick(DoubleClickEvent event) {
            JSFLibraryContainerWizardPage.this.doDoubleClick(event);
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            boolean lib2Sel;
            JSFLibrary lib1 = (JSFLibrary)e1;
            JSFLibrary lib2 = (JSFLibrary)e2;
            boolean lib1Sel = JSFLibraryContainerWizardPage.this.getSelectedJSFLibariesForProject().get(lib1.getID()) != null;
            boolean bl = lib2Sel = JSFLibraryContainerWizardPage.this.getSelectedJSFLibariesForProject().get(lib2.getID()) != null;
            if (lib1Sel && lib2Sel || !lib1Sel && !lib2Sel) {
                return this.getComparator().compare(lib1.getLabel(), lib2.getLabel());
            }
            if (lib1Sel) {
                return -1;
            }
            return 1;
        }
    }
}

