/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.source;

import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.ElementIndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.internal.utility.jdt.NestedDeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.resource.java.JavaResourceAnnotatedElement;
import org.eclipse.jpt.common.core.resource.java.JavaResourceModel;
import org.eclipse.jpt.common.core.utility.jdt.AnnotatedElement;
import org.eclipse.jpt.common.core.utility.jdt.AnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.DeclarationAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedAnnotationAdapter;
import org.eclipse.jpt.common.core.utility.jdt.IndexedDeclarationAnnotationAdapter;
import org.eclipse.jpt.jpa.core.internal.jpa2.resource.java.NullAssociationOverrideJoinTableAnnotation2_0;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceAssociationOverrideAnnotation;
import org.eclipse.jpt.jpa.core.internal.resource.java.source.SourceJoinTableAnnotation;
import org.eclipse.jpt.jpa.core.jpa2.resource.java.AssociationOverrideAnnotation2_0;
import org.eclipse.jpt.jpa.core.resource.java.JoinTableAnnotation;

public final class SourceAssociationOverrideAnnotation2_0
extends SourceAssociationOverrideAnnotation
implements AssociationOverrideAnnotation2_0 {
    private ElementAnnotationAdapter joinTableAdapter = this.buildJoinTableAdapter();
    private JoinTableAnnotation joinTable;
    private final JoinTableAnnotation nullJoinTable = this.buildNullJoinTable();

    public static SourceAssociationOverrideAnnotation2_0 buildSourceAssociationOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element) {
        return new SourceAssociationOverrideAnnotation2_0(parent, element, DECLARATION_ANNOTATION_ADAPTER);
    }

    public static SourceAssociationOverrideAnnotation2_0 buildSourceAssociationOverrideAnnotation(JavaResourceAnnotatedElement parent, AnnotatedElement annotatedElement, int index) {
        IndexedDeclarationAnnotationAdapter idaa = SourceAssociationOverrideAnnotation2_0.buildAssociationOverrideDeclarationAnnotationAdapter(index);
        IndexedAnnotationAdapter iaa = SourceAssociationOverrideAnnotation2_0.buildAssociationOverrideAnnotationAdapter(annotatedElement, idaa);
        return new SourceAssociationOverrideAnnotation2_0((JavaResourceModel)parent, annotatedElement, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)iaa);
    }

    public static SourceAssociationOverrideAnnotation2_0 buildNestedSourceAssociationOverrideAnnotation(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        return new SourceAssociationOverrideAnnotation2_0(parent, element, idaa);
    }

    private SourceAssociationOverrideAnnotation2_0(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa) {
        this(parent, element, daa, (AnnotationAdapter)new ElementAnnotationAdapter(element, daa));
    }

    private SourceAssociationOverrideAnnotation2_0(JavaResourceModel parent, AnnotatedElement element, IndexedDeclarationAnnotationAdapter idaa) {
        this(parent, element, (DeclarationAnnotationAdapter)idaa, (AnnotationAdapter)new ElementIndexedAnnotationAdapter(element, idaa));
    }

    private SourceAssociationOverrideAnnotation2_0(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter daa, AnnotationAdapter annotationAdapter) {
        super(parent, element, daa, annotationAdapter);
    }

    public void initialize(CompilationUnit astRoot) {
        super.initialize(astRoot);
        Annotation joinTableAnnotation = this.joinTableAdapter.getAnnotation(astRoot);
        if (joinTableAnnotation != null) {
            this.joinTable = SourceAssociationOverrideAnnotation2_0.buildJoinTableAnnotation((JavaResourceModel)this, this.annotatedElement, this.daa);
            this.joinTable.initialize(joinTableAnnotation);
        }
    }

    public void synchronizeWith(CompilationUnit astRoot) {
        super.synchronizeWith(astRoot);
        this.syncJoinTable(astRoot);
    }

    @Override
    public JoinTableAnnotation getJoinTable() {
        return this.joinTable;
    }

    @Override
    public JoinTableAnnotation getNonNullJoinTable() {
        return this.joinTable != null ? this.joinTable : this.nullJoinTable;
    }

    @Override
    public JoinTableAnnotation addJoinTable() {
        if (this.joinTable != null) {
            throw new IllegalStateException("'joinTable' element already exists: " + String.valueOf(this.joinTable));
        }
        this.joinTable = SourceAssociationOverrideAnnotation2_0.buildJoinTableAnnotation((JavaResourceModel)this, this.annotatedElement, this.daa);
        this.joinTable.newAnnotation();
        return this.joinTable;
    }

    @Override
    public void removeJoinTable() {
        if (this.joinTable == null) {
            throw new IllegalStateException("'joinTable' element does not exist");
        }
        JoinTableAnnotation old = this.joinTable;
        this.joinTable = null;
        old.removeAnnotation();
    }

    private void syncJoinTable(CompilationUnit astRoot) {
        Annotation joinTableAnnotation = this.joinTableAdapter.getAnnotation(astRoot);
        if (joinTableAnnotation == null) {
            this.syncJoinTable_(null);
        } else if (this.joinTable == null) {
            JoinTableAnnotation table = SourceAssociationOverrideAnnotation2_0.buildJoinTableAnnotation((JavaResourceModel)this, this.annotatedElement, this.daa);
            table.initialize(joinTableAnnotation);
            this.syncJoinTable_(table);
        } else {
            this.joinTable.synchronizeWith(joinTableAnnotation);
        }
    }

    private void syncJoinTable_(JoinTableAnnotation astJoinTable) {
        JoinTableAnnotation old = this.joinTable;
        this.joinTable = astJoinTable;
        this.firePropertyChanged("joinTable", old, astJoinTable);
    }

    private ElementAnnotationAdapter buildJoinTableAdapter() {
        return new ElementAnnotationAdapter(this.annotatedElement, SourceAssociationOverrideAnnotation2_0.buildJoinTableAnnotationAdapter(this.daa));
    }

    private JoinTableAnnotation buildNullJoinTable() {
        return new NullAssociationOverrideJoinTableAnnotation2_0(this);
    }

    @Override
    public boolean isUnset() {
        return super.isUnset() && this.joinTable == null;
    }

    static JoinTableAnnotation buildJoinTableAnnotation(JavaResourceModel parent, AnnotatedElement element, DeclarationAnnotationAdapter associationOverrideAnnotationAdapter) {
        return new SourceJoinTableAnnotation(parent, element, SourceAssociationOverrideAnnotation2_0.buildJoinTableAnnotationAdapter(associationOverrideAnnotationAdapter));
    }

    static DeclarationAnnotationAdapter buildJoinTableAnnotationAdapter(DeclarationAnnotationAdapter associationOverrideAnnotationAdapter) {
        return new NestedDeclarationAnnotationAdapter(associationOverrideAnnotationAdapter, "joinTable", "javax.persistence.JoinTable");
    }
}

