/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.layout;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public final class FillLayoutFactory {
    private FillLayout layout;

    public static FillLayoutFactory fillDefaults() {
        return new FillLayoutFactory(FillLayoutFactory.copyLayout(new FillLayout()));
    }

    private FillLayoutFactory(FillLayout l) {
        this.layout = l;
    }

    public static FillLayoutFactory createFrom(FillLayout l) {
        return new FillLayoutFactory(FillLayoutFactory.copyLayout(l));
    }

    public FillLayoutFactory copy() {
        return new FillLayoutFactory(this.create());
    }

    public FillLayoutFactory margins(Point margins) {
        this.layout.marginWidth = margins.x;
        this.layout.marginHeight = margins.y;
        return this;
    }

    public FillLayoutFactory margins(int width, int height) {
        this.layout.marginWidth = width;
        this.layout.marginHeight = height;
        return this;
    }

    public FillLayoutFactory extendedMargins(int width, int height) {
        this.layout.marginWidth += width;
        this.layout.marginHeight += height;
        return this;
    }

    public FillLayout create() {
        return FillLayoutFactory.copyLayout(this.layout);
    }

    public void applyTo(Composite c) {
        c.setLayout((Layout)FillLayoutFactory.copyLayout(this.layout));
    }

    public static FillLayout copyLayout(FillLayout l) {
        FillLayout result = new FillLayout();
        result.marginHeight = l.marginHeight;
        result.marginWidth = l.marginWidth;
        result.spacing = l.spacing;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FillLayout()\n");
        if (this.layout.marginWidth != 0 || this.layout.marginHeight != 0) {
            builder.append("    .margins(");
            builder.append(this.layout.marginWidth);
            builder.append(", ");
            builder.append(this.layout.marginHeight);
            builder.append(")\n");
        }
        return builder.toString();
    }
}

