/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.snippeteditor;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.JavaSnippetEditor;
import org.eclipse.jdt.internal.debug.ui.snippeteditor.SnippetMessages;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ShowInPackageViewAction
extends Action {
    private JavaSnippetEditor fEditor;

    public ShowInPackageViewAction() {
        super(SnippetMessages.getString("ShowInPackageViewAction.label"));
        this.setDescription(SnippetMessages.getString("ShowInPackageViewAction.description"));
        this.setToolTipText(SnippetMessages.getString("ShowInPackageViewAction.tooltip"));
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.show_in_packageview_action_context");
    }

    public ShowInPackageViewAction(JavaSnippetEditor editor) {
        this();
        this.fEditor = editor;
    }

    public void run() {
        IFile file = this.fEditor.getFile();
        if (file == null) {
            return;
        }
        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
        if (!this.reveal(view, file)) {
            MessageDialog.openInformation((Shell)this.fEditor.getShell(), (String)ShowInPackageViewAction.getDialogTitle(), (String)SnippetMessages.getString("ShowInPackageViewAction.not_found"));
        }
    }

    private boolean reveal(PackageExplorerPart view, Object element) {
        if (view == null) {
            return false;
        }
        view.selectReveal((ISelection)new StructuredSelection(element));
        IElementComparer comparer = view.getTreeViewer().getComparer();
        Object selected = this.getSelectedElement(view);
        return comparer != null ? comparer.equals(element, selected) : element.equals(selected);
    }

    private Object getSelectedElement(PackageExplorerPart view) {
        return ((IStructuredSelection)view.getSite().getSelectionProvider().getSelection()).getFirstElement();
    }

    private static String getDialogTitle() {
        return SnippetMessages.getString("ShowInPackageViewAction.dialog.title");
    }
}

