/*******************************************************************************
 * Copyright (c) 2000, 2007 IBM Corporation and others.
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0 which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 * 
 * SPDX-License-Identifier: EPL-2.0
 *
 
 *******************************************************************************/
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.IProjectFragment;

/**
 * Query that can be used when manipulating package fragment roots.
 * Depending on the context, <code>confirmManipulation</code> can be used to
 * determine wheter, for example, the package fragment root is to be deleted or
 * not or if the buildpath of the referencing projects is to be updated.
 */
public interface IProjectFragmentManipulationQuery {
	
	public boolean confirmManipulation(IProjectFragment root, IScriptProject[] referencingProjects);
}
