/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.lsp.internal.server;

import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.cdt.internal.core.LRUCache;
import org.eclipse.cdt.lsp.util.LspUtils;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.genericeditor.ExtensionBasedTextEditor;

public final class CLanguageServerEnableCache
implements IContentTypeManager.IContentTypeChangeListener,
IPartListener,
IWindowListener {
    private static final int BUFFER_SIZE = 100;
    private static final String C_SOURCE = "org.eclipse.cdt.core.cSource";
    private static final String CXX_SOURCE = "org.eclipse.cdt.core.cxxSource";
    private static final String C_HEADER = "org.eclipse.cdt.core.cHeader";
    private static final String CXX_HEADER = "org.eclipse.cdt.core.cxxHeader";
    private static final Map<URI, Data> cache = Collections.synchronizedMap(new LRUCache(100));
    private static CLanguageServerEnableCache instance = null;

    private CLanguageServerEnableCache() {
        Platform.getContentTypeManager().addContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)this);
        if (PlatformUI.isWorkbenchRunning()) {
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.addWindowListener((IWindowListener)this);
            Arrays.stream(workbench.getWorkbenchWindows()).map(IWorkbenchWindow::getPages).flatMap(Arrays::stream).forEach(p -> p.addPartListener((IPartListener)this));
        }
    }

    private static void clearAll() {
        cache.clear();
    }

    public static void stop() {
        if (instance != null) {
            Platform.getContentTypeManager().removeContentTypeChangeListener((IContentTypeManager.IContentTypeChangeListener)instance);
            IWorkbench workbench = PlatformUI.getWorkbench();
            workbench.removeWindowListener((IWindowListener)instance);
            Arrays.stream(workbench.getWorkbenchWindows()).map(IWorkbenchWindow::getPages).flatMap(Arrays::stream).forEach(p -> p.removePartListener((IPartListener)instance));
        }
        CLanguageServerEnableCache.clearAll();
    }

    public static synchronized CLanguageServerEnableCache getInstance() {
        if (instance == null) {
            instance = new CLanguageServerEnableCache();
        }
        return instance;
    }

    public Optional<Boolean> get(URI uri) {
        return Optional.ofNullable(cache.get(uri)).map(data -> data.enable);
    }

    public void disable(URI uri) {
        cache.put(uri, new Data(false));
    }

    public void contentTypeChanged(IContentTypeManager.ContentTypeChangeEvent event) {
        String id = event.getContentType().getId();
        if (C_SOURCE.contentEquals(id) || CXX_SOURCE.contentEquals(id) || C_HEADER.contentEquals(id) || CXX_HEADER.contentEquals(id)) {
            CLanguageServerEnableCache.clearAll();
            LspUtils.getFilesInLspBasedEditor().forEach((hash, uri) -> {
                Data data = cache.get(uri);
                if (data != null) {
                    data.addEditor((Integer)hash);
                } else {
                    cache.put((URI)uri, new Data(true, (int)hash));
                }
            });
        }
    }

    public void partActivated(IWorkbenchPart part) {
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
        ExtensionBasedTextEditor editor;
        if (part instanceof ExtensionBasedTextEditor && LspUtils.checkForCContentType((editor = (ExtensionBasedTextEditor)part).getEditorInput())) {
            Optional.ofNullable(LSPEclipseUtils.toUri((IEditorInput)editor.getEditorInput())).ifPresent(uri -> {
                Data data = cache.get(uri);
                if (data != null) {
                    data.removeEditor(part.hashCode());
                    if (data.allEditorsClosed()) {
                        cache.remove(uri);
                    }
                }
            });
        }
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        ExtensionBasedTextEditor editor;
        if (part instanceof ExtensionBasedTextEditor && LspUtils.checkForCContentType((editor = (ExtensionBasedTextEditor)part).getEditorInput())) {
            Optional.ofNullable(LSPEclipseUtils.toUri((IEditorInput)editor.getEditorInput())).ifPresent(uri -> {
                int hash = part.hashCode();
                Data data = cache.get(uri);
                if (data != null) {
                    data.enable = true;
                    data.addEditor(hash);
                } else {
                    cache.put((URI)uri, new Data(true, hash));
                }
            });
        }
    }

    public void windowActivated(IWorkbenchWindow window) {
    }

    public void windowDeactivated(IWorkbenchWindow window) {
    }

    public void windowClosed(IWorkbenchWindow window) {
        Arrays.stream(window.getPages()).forEach(p -> p.removePartListener((IPartListener)this));
    }

    public void windowOpened(IWorkbenchWindow window) {
        Arrays.stream(window.getPages()).forEach(p -> p.addPartListener((IPartListener)this));
    }

    private final class Data {
        boolean enable = false;
        List<Integer> editorHashes = new ArrayList<Integer>();

        private Data(boolean enable) {
            this.enable = enable;
        }

        private Data(boolean enable, int hash) {
            this.enable = enable;
            this.addEditor(hash);
        }

        private void addEditor(Integer hash) {
            Integer h = hash;
            if (h != 0) {
                this.editorHashes.add(h);
            }
        }

        private void removeEditor(Integer hash) {
            Integer h = hash;
            if (this.editorHashes.contains(h)) {
                this.editorHashes.remove(h);
            }
        }

        private boolean allEditorsClosed() {
            return this.editorHashes.isEmpty();
        }
    }
}

