/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wsil.impl.extension.wsdl;

import org.apache.wsil.QName;
import org.apache.wsil.WSILElement;
import org.apache.wsil.WSILException;
import org.apache.wsil.extension.ExtensionElement;
import org.apache.wsil.extension.ExtensionReader;
import org.apache.wsil.extension.wsdl.ImplementedBinding;
import org.apache.wsil.extension.wsdl.Reference;
import org.apache.wsil.extension.wsdl.ReferencedService;
import org.apache.wsil.impl.extension.wsdl.ImplementedBindingImpl;
import org.apache.wsil.impl.extension.wsdl.ReferenceImpl;
import org.apache.wsil.impl.extension.wsdl.ReferencedServiceImpl;
import org.apache.wsil.util.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class WSDLExtensionReader
implements ExtensionReader {
    @Override
    public ExtensionElement parseElement(Element element, WSILElement wsilElement) throws WSILException {
        ExtensionElement extElement = null;
        QName qname = new QName(element);
        if (qname.equals(Reference.QNAME)) {
            extElement = this.parseReference(element, wsilElement);
        } else if (qname.equals(ReferencedService.QNAME)) {
            extElement = this.parseReferencedService(element, wsilElement);
        } else if (qname.equals(ImplementedBinding.QNAME)) {
            extElement = this.parseImplementedBinding(element, wsilElement);
        } else {
            throw new WSILException("WSIL document contains undefined WSDL extension element: " + element.getTagName() + ".");
        }
        return extElement;
    }

    protected ExtensionElement parseReference(Element referenceElement, WSILElement wsilElement) {
        Element element;
        String endpointPresent;
        ReferenceImpl reference = new ReferenceImpl();
        NamedNodeMap attrList = referenceElement.getAttributes();
        Attr attr = (Attr)attrList.item(0);
        if (attr != null && (endpointPresent = attr.getValue()) != null) {
            reference.setEndpointPresent(Boolean.valueOf(endpointPresent));
        }
        if ((element = XMLUtil.getFirstChild(referenceElement)) == null) {
            return reference;
        }
        QName qname = new QName(element);
        if (qname.equals(ReferencedService.QNAME)) {
            reference.setReferencedService((ReferencedService)this.parseReferencedService(element, wsilElement));
        }
        if (qname.equals(ImplementedBinding.QNAME)) {
            while (element != null) {
                reference.addImplementedBinding((ImplementedBinding)this.parseImplementedBinding(element, reference));
                element = XMLUtil.getNextSibling(element);
            }
        }
        return reference;
    }

    protected ExtensionElement parseImplementedBinding(Element element, WSILElement wsilElement) {
        ImplementedBindingImpl implementedBinding = new ImplementedBindingImpl();
        int index = XMLUtil.getText(element).lastIndexOf(":");
        String localName = XMLUtil.getText(element).substring(index + 1);
        NamedNodeMap attrList = element.getAttributes();
        Attr attr = (Attr)attrList.item(0);
        String namespaceURI = attr.getValue();
        implementedBinding.setBindingName(new QName(namespaceURI, localName));
        return implementedBinding;
    }

    protected ExtensionElement parseReferencedService(Element element, WSILElement wsilElement) {
        ReferencedServiceImpl referencedService = new ReferencedServiceImpl();
        int index = XMLUtil.getText(element).lastIndexOf(":");
        String localName = XMLUtil.getText(element).substring(index + 1);
        NamedNodeMap attrList = element.getAttributes();
        Attr attr = (Attr)attrList.item(0);
        String namespaceURI = attr.getValue();
        referencedService.setReferencedServiceName(new QName(namespaceURI, localName));
        return referencedService;
    }
}

