/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.extensions.core;

import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtchart.extensions.core.MappingsListUI;
import org.eclipse.swtchart.extensions.core.ResourceSupport;
import org.eclipse.swtchart.extensions.internal.support.SeriesMapper;

public class MappingsDialog
extends Dialog {
    private MappingsListUI mappingsListUI;

    public MappingsDialog(Shell shell) {
        super(shell);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Setting Mappings");
    }

    protected boolean isResizable() {
        return true;
    }

    protected Point getInitialSize() {
        return new Point(600, 500);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.mappingsListUI = this.createMappingsList(composite);
        this.updateInput();
        return composite;
    }

    private MappingsListUI createMappingsList(Composite parent) {
        MappingsListUI mappingsListUI = new MappingsListUI(parent, 68354);
        mappingsListUI.getTable().setLayoutData((Object)new GridData(1808));
        return mappingsListUI;
    }

    private void createToolbarMain(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(768);
        gridData.horizontalAlignment = 0x1000008;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.createButtonDelete(composite);
        this.createButtonDeleteAll(composite);
    }

    private Button createButtonDelete(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete selected mapping(s).");
        button.setImage(ResourceSupport.getImage("delete.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (Object object : MappingsDialog.this.mappingsListUI.getStructuredSelection()) {
                    if (!(object instanceof Map.Entry)) continue;
                    Map.Entry entry = (Map.Entry)object;
                    SeriesMapper.remove((String)entry.getKey());
                }
                MappingsDialog.this.updateInput();
            }
        });
        return button;
    }

    private Button createButtonDeleteAll(Composite parent) {
        Button button = new Button(parent, 8);
        button.setText("");
        button.setToolTipText("Delete all mappings.");
        button.setImage(ResourceSupport.getImage("deleteAll.gif"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SeriesMapper.clear();
                MappingsDialog.this.updateInput();
            }
        });
        return button;
    }

    private void updateInput() {
        this.mappingsListUI.setInput(SeriesMapper.getMappings());
    }
}

