/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.apache.solr.cluster.api.SimpleMap;
import org.apache.solr.common.util.WrappedSimpleMap;

public interface ConfigNode {
    public static final ThreadLocal<Function<String, String>> SUBSTITUTES = new ThreadLocal();
    public static final ConfigNode EMPTY = new ConfigNode(){

        @Override
        public String name() {
            return null;
        }

        @Override
        public String txt() {
            return null;
        }

        @Override
        public SimpleMap<String> attributes() {
            return empty_attrs;
        }

        @Override
        public String attr(String name) {
            return null;
        }

        @Override
        public String attr(String name, String def) {
            return def;
        }

        @Override
        public ConfigNode child(String name) {
            return null;
        }

        @Override
        public ConfigNode get(String name) {
            return EMPTY;
        }

        @Override
        public boolean exists() {
            return false;
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public void forEachChild(Function<ConfigNode, Boolean> fun) {
        }
    };
    public static final SimpleMap<String> empty_attrs = new WrappedSimpleMap(Collections.emptyMap());

    public String name();

    public SimpleMap<String> attributes();

    default public ConfigNode child(String name) {
        return this.child(null, name);
    }

    default public ConfigNode get(String name) {
        ConfigNode child = this.child(null, name);
        return child == null ? EMPTY : child;
    }

    default public ConfigNode get(String name, Predicate<ConfigNode> test) {
        List<ConfigNode> children = this.getAll(test, name);
        if (children.isEmpty()) {
            return EMPTY;
        }
        return children.get(0);
    }

    default public ConfigNode get(String name, int idx) {
        List<ConfigNode> children = this.getAll(null, name);
        if (idx < children.size()) {
            return children.get(idx);
        }
        return EMPTY;
    }

    default public ConfigNode child(List<String> path) {
        String s;
        ConfigNode node = this;
        Iterator<String> iterator = path.iterator();
        while (iterator.hasNext() && (node = node.child(s = iterator.next())) != null) {
        }
        return node;
    }

    default public ConfigNode child(String name, Supplier<RuntimeException> err) {
        ConfigNode n = this.child(name);
        if (n == null) {
            throw err.get();
        }
        return n;
    }

    default public boolean boolVal(boolean def) {
        return Helpers._bool(this.txt(), def);
    }

    default public int intVal(int def) {
        return Helpers._int(this.txt(), def);
    }

    default public String attr(String name, String def) {
        return Helpers._txt(this.attributes().get(name), def);
    }

    default public String attr(String name) {
        return this.attributes().get(name);
    }

    default public String requiredStrAttr(String name, Supplier<RuntimeException> err) {
        String attr = this.attr(name);
        if (attr == null && err != null) {
            throw err.get();
        }
        return attr;
    }

    default public int intAttr(String name, int def) {
        return Helpers._int(this.attr(name), def);
    }

    default public boolean boolAttr(String name, boolean def) {
        return Helpers._bool(this.attr(name), def);
    }

    default public String txt(String def) {
        return this.txt() == null ? def : this.txt();
    }

    public String txt();

    default public double doubleVal(double def) {
        return Helpers._double(this.txt(), def);
    }

    default public ConfigNode child(Predicate<ConfigNode> test, String name) {
        ConfigNode[] result = new ConfigNode[1];
        this.forEachChild(it -> {
            if (name != null && !name.equals(it.name())) {
                return Boolean.TRUE;
            }
            if (test == null || test.test((ConfigNode)it)) {
                result[0] = it;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        });
        return result[0];
    }

    default public List<ConfigNode> getAll(Predicate<ConfigNode> test, String ... nodeNames) {
        return this.getAll(test, (Set<String>)(nodeNames == null ? Collections.emptySet() : new HashSet<String>(Arrays.asList(nodeNames))));
    }

    default public List<ConfigNode> getAll(Predicate<ConfigNode> test, Set<String> matchNames) {
        ArrayList<ConfigNode> result = new ArrayList<ConfigNode>();
        this.forEachChild(it -> {
            if (matchNames != null && !matchNames.isEmpty() && !matchNames.contains(it.name())) {
                return Boolean.TRUE;
            }
            if (test == null || test.test((ConfigNode)it)) {
                result.add((ConfigNode)it);
            }
            return Boolean.TRUE;
        });
        return result;
    }

    default public List<ConfigNode> getAll(String name) {
        return this.getAll(null, Collections.singleton(name));
    }

    default public boolean exists() {
        return true;
    }

    default public boolean isNull() {
        return false;
    }

    public void forEachChild(Function<ConfigNode, Boolean> var1);

    public static class Helpers {
        static boolean _bool(Object v, boolean def) {
            return v == null ? def : Boolean.parseBoolean(v.toString());
        }

        static String _txt(Object v, String def) {
            return v == null ? def : v.toString();
        }

        static int _int(Object v, int def) {
            return v == null ? def : Integer.parseInt(v.toString());
        }

        static double _double(Object v, double def) {
            return v == null ? def : Double.parseDouble(v.toString());
        }

        public static Predicate<ConfigNode> at(final int i) {
            return new Predicate<ConfigNode>(){
                int index = 0;

                @Override
                public boolean test(ConfigNode node) {
                    if (this.index == i) {
                        return true;
                    }
                    ++this.index;
                    return false;
                }
            };
        }
    }
}

