/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtility;

public class StringCast
extends CastFunction {
    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 1) {
            throw new ValueExprEvaluationException(this.getXsdName() + " cast requires exactly 1 argument, got " + args.length);
        }
        if (args[0] instanceof Literal) {
            Literal literal = (Literal)args[0];
            CoreDatatype datatype = literal.getCoreDatatype();
            if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                String lexicalValue = XMLDatatypeUtil.collapseWhiteSpace((String)literal.getLabel());
                if (this.isValidForDatatype(lexicalValue)) {
                    return valueFactory.createLiteral(lexicalValue, (CoreDatatype)this.getCoreXsdDatatype());
                }
            } else if (datatype != null && datatype == this.getCoreXsdDatatype()) {
                return literal;
            }
            return this.convert(valueFactory, (Value)literal);
        }
        return this.convert(valueFactory, args[0]);
    }

    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof IRI) {
            return valueFactory.createLiteral(value.toString(), XSD.STRING);
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            CoreDatatype.XSD datatype = literal.getCoreDatatype().asXSDDatatypeOrNull();
            if (QueryEvaluationUtility.isSimpleLiteral(literal)) {
                return valueFactory.createLiteral(literal.getLabel(), (CoreDatatype)CoreDatatype.XSD.STRING);
            }
            if (!Literals.isLanguageLiteral((Literal)literal)) {
                if (datatype != null && datatype.isNumericDatatype() || datatype == CoreDatatype.XSD.BOOLEAN || datatype == CoreDatatype.XSD.DATETIME || datatype == CoreDatatype.XSD.DATETIMESTAMP) {
                    if (XMLDatatypeUtil.isValidValue((String)literal.getLabel(), (CoreDatatype.XSD)datatype)) {
                        String normalizedValue = XMLDatatypeUtil.normalize((String)literal.getLabel(), (CoreDatatype.XSD)datatype);
                        return valueFactory.createLiteral(normalizedValue, (CoreDatatype)CoreDatatype.XSD.STRING);
                    }
                    return valueFactory.createLiteral(literal.getLabel(), (CoreDatatype)CoreDatatype.XSD.STRING);
                }
                return valueFactory.createLiteral(literal.getLabel(), (CoreDatatype)CoreDatatype.XSD.STRING);
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected CoreDatatype.XSD getCoreXsdDatatype() {
        return CoreDatatype.XSD.STRING;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return true;
    }
}

