/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.queryrender.sparql;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.query.algebra.AggregateFunctionCall;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.ArbitraryLengthPath;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.IRIFunction;
import org.eclipse.rdf4j.query.algebra.If;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsNumeric;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.queryrender.BaseTupleExprRenderer;
import org.eclipse.rdf4j.queryrender.RenderUtils;
import org.eclipse.rdf4j.queryrender.sparql.ContextCollector;
import org.eclipse.rdf4j.queryrender.sparql.SparqlValueExprRenderer;

public final class SparqlTupleExprRenderer
extends BaseTupleExprRenderer {
    private StringBuffer mJoinBuffer = new StringBuffer();
    private Map<TupleExpr, Var> mContexts = new HashMap<TupleExpr, Var>();
    private int mIndent = 2;

    @Override
    public void reset() {
        super.reset();
        this.mJoinBuffer = new StringBuffer();
        this.mContexts.clear();
    }

    @Override
    public String render(TupleExpr theExpr) throws Exception {
        this.mContexts = ContextCollector.collectContexts(theExpr);
        theExpr.visit(this);
        return this.mJoinBuffer.toString();
    }

    private String indent() {
        StringBuilder aBuilder = new StringBuilder();
        for (int i = 0; i < this.mIndent; ++i) {
            aBuilder.append(" ");
        }
        return aBuilder.toString();
    }

    @Override
    protected String renderValueExpr(ValueExpr theExpr) throws Exception {
        return new SparqlValueExprRenderer().render(theExpr);
    }

    private void ctxOpen(TupleExpr theExpr) {
        Var aContext = this.mContexts.get(theExpr);
        if (aContext != null) {
            this.mJoinBuffer.append(this.indent()).append("GRAPH ");
            if (aContext.hasValue()) {
                this.mJoinBuffer.append(RenderUtils.toSPARQL(aContext.getValue()));
            } else {
                this.mJoinBuffer.append("?").append(aContext.getName());
            }
            this.mJoinBuffer.append(" {").append(System.lineSeparator());
            this.mIndent += 2;
        }
    }

    private void ctxClose(TupleExpr theExpr) {
        Var aContext = this.mContexts.get(theExpr);
        if (aContext != null) {
            this.mJoinBuffer.append("}");
            this.mIndent -= 2;
        }
    }

    @Override
    public void meet(Join theJoin) throws Exception {
        this.ctxOpen(theJoin);
        theJoin.getLeftArg().visit(this);
        theJoin.getRightArg().visit(this);
        this.ctxClose(theJoin);
    }

    @Override
    public void meet(LeftJoin theJoin) throws Exception {
        boolean aNeedsNewScope;
        this.ctxOpen(theJoin);
        boolean bl = aNeedsNewScope = theJoin.getParentNode() != null && (theJoin.getParentNode() instanceof Join || theJoin.getParentNode() instanceof LeftJoin);
        if (aNeedsNewScope) {
            this.mJoinBuffer.append("{").append(System.lineSeparator());
        }
        theJoin.getLeftArg().visit(this);
        this.mJoinBuffer.append(this.indent()).append("OPTIONAL {").append(System.lineSeparator());
        this.mIndent += 2;
        theJoin.getRightArg().visit(this);
        if (theJoin.getCondition() != null) {
            this.mJoinBuffer.append(this.indent()).append("filter").append(this.renderValueExpr(theJoin.getCondition())).append(System.lineSeparator());
        }
        this.mIndent -= 2;
        this.mJoinBuffer.append(this.indent()).append("}.").append(System.lineSeparator());
        if (aNeedsNewScope) {
            this.mJoinBuffer.append("}.").append(System.lineSeparator());
        }
        this.ctxClose(theJoin);
    }

    private String renderTupleExpr(TupleExpr theExpr) throws Exception {
        SparqlTupleExprRenderer aRenderer = new SparqlTupleExprRenderer();
        aRenderer.mIndent = this.mIndent;
        aRenderer.mContexts = new HashMap<TupleExpr, Var>(this.mContexts);
        return aRenderer.render(theExpr);
    }

    @Override
    public void meet(Union theOp) throws Exception {
        String aRight;
        this.ctxOpen(theOp);
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        if (aLeft.endsWith(System.lineSeparator())) {
            aLeft = aLeft.substring(0, aLeft.length() - 1);
        }
        if ((aRight = this.renderTupleExpr(theOp.getRightArg())).endsWith(System.lineSeparator())) {
            aRight = aRight.substring(0, aRight.length() - 1);
        }
        this.mJoinBuffer.append(this.indent()).append("{").append(System.lineSeparator());
        this.mJoinBuffer.append(aLeft).append(System.lineSeparator());
        this.mJoinBuffer.append(this.indent()).append("}").append(System.lineSeparator());
        this.mJoinBuffer.append(this.indent()).append("union").append(System.lineSeparator());
        this.mJoinBuffer.append(this.indent()).append("{").append(System.lineSeparator());
        this.mJoinBuffer.append(aRight).append(System.lineSeparator());
        this.mJoinBuffer.append(this.indent()).append("}.").append(System.lineSeparator());
        this.ctxClose(theOp);
    }

    @Override
    public void meet(Difference theOp) throws Exception {
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        String aRight = this.renderTupleExpr(theOp.getRightArg());
        this.mJoinBuffer.append(System.lineSeparator());
        this.mJoinBuffer.append("{").append(aLeft).append("}");
        this.mJoinBuffer.append(System.lineSeparator()).append("minus").append(System.lineSeparator());
        this.mJoinBuffer.append("{").append(aRight).append("}.").append(System.lineSeparator());
    }

    @Override
    public void meet(Intersection theOp) throws Exception {
        String aLeft = this.renderTupleExpr(theOp.getLeftArg());
        String aRight = this.renderTupleExpr(theOp.getRightArg());
        this.mJoinBuffer.append(System.lineSeparator());
        this.mJoinBuffer.append(aLeft).append("}").append(System.lineSeparator());
        this.mJoinBuffer.append("intersection").append(System.lineSeparator());
        this.mJoinBuffer.append("{").append(aRight).append("}.").append(System.lineSeparator());
    }

    @Override
    public void meet(Filter theFilter) throws Exception {
        this.ctxOpen(theFilter);
        if (theFilter.getArg() != null) {
            theFilter.getArg().visit(this);
        }
        boolean aNeedsNewScope = theFilter.getParentNode() != null && (theFilter.getParentNode() instanceof Join || theFilter.getParentNode() instanceof LeftJoin);
        Object aFilter = this.renderValueExpr(theFilter.getCondition());
        if (theFilter.getCondition() instanceof ValueConstant || theFilter.getCondition() instanceof Var) {
            aFilter = "(" + (String)aFilter + ")";
        }
        this.mJoinBuffer.append(this.indent());
        this.mJoinBuffer.append("filter ").append((String)aFilter).append(".");
        this.mJoinBuffer.append(System.lineSeparator());
        this.ctxClose(theFilter);
    }

    @Override
    public void meet(StatementPattern thePattern) throws Exception {
        this.ctxOpen(thePattern);
        this.mJoinBuffer.append(this.indent()).append(this.renderPattern(thePattern));
        this.ctxClose(thePattern);
    }

    @Override
    public void meet(Extension node) throws Exception {
        node.visitChildren(this);
    }

    @Override
    public void meet(ExtensionElem node) throws Exception {
        this.mJoinBuffer.append(this.indent()).append("bind(");
        node.visitChildren(this);
        this.mJoinBuffer.append(" as ?").append(node.getName()).append(").").append(System.lineSeparator());
    }

    @Override
    public void meet(FunctionCall node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(AggregateFunctionCall node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(And node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Or node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Compare node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Bound node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(If theOp) throws Exception {
        this.mJoinBuffer.append("if(");
        theOp.getCondition().visit(this);
        this.mJoinBuffer.append(", ");
        theOp.getResult().visit(this);
        this.mJoinBuffer.append(", ");
        theOp.getAlternative().visit(this);
        this.mJoinBuffer.append(")");
    }

    @Override
    public void meet(In node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(SameTerm node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(IsURI node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(IsBNode node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(IsLiteral node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(IsNumeric node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Datatype node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(IRIFunction node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Str node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Regex node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Lang node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(LangMatches node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(ArbitraryLengthPath node) throws Exception {
        if (!(node.getPathExpression() instanceof StatementPattern)) {
            return;
        }
        StatementPattern statement = (StatementPattern)node.getPathExpression();
        String plusSymbol = "";
        if (node.getMinLength() == 1L) {
            plusSymbol = "+";
        }
        this.mJoinBuffer.append(this.renderValueExpr(statement.getSubjectVar())).append(" ");
        this.mJoinBuffer.append(this.renderValueExpr(statement.getPredicateVar())).append(plusSymbol).append(" ");
        this.mJoinBuffer.append(this.renderValueExpr(statement.getObjectVar())).append(".").append(System.lineSeparator());
    }

    @Override
    public void meet(ValueConstant node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    @Override
    public void meet(Var node) throws Exception {
        this.mJoinBuffer.append(this.renderValueExpr(node));
    }

    String renderPattern(StatementPattern thePattern) throws Exception {
        StringBuffer sb = new StringBuffer();
        sb.append(this.renderValueExpr(thePattern.getSubjectVar())).append(" ");
        sb.append(this.renderValueExpr(thePattern.getPredicateVar())).append(" ");
        sb.append(this.renderValueExpr(thePattern.getObjectVar())).append(".").append(System.lineSeparator());
        return sb.toString();
    }
}

