/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable;

import java.io.Serializable;
import java.util.Iterator;
import java.util.Objects;
import org.eclipse.collections.api.BooleanIterable;
import org.eclipse.collections.api.ByteIterable;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.ShortIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.bag.MutableBagIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.map.ImmutableMap;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.multimap.list.ImmutableListMultimap;
import org.eclipse.collections.api.ordered.OrderedIterable;
import org.eclipse.collections.api.partition.stack.PartitionImmutableStack;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.StackIterable;
import org.eclipse.collections.api.stack.primitive.ImmutableBooleanStack;
import org.eclipse.collections.api.stack.primitive.ImmutableByteStack;
import org.eclipse.collections.api.stack.primitive.ImmutableCharStack;
import org.eclipse.collections.api.stack.primitive.ImmutableDoubleStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.api.stack.primitive.ImmutableIntStack;
import org.eclipse.collections.api.stack.primitive.ImmutableLongStack;
import org.eclipse.collections.api.stack.primitive.ImmutableShortStack;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.AbstractRichIterable;
import org.eclipse.collections.impl.block.factory.Comparators;
import org.eclipse.collections.impl.block.factory.Predicates;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Multimaps;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.factory.primitive.BooleanStacks;
import org.eclipse.collections.impl.factory.primitive.ByteStacks;
import org.eclipse.collections.impl.factory.primitive.CharStacks;
import org.eclipse.collections.impl.factory.primitive.DoubleStacks;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.factory.primitive.IntStacks;
import org.eclipse.collections.impl.factory.primitive.LongStacks;
import org.eclipse.collections.impl.factory.primitive.ShortStacks;
import org.eclipse.collections.impl.partition.stack.PartitionArrayStack;
import org.eclipse.collections.impl.stack.immutable.ImmutableStackIterator;
import org.eclipse.collections.impl.stack.immutable.ImmutableStackSerializationProxy;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;

final class ImmutableNotEmptyStack<T>
extends AbstractRichIterable<T>
implements ImmutableStack<T>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final T element;
    private final ImmutableStack<T> next;
    private final int size;

    ImmutableNotEmptyStack(T element, ImmutableStack<T> next) {
        this.element = element;
        this.next = Objects.requireNonNull(next);
        this.size = next.size() + 1;
    }

    public ImmutableStack<T> push(T item) {
        return new ImmutableNotEmptyStack<T>(item, this);
    }

    public ImmutableStack<T> pop() {
        return this.next;
    }

    public ImmutableStack<T> pop(int count) {
        this.checkNegativeCount(count);
        if (this.checkZeroCount(count)) {
            return this;
        }
        this.checkSizeLessThanCount(count);
        ImmutableNotEmptyStack pointer = this;
        for (int i = 0; i < count; ++i) {
            pointer = pointer.pop();
        }
        return pointer;
    }

    public T peek() {
        return this.element;
    }

    public ListIterable<T> peek(int count) {
        this.checkNegativeCount(count);
        if (this.checkZeroCount(count)) {
            return Lists.mutable.empty();
        }
        this.checkSizeLessThanCount(count);
        return this.asLazy().take(count).toList();
    }

    private boolean checkZeroCount(int count) {
        return count == 0;
    }

    private void checkSizeLessThanCount(int count) {
        if (this.size() < count) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + count + " Size = " + this.size());
        }
    }

    private void checkSizeLessThanOrEqualToIndex(int index) {
        if (this.size() <= index) {
            throw new IllegalArgumentException("Count must be less than size: Count = " + index + " Size = " + this.size());
        }
    }

    private void checkNegativeCount(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count must be positive but was " + count);
        }
    }

    public T peekAt(int index) {
        this.checkNegativeCount(index);
        this.checkSizeLessThanOrEqualToIndex(index);
        return (T)this.pop(index).peek();
    }

    public T getFirst() {
        return this.peek();
    }

    public T getLast() {
        throw new UnsupportedOperationException("Cannot call getLast() on " + this.getClass().getSimpleName());
    }

    public MutableStack<T> toStack() {
        return ArrayStack.newStackFromTopToBottom(this);
    }

    public ImmutableStack<T> select(Predicate<? super T> predicate) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().select(predicate).toList());
    }

    public <P> ImmutableStack<T> selectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.select(Predicates.bind(predicate, parameter));
    }

    public ImmutableStack<T> reject(Predicate<? super T> predicate) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().reject(predicate).toList());
    }

    public <P> ImmutableStack<T> rejectWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        return this.reject(Predicates.bind(predicate, parameter));
    }

    public PartitionImmutableStack<T> partition(Predicate<? super T> predicate) {
        PartitionArrayStack partitionMutableStack = new PartitionArrayStack();
        this.asLazy().forEach(new PartitionArrayStack.PartitionProcedure<T>(predicate, partitionMutableStack));
        return partitionMutableStack.toImmutable();
    }

    public <P> PartitionImmutableStack<T> partitionWith(Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionArrayStack partitionMutableStack = new PartitionArrayStack();
        this.asLazy().forEach(new PartitionArrayStack.PartitionPredicate2Procedure<T, P>(predicate, parameter, partitionMutableStack));
        return partitionMutableStack.toImmutable();
    }

    public <S> ImmutableStack<S> selectInstancesOf(Class<S> clazz) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().selectInstancesOf(clazz).toList());
    }

    public <V> ImmutableStack<V> collect(Function<? super T, ? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().collect(function).toList());
    }

    public ImmutableBooleanStack collectBoolean(BooleanFunction<? super T> function) {
        return BooleanStacks.immutable.withAllReversed((BooleanIterable)this.asLazy().collectBoolean(function));
    }

    public ImmutableByteStack collectByte(ByteFunction<? super T> function) {
        return ByteStacks.immutable.withAllReversed((ByteIterable)this.asLazy().collectByte(function));
    }

    public ImmutableCharStack collectChar(CharFunction<? super T> function) {
        return CharStacks.immutable.withAllReversed((CharIterable)this.asLazy().collectChar(function));
    }

    public ImmutableDoubleStack collectDouble(DoubleFunction<? super T> function) {
        return DoubleStacks.immutable.withAllReversed((DoubleIterable)this.asLazy().collectDouble(function));
    }

    public ImmutableFloatStack collectFloat(FloatFunction<? super T> function) {
        return FloatStacks.immutable.withAllReversed((FloatIterable)this.asLazy().collectFloat(function));
    }

    public ImmutableIntStack collectInt(IntFunction<? super T> function) {
        return IntStacks.immutable.withAllReversed((IntIterable)this.asLazy().collectInt(function));
    }

    public ImmutableLongStack collectLong(LongFunction<? super T> function) {
        return LongStacks.immutable.withAllReversed((LongIterable)this.asLazy().collectLong(function));
    }

    public ImmutableShortStack collectShort(ShortFunction<? super T> function) {
        return ShortStacks.immutable.withAllReversed((ShortIterable)this.asLazy().collectShort(function));
    }

    public <P, V> ImmutableStack<V> collectWith(Function2<? super T, ? super P, ? extends V> function, P parameter) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().collectWith(function, parameter).toList());
    }

    public <V> ImmutableStack<V> collectIf(Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().collectIf(predicate, function).toList());
    }

    public <V> ImmutableStack<V> flatCollect(Function<? super T, ? extends Iterable<V>> function) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().flatCollect(function).toList());
    }

    public <V> ImmutableObjectLongMap<V> sumByInt(Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        ObjectLongMap map = this.asLazy().sumByInt(groupBy, function);
        return map.toImmutable();
    }

    public <V> ImmutableObjectDoubleMap<V> sumByFloat(Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        ObjectDoubleMap map = this.asLazy().sumByFloat(groupBy, function);
        return map.toImmutable();
    }

    public <V> ImmutableObjectLongMap<V> sumByLong(Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        ObjectLongMap map = this.asLazy().sumByLong(groupBy, function);
        return map.toImmutable();
    }

    public <V> ImmutableObjectDoubleMap<V> sumByDouble(Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        ObjectDoubleMap map = this.asLazy().sumByDouble(groupBy, function);
        return map.toImmutable();
    }

    public <V> ImmutableListMultimap<V, T> groupBy(Function<? super T, ? extends V> function) {
        return this.groupBy(function, Multimaps.mutable.list.empty()).toImmutable();
    }

    public <V> ImmutableListMultimap<V, T> groupByEach(Function<? super T, ? extends Iterable<V>> function) {
        return this.groupByEach(function, Multimaps.mutable.list.empty()).toImmutable();
    }

    public <V> ImmutableMap<V, T> groupByUniqueKey(Function<? super T, ? extends V> function) {
        return this.groupByUniqueKey(function, Maps.mutable.withInitialCapacity(this.size)).toImmutable();
    }

    public <S> ImmutableStack<Pair<T, S>> zip(Iterable<S> that) {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().zip(that).toList());
    }

    public ImmutableStack<Pair<T, Integer>> zipWithIndex() {
        return Stacks.immutable.withAllReversed((Iterable)this.asLazy().zipWithIndex().toList());
    }

    public ImmutableStack<T> toImmutable() {
        return this;
    }

    public RichIterable<RichIterable<T>> chunk(int size) {
        return this.asLazy().chunk(size);
    }

    public <K, V> ImmutableMap<K, V> aggregateInPlaceBy(Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        MutableMap map = Maps.mutable.empty();
        this.forEach(new MutatingAggregationProcedure<T, K, V>(map, groupBy, zeroValueFactory, mutatingAggregator));
        return map.toImmutable();
    }

    @Override
    public <V> ImmutableBag<V> countByEach(Function<? super T, ? extends Iterable<V>> function) {
        return ((MutableBag)this.countByEach(function, (MutableBagIterable)Bags.mutable.empty())).toImmutable();
    }

    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public ImmutableStack<T> tap(Procedure<? super T> procedure) {
        this.forEach(procedure);
        return this;
    }

    public void each(Procedure<? super T> procedure) {
        ImmutableNotEmptyStack pointer = this;
        while (pointer.notEmpty()) {
            procedure.accept(pointer.peek());
            pointer = pointer.pop();
        }
    }

    public ImmutableStack<T> takeWhile(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".takeWhile() not implemented yet");
    }

    public ImmutableStack<T> dropWhile(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".dropWhile() not implemented yet");
    }

    public PartitionImmutableStack<T> partitionWhile(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".partitionWhile() not implemented yet");
    }

    public ImmutableStack<T> distinct() {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".distinct() not implemented yet");
    }

    public int indexOf(Object object) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".indexOf() not implemented yet");
    }

    public <S> boolean corresponds(OrderedIterable<S> other, Predicate2<? super T, ? super S> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".corresponds() not implemented yet");
    }

    public boolean hasSameElements(OrderedIterable<T> other) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".hasSameElements() not implemented yet");
    }

    public void forEach(int startIndex, int endIndex, Procedure<? super T> procedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEach() not implemented yet");
    }

    public void forEachWithIndex(int fromIndex, int toIndex, ObjectIntProcedure<? super T> objectIntProcedure) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".forEachWithIndex() not implemented yet");
    }

    public int detectIndex(Predicate<? super T> predicate) {
        throw new UnsupportedOperationException(this.getClass().getSimpleName() + ".detectIndex() not implemented yet");
    }

    public Iterator<T> iterator() {
        return new ImmutableStackIterator(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StackIterable)) {
            return false;
        }
        StackIterable that = (StackIterable)o;
        Iterator<T> thisIterator = this.iterator();
        Iterator thatIterator = that.iterator();
        while (thisIterator.hasNext() && thatIterator.hasNext()) {
            if (Comparators.nullSafeEquals(thisIterator.next(), thatIterator.next())) continue;
            return false;
        }
        return !thisIterator.hasNext() && !thatIterator.hasNext();
    }

    public int hashCode() {
        int hashCode = 1;
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T each = iterator.next();
            hashCode = 31 * hashCode + (each == null ? 0 : each.hashCode());
        }
        return hashCode;
    }

    private Object writeReplace() {
        return new ImmutableStackSerializationProxy(this);
    }
}

