/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ssh;

import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.SftpProgressMonitor;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.taskdefs.optional.ssh.Directory;
import org.apache.tools.ant.taskdefs.optional.ssh.ScpToMessage;

public class ScpToMessageBySftp
extends ScpToMessage {
    private static final int HUNDRED_KILOBYTES = 102400;
    private File localFile;
    private final String remotePath;
    private List<Directory> directoryList;
    private final boolean preserveLastModified;

    public ScpToMessageBySftp(boolean verbose, Session session, File aLocalFile, String aRemotePath) {
        this(verbose, session, aLocalFile, aRemotePath, false);
    }

    public ScpToMessageBySftp(boolean verbose, Session session, File aLocalFile, String aRemotePath, boolean preserveLastModified) {
        this(verbose, session, aRemotePath, preserveLastModified);
        this.localFile = aLocalFile;
    }

    public ScpToMessageBySftp(boolean verbose, Session session, List<Directory> aDirectoryList, String aRemotePath) {
        this(verbose, session, aDirectoryList, aRemotePath, false);
    }

    public ScpToMessageBySftp(boolean verbose, Session session, List<Directory> aDirectoryList, String aRemotePath, boolean preserveLastModified) {
        this(verbose, session, aRemotePath, preserveLastModified);
        this.directoryList = aDirectoryList;
    }

    private ScpToMessageBySftp(boolean verbose, Session session, String aRemotePath, boolean preserveLastModified) {
        super(verbose, session);
        this.remotePath = aRemotePath;
        this.preserveLastModified = preserveLastModified;
    }

    public ScpToMessageBySftp(Session session, File aLocalFile, String aRemotePath) {
        this(false, session, aLocalFile, aRemotePath);
    }

    public ScpToMessageBySftp(Session session, List<Directory> aDirectoryList, String aRemotePath) {
        this(false, session, aDirectoryList, aRemotePath);
    }

    @Override
    public void execute() throws IOException, JSchException {
        if (this.directoryList != null) {
            this.doMultipleTransfer();
        }
        if (this.localFile != null) {
            this.doSingleTransfer();
        }
        this.log("done.\n");
    }

    private void doSingleTransfer() throws JSchException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.connect();
            try {
                this.sendFileToRemote(channel, this.localFile, this.remotePath);
            }
            catch (SftpException e) {
                throw new JSchException("Could not send '" + this.localFile + "' to '" + this.remotePath + "' - " + e.toString(), (Throwable)e);
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void doMultipleTransfer() throws IOException, JSchException {
        ChannelSftp channel = this.openSftpChannel();
        try {
            channel.connect();
            try {
                try {
                    channel.stat(this.remotePath);
                }
                catch (SftpException e) {
                    if (e.id != 2) throw new JSchException("failed to access remote dir '" + this.remotePath + "'", (Throwable)e);
                    channel.mkdir(this.remotePath);
                    channel.chmod(this.getDirMode(), this.remotePath);
                }
                channel.cd(this.remotePath);
            }
            catch (SftpException e) {
                throw new JSchException("Could not CD to '" + this.remotePath + "' - " + e.toString(), (Throwable)e);
            }
            for (Directory current : this.directoryList) {
                try {
                    if (this.getVerbose()) {
                        this.log("Sending directory " + current);
                    }
                    this.sendDirectory(channel, current);
                }
                catch (SftpException e) {
                    String msg = "Error sending directory";
                    if (current == null || current.getDirectory() == null) throw new JSchException(msg, (Throwable)e);
                    msg = msg + " '" + current.getDirectory().getName() + "'";
                    throw new JSchException(msg, (Throwable)e);
                    return;
                }
            }
        }
        finally {
            if (channel != null) {
                channel.disconnect();
            }
        }
    }

    private void sendDirectory(ChannelSftp channel, Directory current) throws IOException, SftpException {
        Iterator<File> fileIt = current.filesIterator();
        while (fileIt.hasNext()) {
            this.sendFileToRemote(channel, fileIt.next(), null);
        }
        Iterator<Directory> dirIt = current.directoryIterator();
        while (dirIt.hasNext()) {
            this.sendDirectoryToRemote(channel, dirIt.next());
        }
    }

    private void sendDirectoryToRemote(ChannelSftp channel, Directory directory) throws IOException, SftpException {
        String dir;
        block2: {
            dir = directory.getDirectory().getName();
            try {
                channel.stat(dir);
            }
            catch (SftpException e) {
                if (e.id != 2) break block2;
                channel.mkdir(dir);
                channel.chmod(this.getDirMode(), dir);
            }
        }
        channel.cd(dir);
        this.sendDirectory(channel, directory);
        channel.cd("..");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendFileToRemote(ChannelSftp channel, File localFile, String remotePath) throws SftpException {
        long filesize = localFile.length();
        if (remotePath == null) {
            remotePath = localFile.getName();
        }
        long startTime = System.currentTimeMillis();
        long totalLength = filesize;
        boolean trackProgress = this.getVerbose() && filesize > 102400L;
        SftpProgressMonitor monitor = null;
        if (trackProgress) {
            monitor = this.getProgressMonitor();
        }
        try {
            if (this.getVerbose()) {
                this.log("Sending: " + localFile.getName() + " : " + filesize);
            }
            channel.put(localFile.getAbsolutePath(), remotePath, monitor);
            String transferredFileRemotePath = channel.stat(remotePath).isDir() ? remotePath + "/" + localFile.getName() : remotePath;
            if (this.getVerbose()) {
                this.log("Setting file mode '" + Integer.toOctalString(this.getFileMode()) + "' on remote path " + transferredFileRemotePath);
            }
            channel.chmod(this.getFileMode(), transferredFileRemotePath);
            if (this.getPreserveLastModified()) {
                int lastModifiedTime = (int)(localFile.lastModified() / 1000L);
                if (this.getVerbose()) {
                    this.log("Setting last modified time on remote path " + transferredFileRemotePath + " to " + lastModifiedTime);
                }
                channel.setMtime(transferredFileRemotePath, lastModifiedTime);
            }
        }
        finally {
            if (this.getVerbose()) {
                long endTime = System.currentTimeMillis();
                this.logStats(startTime, endTime, (int)totalLength);
            }
        }
    }

    @Override
    public File getLocalFile() {
        return this.localFile;
    }

    @Override
    public String getRemotePath() {
        return this.remotePath;
    }

    @Override
    public boolean getPreserveLastModified() {
        return this.preserveLastModified;
    }
}

