/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.core.model;

import com.google.common.base.Throwables;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.rcptt.core.model.IOpenable;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7ElementVisitor;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.Q7Status;
import org.eclipse.rcptt.internal.core.model.OpenableElementInfo;
import org.eclipse.rcptt.internal.core.model.Q7Element;
import org.eclipse.rcptt.internal.core.model.Q7Model;

public abstract class Openable
extends Q7Element
implements IOpenable {
    protected Openable(Q7Element parent) throws IllegalArgumentException {
        super(parent);
    }

    @Override
    public boolean exists() {
        try {
            return this.openAndAccessInfo(info -> true, null);
        }
        catch (ModelException e) {
            if (e.getStatus() instanceof Q7Status && ((Q7Status)e.getStatus()).getStatusCode() == Q7Status.Q7StatusCode.NotPressent) {
                return false;
            }
            throw new RuntimeException((Throwable)((Object)e));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return true;
        }
    }

    public IQ7Element[] getChildren() throws ModelException, InterruptedException {
        return this.getChildren(null);
    }

    public IQ7Element[] getChildren(IProgressMonitor monitor) throws ModelException, InterruptedException {
        return this.openAndAccessInfo(info -> info.getChildren(), monitor);
    }

    protected List<IQ7Element> getChildrenOfType(IQ7Element.HandleType type) throws ModelException, InterruptedException {
        return this.getChildrenOfType(type, null);
    }

    protected List<IQ7Element> getChildrenOfType(IQ7Element.HandleType type, IProgressMonitor monitor) throws ModelException, InterruptedException {
        IQ7Element[] children = this.getChildren(monitor);
        int size = children.length;
        ArrayList<IQ7Element> list = new ArrayList<IQ7Element>(size);
        int i = 0;
        while (i < size) {
            IQ7Element elt = children[i];
            if (elt.getElementType().equals((Object)type)) {
                list.add(elt);
            }
            ++i;
        }
        return list;
    }

    public boolean hasChildren() throws ModelException, InterruptedException {
        return this.getChildren().length > 0;
    }

    @Override
    public void accept(IQ7ElementVisitor visitor) throws ModelException, InterruptedException {
        if (visitor.visit(this)) {
            IQ7Element[] elements = this.getChildren();
            int i = 0;
            while (i < elements.length) {
                elements[i].accept(visitor);
                ++i;
            }
            visitor.endVisit(this);
        }
    }

    protected abstract boolean buildStructure(OpenableElementInfo var1, IProgressMonitor var2, IResource var3) throws ModelException;

    protected boolean parentExists() {
        IQ7Element parentElement = this.getParent();
        if (parentElement == null) {
            return true;
        }
        return parentElement.exists();
    }

    protected void generateInfos(OpenableElementInfo info, IProgressMonitor monitor) throws ModelException {
        if (monitor != null && monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
        OpenableElementInfo openableElementInfo = info;
        boolean isStructureKnown = this.buildStructure(openableElementInfo, monitor, this.getResource());
        openableElementInfo.setIsStructureKnown(isStructureKnown);
    }

    public final <V> Optional<V> accessInfoIfOpened(Function<OpenableElementInfo, V> infoToValue) throws InterruptedException {
        return this.peekInfo(info -> {
            OpenableElementInfo openable = (OpenableElementInfo)info;
            if (!openable.isStructureKnown()) {
                return null;
            }
            return infoToValue.apply(openable);
        });
    }

    protected boolean resourceExists() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace == null) {
            return false;
        }
        return Q7Model.getTarget((IContainer)workspace.getRoot(), this.getPath().makeRelative(), true) != null;
    }

    @Override
    public IOpenable getOpenable() {
        return this;
    }

    public final <V> V openAndAccessInfo(ThrowingFunction<OpenableElementInfo, V> infoToValue, IProgressMonitor monitor) throws InterruptedException, ModelException {
        try {
            return (V)this.accessInfo(info -> {
                OpenableElementInfo openable = (OpenableElementInfo)info;
                if (!openable.isStructureKnown()) {
                    try {
                        this.generateInfos(openable, monitor);
                    }
                    catch (ModelException e) {
                        throw new PrivateException((Exception)((Object)e));
                    }
                }
                try {
                    return infoToValue.apply(openable);
                }
                catch (ModelException e) {
                    throw new PrivateException((Exception)((Object)e));
                }
            });
        }
        catch (PrivateException e) {
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), ModelException.class);
            Throwables.throwIfInstanceOf((Throwable)e.getCause(), InterruptedException.class);
            throw new AssertionError((Object)e);
        }
    }

    private static final class PrivateException
    extends RuntimeException {
        private static final long serialVersionUID = -3766482554685794452L;

        public PrivateException(Exception checked) {
            super(checked);
        }
    }

    public static interface ThrowingFunction<T, V> {
        public V apply(T var1) throws ModelException;
    }
}

