/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.egit.core.internal.Utils;
import org.eclipse.egit.core.internal.gerrit.GerritUtil;
import org.eclipse.egit.core.op.EGitGpgConfig;
import org.eclipse.egit.core.util.RevCommitUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.CommitMessageWithCaretPosition;
import org.eclipse.egit.ui.UIUtils;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commit.CommitHelper;
import org.eclipse.egit.ui.internal.credentials.SignatureUtils;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageBuilder;
import org.eclipse.egit.ui.internal.dialogs.CommitMessageComponentState;
import org.eclipse.egit.ui.internal.dialogs.ICommitMessageComponentNotifications;
import org.eclipse.egit.ui.internal.dialogs.SpellcheckableMessageArea;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jgit.lib.CommitConfig;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.GpgConfig;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.jgit.lib.Signer;
import org.eclipse.jgit.lib.Signers;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.util.ChangeIdUtil;
import org.eclipse.jgit.util.RawParseUtils;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class CommitMessageComponent {
    private static final String EMPTY_STRING = "";
    private static final String COMMITTER_VALUES_PREF = "CommitDialog.committerValues";
    private static final String AUTHOR_VALUES_PREF = "CommitDialog.authorValues";
    ICommitMessageComponentNotifications listener;
    SpellcheckableMessageArea commitText;
    Text authorText;
    Text committerText;
    ObjectId originalChangeId;
    private String commitMessage = null;
    private int caretPosition = 0;
    private String commitMessageBeforeAmending = "";
    private int caretPositionBeforeAmending = 0;
    private char commentCharBeforeAmending = (char)35;
    private char autoCommentCharBeforeAmending;
    private String previousCommitMessage = "";
    private int previousCaretPosition = 0;
    private String author = null;
    private String previousAuthor = null;
    private String committer = null;
    private boolean signedOff = false;
    private boolean amending = false;
    private boolean signCommit = false;
    private boolean commitAllowed = true;
    private String cannotCommitMessage = null;
    private boolean amendAllowed = false;
    private boolean amendingCommitInRemoteBranch = false;
    private boolean createChangeId = false;
    private char commentChar = (char)35;
    private char autoCommentChar;
    private UIUtils.IPreviousValueProposalHandler authorHandler;
    private UIUtils.IPreviousValueProposalHandler committerHandler;
    private Repository repository;
    private Collection<String> filesToCommit = new ArrayList<String>();
    private ObjectId headCommitId;
    private boolean listenersEnabled;

    public CommitMessageComponent(Repository repository, ICommitMessageComponentNotifications listener) {
        this.repository = repository;
        this.listener = listener;
    }

    public CommitMessageComponent(ICommitMessageComponentNotifications listener) {
        this.listener = listener;
    }

    public void resetState() {
        this.originalChangeId = null;
        this.commitMessage = null;
        this.caretPosition = 0;
        this.commitMessageBeforeAmending = EMPTY_STRING;
        this.caretPositionBeforeAmending = 0;
        this.previousCommitMessage = EMPTY_STRING;
        this.previousCaretPosition = 0;
        this.author = null;
        this.previousAuthor = null;
        this.committer = null;
        this.signedOff = false;
        this.signCommit = false;
        this.amending = false;
        this.amendAllowed = false;
        this.createChangeId = false;
        this.filesToCommit = new ArrayList<String>();
        this.headCommitId = null;
        this.listenersEnabled = false;
        this.commentChar = (char)35;
        this.autoCommentChar = '\u0000';
        this.commentCharBeforeAmending = (char)35;
        this.autoCommentCharBeforeAmending = '\u0000';
    }

    public String getCommitMessage() {
        this.commitMessage = this.commitText.getCommitMessage();
        return this.commitMessage;
    }

    public void setCommitMessage(String s) {
        this.commitMessage = s;
    }

    public void setCaretPosition(int p) {
        this.caretPosition = p;
    }

    public String getAuthor() {
        this.author = this.authorText.getText().trim();
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author;
    }

    public void setSignedOff(boolean signedOff) {
        this.signedOff = signedOff;
    }

    public void setSignCommit(boolean signCommit) {
        this.signCommit = signCommit;
    }

    public void setCreateChangeId(boolean createChangeId) {
        this.createChangeId = createChangeId;
    }

    public String getCommitter() {
        this.committer = this.committerText.getText().trim();
        return this.committer;
    }

    public void setCommitter(String committer) {
        this.committer = committer;
    }

    public char getCommentChar() {
        return this.commentChar;
    }

    public void setCommentChar(char commentChar) {
        this.commentChar = commentChar;
    }

    public char getAutoCommentChar() {
        return this.autoCommentChar;
    }

    public void setAutoCommentChar(char commentChar) {
        this.autoCommentChar = commentChar;
    }

    public void setFilesToCommit(Collection<String> filesToCommit) {
        this.filesToCommit = filesToCommit;
    }

    public boolean isSignedOff() {
        return this.signedOff;
    }

    public boolean isSignCommit() {
        return this.signCommit;
    }

    public boolean isAmending() {
        return this.amending;
    }

    public void setAmending(boolean amending) {
        this.amending = amending;
    }

    public void setCommitAllowed(boolean commitAllowed) {
        this.commitAllowed = commitAllowed;
    }

    public void setCannotCommitMessage(String cannotCommitMessage) {
        this.cannotCommitMessage = cannotCommitMessage;
    }

    public void setAmendAllowed(boolean amendAllowed) {
        this.amendAllowed = amendAllowed;
        this.commitMessageBeforeAmending = EMPTY_STRING;
        this.caretPositionBeforeAmending = 0;
        this.commentCharBeforeAmending = (char)35;
        this.autoCommentCharBeforeAmending = '\u0000';
    }

    public void setAmendingButtonSelection(boolean selection) {
        this.amending = selection;
        CommitConfig config = (CommitConfig)this.repository.getConfig().get(CommitConfig.KEY);
        if (!selection) {
            this.originalChangeId = null;
            this.authorText.setText(this.author);
            this.commentChar = this.commentCharBeforeAmending;
            this.autoCommentChar = this.autoCommentCharBeforeAmending;
            CommitConfig.CleanupMode mode = config.resolve(CommitConfig.CleanupMode.DEFAULT, true);
            this.commitText.setCleanupMode(mode, this.commentChar);
            this.commitText.setText(this.commitMessageBeforeAmending);
            this.commitText.getTextWidget().setCaretOffset(this.caretPositionBeforeAmending);
            this.commitMessageBeforeAmending = EMPTY_STRING;
            this.caretPositionBeforeAmending = 0;
            this.commentCharBeforeAmending = (char)35;
            this.autoCommentCharBeforeAmending = '\u0000';
        } else {
            this.getHeadCommitInfo();
            this.saveOriginalChangeId();
            this.commitMessageBeforeAmending = this.commitText.getText();
            this.caretPositionBeforeAmending = this.commitText.getTextWidget().getCaretOffset();
            this.commentCharBeforeAmending = this.commentChar;
            this.autoCommentCharBeforeAmending = this.autoCommentChar;
            if (config.isAutoCommentChar()) {
                this.autoCommentChar = this.commentChar = config.getCommentChar(Utils.normalizeLineEndings((String)this.previousCommitMessage));
            } else {
                this.commentChar = config.getCommentChar();
                this.autoCommentChar = '\u0000';
            }
            CommitConfig.CleanupMode mode = config.resolve(CommitConfig.CleanupMode.DEFAULT, true);
            this.commitText.setCleanupMode(mode, this.commentChar);
            this.commitText.setText(this.previousCommitMessage);
            this.commitText.getTextWidget().setCaretOffset(this.previousCaretPosition);
            if (this.previousAuthor != null) {
                this.authorText.setText(this.previousAuthor);
            }
        }
        this.refreshChangeIdText();
    }

    public boolean getCreateChangeId() {
        return this.createChangeId;
    }

    public void updateStateFromUI() {
        this.commitMessage = this.commitText.getText();
        this.caretPosition = this.commitText.getTextWidget().getCaretOffset();
        this.author = this.authorText.getText().trim();
        this.committer = this.committerText.getText().trim();
    }

    public void updateUIFromState() {
        this.updateUIFromState(true);
    }

    public void updateUIFromState(boolean withCommitMessage) {
        if (withCommitMessage) {
            this.commitText.setText(this.commitMessage);
            this.commitText.getTextWidget().setCaretOffset(this.caretPosition);
        }
        this.committerText.setText(this.committer);
        this.authorText.setText(this.author);
    }

    public CommitMessageComponentState getState() {
        this.updateStateFromUI();
        CommitMessageComponentState state = new CommitMessageComponentState();
        state.setAmend(this.isAmending());
        state.setAuthor(this.getAuthor());
        state.setCommitMessage(this.commitText.getText());
        state.setCommitter(this.getCommitter());
        state.setHeadCommit(this.getHeadCommit());
        state.setSign(this.isSignCommit());
        state.setAutoCommentChar(this.getAutoCommentChar());
        return state;
    }

    public void enableListeners(boolean enable) {
        this.listenersEnabled = enable;
        if (enable) {
            this.listener.statusUpdated();
            this.listener.updateSignCommitToggleSelection(this.isSignCommit());
        }
    }

    public CommitStatus getStatus() {
        String message;
        String formatIssue;
        if (!this.commitAllowed) {
            return new CommitStatus(this.cannotCommitMessage, 3);
        }
        String authorValue = this.authorText.getText();
        if (authorValue.length() == 0 || RawParseUtils.parsePersonIdent((String)authorValue) == null) {
            return new CommitStatus(UIText.CommitMessageComponent_MessageInvalidAuthor, 3);
        }
        String committerValue = this.committerText.getText();
        if (committerValue.length() == 0 || RawParseUtils.parsePersonIdent((String)committerValue) == null) {
            return new CommitStatus(UIText.CommitMessageComponent_MessageInvalidCommitter, 3);
        }
        if (this.amending && this.amendingCommitInRemoteBranch) {
            return new CommitStatus(UIText.CommitMessageComponent_AmendingCommitInRemoteBranch, 2);
        }
        if (Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_warn_about_message_second_line") && (formatIssue = CommitMessageComponent.formatIssuesInCommitMessage(message = this.commitText.getCommitMessage())) != null) {
            return new CommitStatus(formatIssue, 2);
        }
        return CommitStatus.OK;
    }

    static String formatIssuesInCommitMessage(String message) {
        Document document = new Document(message);
        int numberOfLines = document.getNumberOfLines();
        if (numberOfLines > 1) {
            try {
                IRegion lineInfo = document.getLineInformation(1);
                if (lineInfo.getLength() > 0) {
                    return UIText.CommitMessageComponent_MessageSecondLineNotEmpty;
                }
            }
            catch (BadLocationException e) {
                Activator.logError(e.getMessage(), e);
            }
        }
        return null;
    }

    public boolean checkCommitInfo() {
        EGitGpgConfig gpgConfig;
        Signer signer;
        boolean signingKeyAvailable;
        PersonIdent ident;
        this.updateStateFromUI();
        String rawText = Utils.normalizeLineEndings((String)this.commitText.getText());
        int rawFooterOffset = CommonUtils.getFooterOffset(rawText);
        String firstFooterLine = null;
        if (rawFooterOffset > 0) {
            int rawFooterLineEnd = rawText.indexOf(10, rawFooterOffset + 1);
            if (rawFooterLineEnd < 0) {
                rawFooterLineEnd = rawText.length();
            }
            if (rawText.startsWith(firstFooterLine = rawText.substring(rawFooterOffset, rawFooterLineEnd).stripTrailing())) {
                firstFooterLine = null;
            } else {
                String firstLine;
                int firstLineEnd = rawText.indexOf(10);
                if (firstLineEnd > 0 && !(firstLine = rawText.substring(0, firstLineEnd).stripTrailing()).isEmpty() && firstFooterLine.startsWith(firstLine)) {
                    firstFooterLine = null;
                }
            }
        }
        String text = this.getCommitMessage();
        boolean isEmpty = false;
        int footer = CommonUtils.getFooterOffset(text);
        if (firstFooterLine != null && footer < 0) {
            int firstLineEnd = text.indexOf(10);
            if (firstLineEnd < 0) {
                firstLineEnd = text.length();
            }
            if (firstLineEnd <= firstFooterLine.length()) {
                isEmpty = firstFooterLine.startsWith(text.substring(0, firstLineEnd));
            }
        } else {
            if (footer >= 0) {
                text = text.substring(0, footer);
            }
            isEmpty = text.isBlank();
        }
        if (isEmpty) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorNoMessage, (String)UIText.CommitDialog_ErrorMustEnterCommitMessage);
            return false;
        }
        PersonIdent personIdent = ident = this.author.isBlank() ? null : RawParseUtils.parsePersonIdent((String)this.author);
        if (ident == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidAuthorSpecified);
            return false;
        }
        PersonIdent personIdent2 = ident = this.committer.isBlank() ? null : RawParseUtils.parsePersonIdent((String)this.committer);
        if (ident == null) {
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitDialog_ErrorInvalidAuthor, (String)UIText.CommitDialog_ErrorInvalidCommitterSpecified);
            return false;
        }
        Repository repo = this.repository;
        if (this.signCommit && repo != null && !(signingKeyAvailable = SignatureUtils.checkSigningKey(repo, signer = Signers.get((GpgConfig.GpgFormat)(gpgConfig = new EGitGpgConfig((Config)repo.getConfig())).getKeyFormat()), (GpgConfig)gpgConfig, ident))) {
            String signingKey = gpgConfig.getSigningKey();
            if (StringUtils.isEmptyOrNull((String)signingKey)) {
                signingKey = ident.getEmailAddress();
            }
            MessageDialog.openWarning((Shell)this.getShell(), (String)UIText.CommitMessageComponent_ErrorMissingSigningKey, (String)MessageFormat.format(UIText.CommitMessageComponent_ErrorNoSigningKeyFound, signingKey));
            return false;
        }
        this.authorHandler.updateProposals();
        this.committerHandler.updateProposals();
        return true;
    }

    public void attachControls(SpellcheckableMessageArea commitText, Text authorText, Text committerText) {
        this.commitText = commitText;
        this.authorText = authorText;
        this.committerText = committerText;
        this.addListeners();
    }

    private void addListeners() {
        this.authorHandler = UIUtils.addPreviousValuesContentProposalToText(this.authorText, AUTHOR_VALUES_PREF);
        this.authorText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!CommitMessageComponent.this.listenersEnabled || !CommitMessageComponent.this.authorText.isEnabled()) {
                    return;
                }
                CommitMessageComponent.this.listener.statusUpdated();
            }
        });
        this.committerText.addModifyListener(new ModifyListener(){
            String oldCommitter;
            {
                this.oldCommitter = CommitMessageComponent.this.committerText.getText().trim();
            }

            public void modifyText(ModifyEvent e) {
                String newCommitter = CommitMessageComponent.this.committerText.getText().trim();
                if (!CommitMessageComponent.this.listenersEnabled || !CommitMessageComponent.this.committerText.isEnabled()) {
                    if (!this.oldCommitter.equals(newCommitter) && RawParseUtils.parsePersonIdent((String)newCommitter) != null) {
                        this.oldCommitter = newCommitter;
                    }
                    return;
                }
                if (!this.oldCommitter.equals(newCommitter) && RawParseUtils.parsePersonIdent((String)newCommitter) != null) {
                    String oldCommitText;
                    String newCommitText = oldCommitText = CommitMessageComponent.this.commitText.getText();
                    String currentAuthor = CommitMessageComponent.this.authorText.getText().trim();
                    if (newCommitter.equals(currentAuthor)) {
                        String signOff;
                        if (CommitMessageComponent.this.signedOff && !CommitMessageComponent.this.hasSignOff(oldCommitText, signOff = CommitMessageComponent.this.getSignedOff(newCommitter))) {
                            newCommitText = CommitMessageComponent.this.signOff(oldCommitText);
                        }
                    } else {
                        String oldSignOff = CommitMessageComponent.this.getSignedOff(this.oldCommitter);
                        String newSignOff = CommitMessageComponent.this.getSignedOff(newCommitter);
                        newCommitText = CommitMessageComponent.this.replaceSignOff(oldCommitText, oldSignOff, newSignOff);
                    }
                    if (!oldCommitText.equals(newCommitText)) {
                        CommitMessageComponent.this.commitText.setText(newCommitText);
                    }
                    this.oldCommitter = newCommitter;
                }
                CommitMessageComponent.this.listener.statusUpdated();
            }
        });
        this.committerHandler = UIUtils.addPreviousValuesContentProposalToText(this.committerText, COMMITTER_VALUES_PREF);
        this.commitText.getDocument().addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent event) {
                if (!CommitMessageComponent.this.listenersEnabled || !CommitMessageComponent.this.commitText.isEnabled()) {
                    return;
                }
                CommitMessageComponent.this.updateSignedOffButton();
                CommitMessageComponent.this.updateChangeIdButton();
                CommitMessageComponent.this.listener.statusUpdated();
            }

            public void documentAboutToBeChanged(DocumentEvent event) {
            }
        });
    }

    public void setDefaults() {
        if (this.repository != null) {
            this.createChangeId = GerritUtil.getCreateChangeId((Config)this.repository.getConfig());
            this.signCommit = new GpgConfig((Config)this.repository.getConfig()).isSignCommits();
        }
        this.signedOff = Activator.getDefault().getPreferenceStore().getBoolean("commit_dialog_signed_off_by");
    }

    public void updateUI() {
        if (this.amending) {
            this.getHeadCommitInfo();
        }
        CommitMessageWithCaretPosition commitMessageWithCaretPosition = new CommitMessageBuilder(this.repository, this.filesToCommit).build();
        String calculatedCommitMessage = this.calculateCommitMessage(commitMessageWithCaretPosition);
        int calculatedCaretPosition = this.calculateCaretPosition(commitMessageWithCaretPosition);
        boolean calculatedMessageHasChangeId = this.findOffsetOfChangeIdLine(calculatedCommitMessage) > 0;
        this.commitText.setText(calculatedCommitMessage);
        this.authorText.setText(this.getSafeString(this.author));
        this.committerText.setText(this.getSafeString(this.committer));
        if (this.amending) {
            this.authorText.setText(this.previousAuthor);
            this.saveOriginalChangeId();
        } else {
            if (!this.amendAllowed) {
                this.originalChangeId = null;
            }
            this.refreshSignedOffBy();
            if (!calculatedMessageHasChangeId) {
                this.refreshChangeIdText();
            }
        }
        this.updateSignedOffButton();
        this.updateChangeIdButton();
        this.commitText.getTextWidget().setCaretOffset(calculatedCaretPosition);
    }

    public void updateSignedOffAndChangeIdButton() {
        this.updateSignedOffButton();
        this.updateChangeIdButton();
    }

    private void getHeadCommitInfo() {
        CommitHelper.CommitInfo headCommitInfo = CommitHelper.getHeadCommitInfo(this.repository);
        if (headCommitInfo == null) {
            return;
        }
        RevCommit previousCommit = headCommitInfo.getCommit();
        this.amendingCommitInRemoteBranch = this.isContainedInAnyRemoteBranch(previousCommit);
        this.previousCommitMessage = headCommitInfo.getCommitMessage();
        this.previousAuthor = headCommitInfo.getAuthor();
    }

    private boolean isContainedInAnyRemoteBranch(RevCommit commit) {
        try {
            List refs = this.repository.getRefDatabase().getRefsByPrefix("refs/remotes/");
            return RevCommitUtils.isContainedInAnyRef((Repository)this.repository, (ObjectId)commit, (Collection)refs);
        }
        catch (IOException e) {
            return false;
        }
    }

    private String getSafeString(String string) {
        if (string == null) {
            return EMPTY_STRING;
        }
        return string;
    }

    private Shell getShell() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
    }

    String calculateCommitMessage(CommitMessageWithCaretPosition messageWithCaretPosition) {
        if (this.commitMessage != null) {
            return this.commitMessage;
        }
        if (this.amending) {
            return this.previousCommitMessage;
        }
        return messageWithCaretPosition.getMessage();
    }

    private int calculateCaretPosition(CommitMessageWithCaretPosition messageWithCaretPosition) {
        if (this.commitMessage != null) {
            return this.caretPosition;
        }
        if (this.amending) {
            return this.previousCaretPosition;
        }
        return messageWithCaretPosition.getDesiredCaretPosition();
    }

    private void saveOriginalChangeId() {
        int changeIdOffset = this.findOffsetOfChangeIdLine(this.previousCommitMessage);
        if (changeIdOffset > 0) {
            int endOfChangeId = this.findNextEOL(changeIdOffset, this.previousCommitMessage);
            if (endOfChangeId < 0) {
                endOfChangeId = this.previousCommitMessage.length();
            }
            int sha1Offset = changeIdOffset + "Change-Id: I".length();
            try {
                this.originalChangeId = ObjectId.fromString((String)this.previousCommitMessage.substring(sha1Offset, endOfChangeId));
            }
            catch (IllegalArgumentException e) {
                this.originalChangeId = null;
            }
        } else {
            this.originalChangeId = null;
        }
    }

    private int findNextEOL(int oldPos, String message) {
        return message.indexOf(Text.DELIMITER, oldPos + 1);
    }

    private int findOffsetOfChangeIdLine(String message) {
        return ChangeIdUtil.indexOfChangeId((String)message, (String)Text.DELIMITER);
    }

    private void updateChangeIdButton() {
        Object curText = this.commitText.getText();
        if (!((String)curText).endsWith(Text.DELIMITER)) {
            curText = (String)curText + Text.DELIMITER;
        }
        this.createChangeId = ((String)curText).indexOf(Text.DELIMITER + "Change-Id: ") != -1;
        this.listener.updateChangeIdToggleSelection(this.createChangeId);
    }

    private void refreshChangeIdText() {
        if (this.createChangeId) {
            String changedText;
            String text = this.commitText.getText().replaceAll(Text.DELIMITER, "\n");
            if (!text.equals(changedText = ChangeIdUtil.insertId((String)text, (ObjectId)(this.originalChangeId != null ? this.originalChangeId : ObjectId.zeroId()), (this.repository.getRepositoryState() != RepositoryState.CHERRY_PICKING_RESOLVED ? 1 : 0) != 0))) {
                changedText = changedText.replaceAll("\n", Text.DELIMITER);
                this.commitText.setText(changedText);
            }
        } else {
            String text = this.commitText.getText();
            int changeIdOffset = this.findOffsetOfChangeIdLine(text);
            if (changeIdOffset > 0) {
                int endOfChangeId = this.findNextEOL(changeIdOffset, text);
                Object cleanedText = endOfChangeId == -1 ? text.substring(0, changeIdOffset) : text.substring(0, changeIdOffset) + text.substring(endOfChangeId + Text.DELIMITER.length());
                this.commitText.setText((String)cleanedText);
            }
        }
    }

    private String getSignedOff() {
        return this.getSignedOff(this.committerText.getText().trim());
    }

    private String getSignedOff(String signer) {
        return "Signed-off-by: " + signer;
    }

    private String signOff(String input) {
        String lastLine;
        Object output = input;
        if (!((String)output).endsWith(Text.DELIMITER)) {
            output = (String)output + Text.DELIMITER;
        }
        if (!(lastLine = this.getLastLine((String)output)).isEmpty() && !lastLine.matches("[A-Za-z\\-]+:.*")) {
            output = (String)output + Text.DELIMITER;
        }
        output = (String)output + this.getSignedOff();
        return output;
    }

    private String getLastLine(String input) {
        String output = input;
        int breakLength = Text.DELIMITER.length();
        int lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER);
        if (lastIndexOfLineBreak != -1 && lastIndexOfLineBreak == output.length() - breakLength) {
            output = output.substring(0, output.length() - breakLength);
        }
        return (lastIndexOfLineBreak = output.lastIndexOf(Text.DELIMITER)) == -1 ? output : output.substring(lastIndexOfLineBreak + breakLength, output.length());
    }

    private void updateSignedOffButton() {
        Object curText = this.commitText.getText();
        if (!((String)curText).endsWith(Text.DELIMITER)) {
            curText = (String)curText + Text.DELIMITER;
        }
        if (RawParseUtils.parsePersonIdent((String)this.committerText.getText().trim()) != null) {
            this.signedOff = ((String)curText).indexOf(this.getSignedOff() + Text.DELIMITER) != -1;
            this.listener.updateSignedOffToggleSelection(this.signedOff);
        }
    }

    private void refreshSignedOffBy() {
        String curText = this.commitText.getText();
        if (this.signedOff) {
            this.commitText.setText(this.signOff(curText));
        } else {
            String s = this.getSignedOff();
            if (s != null) {
                if ((curText = this.replaceSignOff(curText, s, EMPTY_STRING)).endsWith(Text.DELIMITER + Text.DELIMITER)) {
                    curText = curText.substring(0, curText.length() - Text.DELIMITER.length());
                }
                this.commitText.setText(curText);
            }
        }
    }

    private boolean hasSignOff(String input, String signature) {
        Object curText = input;
        if (!((String)curText).endsWith(Text.DELIMITER)) {
            curText = (String)curText + Text.DELIMITER;
        }
        return ((String)curText).indexOf(signature + Text.DELIMITER) >= 0;
    }

    private String replaceSignOff(String input, String oldSignOff, String newSignOff) {
        int indexOfSignOff;
        assert (input != null);
        assert (oldSignOff != null);
        assert (newSignOff != null);
        Object curText = input;
        if (!((String)curText).endsWith(Text.DELIMITER)) {
            curText = (String)curText + Text.DELIMITER;
        }
        if ((indexOfSignOff = ((String)curText).indexOf(oldSignOff + Text.DELIMITER)) == -1) {
            return input;
        }
        return input.substring(0, indexOfSignOff) + newSignOff + input.substring(indexOfSignOff + oldSignOff.length(), input.length());
    }

    public void setSignedOffButtonSelection(boolean signedOffButtonSelection) {
        this.signedOff = signedOffButtonSelection;
        this.refreshSignedOffBy();
    }

    public void setSignCommitButtonSelection(boolean signCommitButtonSelection) {
        this.signCommit = signCommitButtonSelection;
    }

    public void setChangeIdButtonSelection(boolean selection) {
        this.createChangeId = selection;
        this.refreshChangeIdText();
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setHeadCommit(ObjectId id) {
        this.headCommitId = id;
    }

    public ObjectId getHeadCommit() {
        return this.headCommitId;
    }

    public static class CommitStatus
    implements IMessageProvider {
        private static final CommitStatus OK = new CommitStatus();
        private final String message;
        private final int type;

        private CommitStatus() {
            this.message = null;
            this.type = 0;
        }

        private CommitStatus(String message, int type) {
            this.message = message;
            this.type = type;
        }

        public String getMessage() {
            return this.message;
        }

        public int getMessageType() {
            return this.type;
        }
    }
}

