/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.core.util;

import java.io.IOException;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IStatus;

public final class Statuses {
    private Statuses() {
    }

    public static void visit(IStatus status, Visitor visitor) {
        if (status == null) {
            return;
        }
        if (visitor.visit(status) && status.isMultiStatus()) {
            IStatus[] iStatusArray = status.getChildren();
            int n = iStatusArray.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus child = iStatusArray[n2];
                Statuses.visit(child, visitor);
                ++n2;
            }
        }
    }

    public static boolean hasCode(IStatus status, final int code) {
        final boolean[] rv = new boolean[1];
        Statuses.visit(status, new Visitor(){

            @Override
            public boolean visit(IStatus status) {
                if (status.getCode() == code) {
                    rv[0] = true;
                }
                return !rv[0];
            }
        });
        return rv[0];
    }

    public static String format(IStatus status) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (StringWriter string = new StringWriter();){
                Statuses.print("", status, string);
                string.flush();
                return string.toString();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new AssertionError("Impossible error, no IO is done", e);
        }
    }

    public static void print(String indent, IStatus status, Appendable output) throws IOException {
        output.append(indent).append(Statuses.severityString(status));
        String message = status.getMessage();
        String childIndent = indent + "  ";
        if (message != null && !message.isEmpty()) {
            output.append(": ");
            output.append(Arrays.stream(message.split("\n")).collect(Collectors.joining("\n")));
            output.append("\n");
        }
        IStatus[] iStatusArray = status.getChildren();
        int n = iStatusArray.length;
        int n2 = 0;
        while (n2 < n) {
            IStatus child = iStatusArray[n2];
            Statuses.print(childIndent, child, output);
            ++n2;
        }
    }

    private static String severityString(IStatus status) {
        if (status.matches(8)) {
            return "CANCEL";
        }
        if (status.matches(4)) {
            return "ERROR";
        }
        if (status.matches(2)) {
            return "WARNING";
        }
        if (status.matches(1)) {
            return "INFO";
        }
        return "OK";
    }

    public static interface Visitor {
        public boolean visit(IStatus var1);
    }
}

