/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ITheme;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.egit.ui";
    private static Activator plugin;
    private static List<IPropertyChangeListener> propertyChangeListeners;
    public static final String DECORATORS_CHANGED = "org.eclipse.egit.ui.DECORATORS_CHANGED";
    private ResourceManager resourceManager;

    static {
        propertyChangeListeners = new ArrayList<IPropertyChangeListener>(5);
    }

    public static Activator getDefault() {
        return plugin;
    }

    private static IStatus toStatus(int severity, String message, Throwable throwable) {
        Throwable exc = throwable;
        while (exc instanceof InvocationTargetException) {
            Throwable cause;
            String msg = exc.getLocalizedMessage();
            if (msg != null && !msg.isEmpty() || (cause = exc.getCause()) == null) break;
            exc = cause;
        }
        if (exc != null && (message == null || message.isEmpty())) {
            message = exc.getLocalizedMessage();
        }
        return new Status(severity, PLUGIN_ID, message, exc);
    }

    public static void handleError(String message, Throwable throwable, boolean show) {
        Activator.handleIssue(4, message, throwable, show);
    }

    public static void handleIssue(int severity, String message, Throwable throwable, boolean show) {
        IStatus status = Activator.toStatus(severity, message, throwable);
        Activator.handleStatus(status, show);
    }

    public static void handleStatus(IStatus status, boolean show) {
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle(status, style);
    }

    public static void showError(String message, Throwable throwable) {
        IStatus status = Activator.toStatus(4, message, throwable);
        StatusManager.getManager().handle(status, 2);
    }

    public static void showErrorStatus(String message, IStatus status) {
        StatusManager.getManager().handle(status, 2);
    }

    public static void logError(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static void logWarning(String message, Throwable thr) {
        Activator.handleIssue(2, message, thr, false);
    }

    public static void error(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return Activator.toStatus(4, message, throwable);
    }

    public static IStatus createErrorStatus(String message) {
        return Activator.toStatus(4, message, null);
    }

    public static ITheme getTheme() {
        return PlatformUI.getWorkbench().getThemeManager().getCurrentTheme();
    }

    public static Font getFont(String id) {
        return Activator.getTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return Activator.getTheme().getFontRegistry().getBold(id);
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public static synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static synchronized void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(BundleContext context) throws Exception {
        Activator activator = this;
        synchronized (activator) {
            if (this.resourceManager != null) {
                this.resourceManager.dispose();
                this.resourceManager = null;
            }
        }
        super.stop(context);
        Activator.setActivator(null);
    }

    public synchronized ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display == null) {
                throw new IllegalStateException();
            }
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        }
        return this.resourceManager;
    }

    public static final boolean hasJavaPlugin() {
        return Platform.getBundle((String)"org.eclipse.jdt.ui") != null;
    }
}

