/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;

public abstract class DocValuesSkipper {
    public abstract void advance(int var1) throws IOException;

    public abstract int numLevels();

    public abstract int minDocID(int var1);

    public abstract int maxDocID(int var1);

    public abstract long minValue(int var1);

    public abstract long maxValue(int var1);

    public abstract int docCount(int var1);

    public abstract long minValue();

    public abstract long maxValue();

    public abstract int docCount();

    public final void advance(long minValue, long maxValue) throws IOException {
        if (this.minDocID(0) == -1) {
            this.advance(0);
        }
        while (this.minDocID(0) != Integer.MAX_VALUE && (this.minValue(0) > maxValue || this.maxValue(0) < minValue)) {
            int maxDocID = this.maxDocID(0);
            for (int nextLevel = 1; nextLevel < this.numLevels() && (this.minValue(nextLevel) > maxValue || this.maxValue(nextLevel) < minValue); ++nextLevel) {
                maxDocID = this.maxDocID(nextLevel);
            }
            this.advance(maxDocID + 1);
        }
    }
}

