/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.maven.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.SegmentSequence;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.oomph.base.impl.ModelElementImpl;
import org.eclipse.oomph.maven.DOMElement;
import org.eclipse.oomph.maven.MavenPackage;
import org.eclipse.oomph.maven.PropertyReference;
import org.eclipse.oomph.maven.impl.ProjectImpl;
import org.eclipse.oomph.maven.util.MavenValidator;
import org.eclipse.oomph.maven.util.POMXMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class DOMElementImpl
extends ModelElementImpl
implements DOMElement {
    protected static final Element ELEMENT_EDEFAULT = null;
    protected Element element = ELEMENT_EDEFAULT;
    protected EList<PropertyReference> propertyReferences;

    protected DOMElementImpl() {
    }

    protected EClass eStaticClass() {
        return MavenPackage.Literals.DOM_ELEMENT;
    }

    @Override
    public Element getElement() {
        return this.element;
    }

    @Override
    public void setElement(Element newElement) {
        Element oldElement = this.element;
        this.element = newElement;
        if (this.eNotificationRequired()) {
            this.eNotify((Notification)new ENotificationImpl((InternalEObject)this, 1, 1, (Object)oldElement, (Object)this.element));
        }
    }

    @Override
    public EList<PropertyReference> getPropertyReferences() {
        if (this.propertyReferences == null) {
            this.propertyReferences = new EObjectContainmentEList(PropertyReference.class, (InternalEObject)this, 2);
        }
        return this.propertyReferences;
    }

    @Override
    public Element getElement(SegmentSequence xpath) {
        return POMXMLUtil.getElement(this.getElement(), xpath);
    }

    @Override
    public Map<Document, Map<POMXMLUtil.TextRegion, MavenValidator.ElementEdit>> getElementEdits() {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate((EObject)this);
        LinkedHashMap<Document, Map<POMXMLUtil.TextRegion, MavenValidator.ElementEdit>> result = new LinkedHashMap<Document, Map<POMXMLUtil.TextRegion, MavenValidator.ElementEdit>>();
        for (Diagnostic child : diagnostic.getChildren()) {
            Element element;
            POMXMLUtil.TextRegion selection;
            MavenValidator.ElementEdit elementEdit = MavenValidator.ElementEdit.of(child);
            if (elementEdit == null || (selection = POMXMLUtil.getSelection(element = elementEdit.element())) == null) continue;
            Map edits = result.computeIfAbsent(element.getOwnerDocument(), key -> new TreeMap());
            edits.put(selection, elementEdit);
        }
        return result;
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs) {
        switch (featureID) {
            case 2: {
                return ((InternalEList)this.getPropertyReferences()).basicRemove((Object)otherEnd, msgs);
            }
        }
        return super.eInverseRemove(otherEnd, featureID, msgs);
    }

    public Object eGet(int featureID, boolean resolve, boolean coreType) {
        switch (featureID) {
            case 1: {
                return this.getElement();
            }
            case 2: {
                return this.getPropertyReferences();
            }
        }
        return super.eGet(featureID, resolve, coreType);
    }

    public void eSet(int featureID, Object newValue) {
        switch (featureID) {
            case 1: {
                this.setElement((Element)newValue);
                return;
            }
            case 2: {
                this.getPropertyReferences().clear();
                this.getPropertyReferences().addAll((Collection)newValue);
                return;
            }
        }
        super.eSet(featureID, newValue);
    }

    public void eUnset(int featureID) {
        switch (featureID) {
            case 1: {
                this.setElement(ELEMENT_EDEFAULT);
                return;
            }
            case 2: {
                this.getPropertyReferences().clear();
                return;
            }
        }
        super.eUnset(featureID);
    }

    public boolean eIsSet(int featureID) {
        switch (featureID) {
            case 1: {
                return ELEMENT_EDEFAULT == null ? this.element != null : !ELEMENT_EDEFAULT.equals(this.element);
            }
            case 2: {
                return this.propertyReferences != null && !this.propertyReferences.isEmpty();
            }
        }
        return super.eIsSet(featureID);
    }

    public Object eInvoke(int operationID, EList<?> arguments) throws InvocationTargetException {
        switch (operationID) {
            case 1: {
                return this.getElement((SegmentSequence)arguments.get(0));
            }
            case 2: {
                return this.getElementEdits();
            }
        }
        return super.eInvoke(operationID, arguments);
    }

    public String toString() {
        if (this.eIsProxy()) {
            return super.toString();
        }
        StringBuilder result = new StringBuilder(super.toString());
        result.append(" (element: ");
        result.append(this.element);
        result.append(')');
        return result.toString();
    }

    protected String getElementText(SegmentSequence xpath) {
        Element element = this.getElement(xpath);
        return element == null ? "" : element.getTextContent().strip();
    }

    protected Element getElementWithParent(String elementName) {
        Element element = this.getElement(POMXMLUtil.xpath(elementName));
        if (element == null) {
            element = this.getElement(POMXMLUtil.xpath("parent", elementName));
        }
        return element;
    }

    protected String getElementTextWithParent(String elementName) {
        Element element = this.getElementWithParent(elementName);
        return element == null ? "" : element.getTextContent().strip();
    }

    protected String expandProperties(Element hostElement, String value) {
        DOMElementImpl eObject = this;
        while (eObject != null) {
            if (eObject instanceof ProjectImpl) {
                ProjectImpl project = (ProjectImpl)eObject;
                return project.expandProperties(this, hostElement, value);
            }
            eObject = eObject.eContainer();
        }
        return value;
    }
}

