/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmFeature;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.util.Wrapper;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.typesystem.computation.IFeatureLinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ILinkingCandidate;
import org.eclipse.xtext.xbase.typesystem.computation.ITypeComputationState;
import org.eclipse.xtext.xbase.typesystem.computation.SynonymTypesProvider;
import org.eclipse.xtext.xbase.typesystem.conformance.ConformanceHint;
import org.eclipse.xtext.xbase.typesystem.conformance.TypeConformanceComputationArgument;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractResolvedReference;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.ExpressionTypeComputationState;
import org.eclipse.xtext.xbase.typesystem.internal.FeatureLinkHelper;
import org.eclipse.xtext.xbase.typesystem.internal.ResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.TypeExpectation;
import org.eclipse.xtext.xbase.typesystem.references.LightweightMergedBoundTypeArgument;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.ParameterizedTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.WildcardTypeReference;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;
import org.eclipse.xtext.xbase.typesystem.util.DeclaratorTypeArgumentCollector;
import org.eclipse.xtext.xbase.typesystem.util.DeferredTypeParameterHintCollector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NonNullByDefault
public class ResolvedFeature
extends AbstractResolvedReference<XAbstractFeatureCall>
implements IFeatureLinkingCandidate {
    private FeatureLinkHelper helper;

    public ResolvedFeature(XAbstractFeatureCall featureCall, JvmIdentifiableElement feature, FeatureLinkHelper helper, ExpressionTypeComputationState state) {
        super(featureCall, feature, state);
        this.helper = helper;
    }

    @Override
    public ILinkingCandidate getPreferredCandidate(ILinkingCandidate other) {
        return this;
    }

    @Override
    @Nullable
    protected LightweightTypeReference getSubstitutedExpectedType(int idx) {
        if (idx == 0 && this.getReceiver() != null) {
            return this.getReceiverType();
        }
        return super.getSubstitutedExpectedType(idx);
    }

    @Override
    public void applyToComputationState() {
        XExpression actualReceiver;
        LightweightTypeReference receiverType;
        XExpression receiver = this.getImplicitReceiver();
        if (receiver != null) {
            ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
            receiverType = this.getImplicitReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine type of receiver " + receiver);
            }
            TypeExpectation expectation = new TypeExpectation(null, this.getState(), false);
            resolvedTypes.acceptType(receiver, expectation, receiverType.copyInto(resolvedTypes.getReferenceOwner()), false, ConformanceHint.UNCHECKED);
        }
        if ((actualReceiver = this.getReceiver()) != null) {
            receiverType = this.getReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine receiver's type");
            }
            JvmIdentifiableElement feature = this.getFeature();
            if (feature instanceof JvmFeature) {
                TypeConformanceComputationArgument rawConformanceCheck;
                JvmDeclaredType declaringType = ((JvmFeature)feature).getDeclaringType();
                final ParameterizedTypeReference declaringTypeReference = new ParameterizedTypeReference(receiverType.getOwner(), (JvmType)declaringType);
                if (!declaringTypeReference.isAssignableFrom(receiverType, rawConformanceCheck = new TypeConformanceComputationArgument(true, false, false, false, false, false))) {
                    final Wrapper expectedReceiverTypeWrapper = Wrapper.wrap(null);
                    CommonTypeComputationServices services = receiverType.getOwner().getServices();
                    SynonymTypesProvider synonymProvider = services.getSynonymTypesProvider();
                    synonymProvider.collectSynonymTypes(receiverType, new SynonymTypesProvider.Acceptor(){

                        @Override
                        protected boolean accept(LightweightTypeReference synonym, EnumSet<ConformanceHint> hints) {
                            if (declaringTypeReference.isAssignableFrom(synonym, rawConformanceCheck)) {
                                expectedReceiverTypeWrapper.set((Object)synonym);
                                return false;
                            }
                            return true;
                        }
                    });
                    LightweightTypeReference expectedReceiverType = (LightweightTypeReference)expectedReceiverTypeWrapper.get();
                    if (expectedReceiverType != null) {
                        this.getState().refineExpectedType(actualReceiver, expectedReceiverType);
                    }
                }
            }
        }
        super.applyToComputationState();
    }

    @Override
    protected boolean isRawTypeContext() {
        LightweightTypeReference receiverType = this.getReceiverType();
        return receiverType != null && receiverType.isRawType();
    }

    @Override
    protected void resolveAgainstActualType(LightweightTypeReference declaredType, LightweightTypeReference actualType, AbstractTypeComputationState state) {
        super.resolveAgainstActualType(declaredType, actualType, state);
        if (!this.isStatic() && !this.isExtension()) {
            DeferredTypeParameterHintCollector collector = new DeferredTypeParameterHintCollector(state.getReferenceOwner());
            collector.processPairedReferences(declaredType, actualType);
        }
    }

    @Override
    protected List<XExpression> getArguments() {
        return this.getFeatureCall().getActualArguments();
    }

    @Override
    public XAbstractFeatureCall getFeatureCall() {
        return (XAbstractFeatureCall)this.getExpression();
    }

    @Override
    protected List<LightweightTypeReference> getSyntacticTypeArguments() {
        return Lists.transform(this.getFeatureCall().getTypeArguments(), (Function)this.getState().getResolvedTypes().getConverter());
    }

    @Override
    protected void resolveArgumentType(XExpression argument, @Nullable LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (argument == this.getSyntacticReceiver()) {
            LightweightTypeReference receiverType = this.getSyntacticReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine the receiver's type");
            }
            this.resolveKnownArgumentType(argument, receiverType, declaredType, argumentState);
        } else if (argument == this.getImplicitFirstArgument()) {
            LightweightTypeReference argumentType = this.getImplicitFirstArgumentType();
            if (argumentType == null) {
                throw new IllegalStateException("Cannot determine the implicit argument's type");
            }
            this.resolveKnownArgumentType(argument, argumentType, declaredType, argumentState);
        } else {
            super.resolveArgumentType(argument, declaredType, argumentState);
        }
    }

    protected void resolveKnownArgumentType(XExpression argument, LightweightTypeReference knownType, @Nullable LightweightTypeReference declaredType, ITypeComputationState argumentState) {
        if (!(argumentState instanceof AbstractTypeComputationState)) {
            throw new IllegalArgumentException("argumentState was " + argumentState);
        }
        AbstractTypeComputationState castedArgumentState = (AbstractTypeComputationState)argumentState;
        ResolvedTypes resolvedTypes = this.getState().getResolvedTypes();
        LightweightTypeReference copiedDeclaredType = declaredType != null ? declaredType.copyInto(resolvedTypes.getReferenceOwner()) : null;
        TypeExpectation expectation = new TypeExpectation(copiedDeclaredType, castedArgumentState, false);
        LightweightTypeReference copiedReceiverType = knownType.copyInto(resolvedTypes.getReferenceOwner());
        resolvedTypes.acceptType(argument, expectation, copiedReceiverType, false, ConformanceHint.UNCHECKED);
        if (copiedDeclaredType != null) {
            this.resolveAgainstActualType(copiedDeclaredType, copiedReceiverType, castedArgumentState);
        }
    }

    @Override
    protected Map<JvmTypeParameter, LightweightMergedBoundTypeArgument> getDeclaratorParameterMapping() {
        final Wrapper receiverTypeParameterMapping = Wrapper.wrap(Collections.emptyMap());
        XExpression receiver = this.getReceiver();
        if (receiver != null) {
            LightweightTypeReference receiverType = this.getReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine type of receiver " + this.getReceiver());
            }
            JvmIdentifiableElement feature = this.getFeature();
            if (feature instanceof JvmFeature) {
                TypeConformanceComputationArgument rawConformanceCheck;
                JvmDeclaredType declaringType = ((JvmFeature)feature).getDeclaringType();
                final ParameterizedTypeReference declaringTypeReference = new ParameterizedTypeReference(receiverType.getOwner(), (JvmType)declaringType);
                if (declaringTypeReference.isAssignableFrom(receiverType, rawConformanceCheck = new TypeConformanceComputationArgument(true, false, false, false, false, false))) {
                    receiverTypeParameterMapping.set(new DeclaratorTypeArgumentCollector().getTypeParameterMapping(receiverType));
                } else {
                    CommonTypeComputationServices services = receiverType.getOwner().getServices();
                    SynonymTypesProvider synonymProvider = services.getSynonymTypesProvider();
                    synonymProvider.collectSynonymTypes(receiverType, new SynonymTypesProvider.Acceptor(){

                        @Override
                        protected boolean accept(LightweightTypeReference synonym, EnumSet<ConformanceHint> hints) {
                            if (declaringTypeReference.isAssignableFrom(synonym, rawConformanceCheck)) {
                                receiverTypeParameterMapping.set(new DeclaratorTypeArgumentCollector().getTypeParameterMapping(synonym));
                                return false;
                            }
                            return true;
                        }
                    });
                }
            } else {
                receiverTypeParameterMapping.set(new DeclaratorTypeArgumentCollector().getTypeParameterMapping(receiverType));
            }
        }
        return (Map)receiverTypeParameterMapping.get();
    }

    @Override
    protected LightweightTypeReference getDeclaredType(JvmIdentifiableElement feature) {
        JvmOperation getClassOperation;
        if (feature instanceof JvmConstructor) {
            return this.getState().getConverter().toLightweightReference(this.getState().getTypeReferences().getTypeForName(Void.TYPE, (Notifier)feature, new JvmTypeReference[0]));
        }
        if (feature instanceof JvmOperation && feature.getSimpleName().equals("getClass") && (getClassOperation = (JvmOperation)feature).getParameters().isEmpty() && "java.lang.Object".equals(getClassOperation.getDeclaringType().getIdentifier())) {
            LightweightTypeReference receiverType = this.getReceiverType();
            if (receiverType == null) {
                throw new IllegalStateException("Cannot determine type of receiver " + this.getReceiver());
            }
            List<JvmType> rawTypes = receiverType.getRawTypes();
            if (rawTypes.isEmpty()) {
                return super.getDeclaredType(feature);
            }
            ParameterizedTypeReference result = new ParameterizedTypeReference(receiverType.getOwner(), getClassOperation.getReturnType().getType());
            WildcardTypeReference wildcard = new WildcardTypeReference(receiverType.getOwner());
            wildcard.addUpperBound(new ParameterizedTypeReference(receiverType.getOwner(), rawTypes.get(0)));
            result.addTypeArgument(wildcard);
            return result;
        }
        return super.getDeclaredType(feature);
    }

    @Nullable
    protected XExpression getImplicitReceiver() {
        return ((XAbstractFeatureCall)this.getExpression()).getImplicitReceiver();
    }

    @Nullable
    protected LightweightTypeReference getImplicitReceiverType() {
        LightweightTypeReference result = this.getActualType(this.getImplicitReceiver());
        return result;
    }

    @Nullable
    protected XExpression getImplicitFirstArgument() {
        return ((XAbstractFeatureCall)this.getExpression()).getImplicitFirstArgument();
    }

    @Nullable
    protected LightweightTypeReference getImplicitFirstArgumentType() {
        LightweightTypeReference result = this.getActualType(this.getImplicitFirstArgument());
        return result;
    }

    @Nullable
    protected XExpression getReceiver() {
        return this.getFeatureCall().getActualReceiver();
    }

    @Nullable
    protected LightweightTypeReference getReceiverType() {
        LightweightTypeReference result = this.getActualType(this.getReceiver());
        return result;
    }

    @Nullable
    protected XExpression getSyntacticReceiver() {
        return this.helper.getSyntacticReceiver(this.getFeatureCall());
    }

    @Nullable
    protected LightweightTypeReference getSyntacticReceiverType() {
        LightweightTypeReference result = this.getActualType(this.getSyntacticReceiver());
        return result;
    }

    protected List<XExpression> getSyntacticArguments() {
        return this.helper.getSyntacticArguments(this.getFeatureCall());
    }

    @Override
    public boolean isExtension() {
        return this.getFeatureCall().isExtension();
    }

    @Override
    protected boolean hasReceiver() {
        return !this.isStatic();
    }

    @Override
    public boolean isStatic() {
        return this.getFeatureCall().isStatic();
    }

    @Override
    public boolean isTypeLiteral() {
        XAbstractFeatureCall featureCall = this.getFeatureCall();
        return featureCall.isTypeLiteral();
    }
}

