/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ide.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Ordering;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.Comparator;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.xtext.ide.util.RangeComparator;

@Singleton
public class DocumentHighlightComparator
implements Comparator<DocumentHighlight> {
    private final Comparator<DocumentHighlight> delegate;

    @Inject
    public DocumentHighlightComparator(RangeComparator rangeComparator) {
        Preconditions.checkNotNull((Object)rangeComparator, (Object)"rangeComparator");
        this.delegate = (left, right) -> ComparisonChain.start().compare((Object)left.getRange(), (Object)right.getRange(), (Comparator)rangeComparator).compare((Comparable)left.getKind(), (Comparable)right.getKind()).result();
    }

    @Override
    public int compare(DocumentHighlight left, DocumentHighlight right) {
        return Ordering.from(this.delegate).nullsLast().compare((Object)left, (Object)right);
    }
}

