/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.ui.refactoring.participant;

import com.google.inject.BindingAnnotation;
import com.google.inject.Inject;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmDeclaredType;
import org.eclipse.xtext.common.types.JvmMember;
import org.eclipse.xtext.common.types.access.IMirror;
import org.eclipse.xtext.common.types.access.TypeResource;
import org.eclipse.xtext.common.types.access.impl.AbstractClassMirror;
import org.eclipse.xtext.ui.refactoring.IRefactoringUpdateAcceptor;
import org.eclipse.xtext.ui.refactoring.IRenameStrategy;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;

public class JvmMemberRenameStrategy
implements IRenameStrategy {
    protected URI targetMemberOriginalURI;
    protected URI targetMemberNewURI;
    protected String originalName;

    public boolean initialize(JvmMember targetMember, IRenameElementContext context) {
        this.targetMemberOriginalURI = EcoreUtil.getURI((EObject)targetMember);
        this.originalName = targetMember.getSimpleName();
        return true;
    }

    public void applyDeclarationChange(String newName, ResourceSet resourceSet) {
        JvmMember member = this.setName(this.targetMemberOriginalURI, resourceSet, newName);
        this.targetMemberNewURI = EcoreUtil.getURI((EObject)member);
    }

    public void revertDeclarationChange(ResourceSet resourceSet) {
        this.setName(this.targetMemberNewURI, resourceSet, this.originalName);
    }

    protected JvmMember setName(URI targetURI, ResourceSet resourceSet, String newName) {
        Resource typeResource;
        final JvmMember member = (JvmMember)resourceSet.getEObject(targetURI, true);
        for (JvmMember containedMember : EcoreUtil2.eAllOfType((EObject)member, JvmMember.class)) {
            containedMember.internalSetIdentifier(null);
        }
        member.setSimpleName(newName);
        if (member instanceof JvmDeclaredType && ((InternalEObject)member).eDirectResource() != null && (typeResource = member.eResource()) instanceof TypeResource) {
            String originalURI = typeResource.getURI().toString();
            int lastIndexOf = Math.max(originalURI.lastIndexOf(46), originalURI.lastIndexOf(47)) + 1;
            URI typeResourceNewURI = URI.createURI((String)(originalURI.substring(0, lastIndexOf) + newName));
            typeResource.setURI(typeResourceNewURI);
            ((TypeResource)typeResource).setMirror((IMirror)new AbstractClassMirror(){

                public boolean isSealed() {
                    return false;
                }

                public void initialize(TypeResource typeResource) {
                }

                protected String getTypeName() {
                    return member.getIdentifier();
                }
            });
        }
        return member;
    }

    public void createDeclarationUpdates(String newName, ResourceSet resourceSet, IRefactoringUpdateAcceptor updateAcceptor) {
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public RefactoringStatus validateNewName(String newName) {
        return new RefactoringStatus();
    }

    public static class Provider
    implements IRenameStrategy.Provider {
        @Inject
        private com.google.inject.Provider<JvmMemberRenameStrategy> guiceStartegyProvider;
        @Inject(optional=true)
        @Delegate
        private IRenameStrategy.Provider delegate;

        public IRenameStrategy get(EObject targetEObject, IRenameElementContext renameElementContext) throws IRenameStrategy.Provider.NoSuchStrategyException {
            if (targetEObject instanceof JvmMember) {
                JvmMemberRenameStrategy jvmMemberRenameStrategy = (JvmMemberRenameStrategy)this.guiceStartegyProvider.get();
                jvmMemberRenameStrategy.initialize((JvmMember)targetEObject, renameElementContext);
                return jvmMemberRenameStrategy;
            }
            return this.delegate == null ? null : this.delegate.get(targetEObject, renameElementContext);
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @BindingAnnotation
        public static @interface Delegate {
        }
    }
}

