/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.typesystem.internal;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.resource.ISynchronizable;
import org.eclipse.xtext.util.CancelIndicator;
import org.eclipse.xtext.util.OnChangeEvictingCache;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.AbstractBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.DefaultBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.internal.ForwardingResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.internal.IReentrantTypeResolver;

public class CachingBatchTypeResolver
extends AbstractBatchTypeResolver {
    @Inject
    private OnChangeEvictingCache cache;
    @Inject
    private DefaultBatchTypeResolver delegate;

    @Override
    protected IResolvedTypes doResolveTypes(final EObject object, final CancelIndicator monitor) {
        EObject nonArtificialObject = object;
        if (object.eResource() == null && object instanceof XAbstractFeatureCall) {
            nonArtificialObject = ((XAbstractFeatureCall)object).getFeature();
        }
        final Resource resource = nonArtificialObject.eResource();
        final LazyResolvedTypes result = (LazyResolvedTypes)this.cache.get(CachingBatchTypeResolver.class, resource, (Provider)new Provider<LazyResolvedTypes>(){

            public LazyResolvedTypes get() {
                IReentrantTypeResolver resolver = CachingBatchTypeResolver.this.delegate.getTypeResolver(object);
                return new LazyResolvedTypes(resolver, resource);
            }
        });
        this.cache.execWithoutCacheClear(resource, (IUnitOfWork)new IUnitOfWork.Void<Resource>(){

            public void process(Resource state) throws Exception {
                result.resolveTypes(monitor == null ? CancelIndicator.NullImpl : monitor);
            }
        });
        return result;
    }

    protected static class LazyResolvedTypes
    extends ForwardingResolvedTypes {
        private final IReentrantTypeResolver resolver;
        private final Resource resource;
        private volatile IResolvedTypes delegate;

        public LazyResolvedTypes(IReentrantTypeResolver resolver, Resource resource) {
            this.resolver = resolver;
            this.resource = resource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IResolvedTypes resolveTypes(CancelIndicator monitor) {
            if (this.delegate == null) {
                Object object = this.getLock();
                synchronized (object) {
                    if (this.delegate == null) {
                        IResolvedTypes result;
                        this.delegate = result = this.resolver.reentrantResolve(monitor);
                        return result;
                    }
                }
            }
            return this.delegate;
        }

        @Override
        protected IResolvedTypes delegate() {
            return this.delegate;
        }

        protected Object getLock() {
            if (this.resource instanceof ISynchronizable) {
                return ((ISynchronizable)this.resource).getLock();
            }
            return this.resource;
        }
    }
}

