/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.refactoring.ui;

import com.google.inject.Inject;
import com.google.inject.Provider;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.refactoring.ui.IRenameElementContext;
import org.eclipse.xtext.ui.refactoring.ui.RefactoringType;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringController;
import org.eclipse.xtext.ui.refactoring.ui.RenameRefactoringPopup;
import org.eclipse.xtext.util.Strings;

public class RenameLinkedMode {
    private static final Logger LOG = Logger.getLogger(RenameLinkedMode.class);
    @Inject
    private RenameRefactoringController controller;
    private XtextEditor editor;
    private RenameRefactoringPopup popup;
    private FocusEditingSupport focusEditingSupport;
    private boolean showPreview;
    private Point originalSelection;
    private String originalName;
    private LinkedModeModel linkedModeModel;
    private LinkedPositionGroup linkedPositionGroup;
    private LinkedPosition currentPosition;

    public boolean start(IRenameElementContext renameElementContext, Provider<LinkedPositionGroup> provider, IProgressMonitor monitor) {
        if (renameElementContext == null) {
            throw new IllegalArgumentException("RenameElementContext is null");
        }
        this.linkedPositionGroup = (LinkedPositionGroup)provider.get();
        if (this.linkedPositionGroup == null || this.linkedPositionGroup.isEmpty()) {
            return false;
        }
        this.editor = (XtextEditor)renameElementContext.getTriggeringEditor();
        this.focusEditingSupport = new FocusEditingSupport();
        ISourceViewer viewer = this.editor.getInternalSourceViewer();
        IDocument document = viewer.getDocument();
        this.originalSelection = viewer.getSelectedRange();
        this.currentPosition = this.linkedPositionGroup.getPositions()[0];
        this.originalName = this.getCurrentName();
        try {
            this.linkedModeModel = new LinkedModeModel();
            this.linkedModeModel.addGroup(this.linkedPositionGroup);
            this.linkedModeModel.forceInstall();
            this.linkedModeModel.addLinkingListener((ILinkedModeListener)new EditorSynchronizer());
            EditorLinkedModeUI ui = new EditorLinkedModeUI(this.linkedModeModel, (ITextViewer)viewer);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(document));
            if (this.currentPosition.includes(this.originalSelection.x)) {
                ui.setExitPosition((ITextViewer)viewer, this.originalSelection.x, 0, Integer.MAX_VALUE);
            }
            ui.enter();
            if (this.currentPosition.includes(this.originalSelection.x) && this.currentPosition.includes(this.originalSelection.x + this.originalSelection.y)) {
                viewer.setSelectedRange(this.originalSelection.x, this.originalSelection.y);
            }
            if (viewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
                registry.register((IEditingSupport)this.focusEditingSupport);
            }
            this.openPopup();
            viewer.getTextWidget().setFocus();
            return true;
        }
        catch (BadLocationException e) {
            throw new WrappedException((Exception)((Object)e));
        }
    }

    protected void openPopup() {
        this.popup = new RenameRefactoringPopup(this.editor, this.controller, this);
        this.popup.open();
    }

    public boolean isCurrentNameValid() {
        String currentName = this.getCurrentName();
        return !Strings.isEmpty((String)currentName) && !Strings.equal((String)this.originalName, (String)currentName);
    }

    public String getCurrentName() {
        if (this.currentPosition != null) {
            try {
                return this.currentPosition.getContent();
            }
            catch (BadLocationException e) {
                LOG.error((Object)"Error updating new name", (Throwable)e);
            }
        }
        return null;
    }

    public boolean isSameRenameElementContext(IRenameElementContext renameElementContext) {
        return renameElementContext.getTriggeringEditor() == this.editor && this.isCaretInLinkedPosition();
    }

    protected boolean isCaretInLinkedPosition() {
        return this.getCurrentLinkedPosition() != null;
    }

    public LinkedPosition getCurrentLinkedPosition() {
        Point selection = this.editor.getInternalSourceViewer().getSelectedRange();
        int start = selection.x;
        int end = start + selection.y;
        LinkedPosition[] positions = this.linkedPositionGroup.getPositions();
        int i = 0;
        while (i < positions.length) {
            LinkedPosition position = positions[i];
            if (position.includes(start) && position.includes(end)) {
                return position;
            }
            ++i;
        }
        return null;
    }

    public void linkedModeLeft() {
        ISourceViewer viewer;
        if (this.linkedModeModel != null) {
            this.linkedModeModel.exit(0);
        }
        if (this.popup != null) {
            this.popup.close();
        }
        if (this.editor != null && (viewer = this.editor.getInternalSourceViewer()) instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister((IEditingSupport)this.focusEditingSupport);
        }
    }

    protected class EditorSynchronizer
    implements ILinkedModeListener {
        protected EditorSynchronizer() {
        }

        public void left(LinkedModeModel model, int flags) {
            if ((flags & 2) != 0) {
                if (RenameLinkedMode.this.showPreview) {
                    RenameLinkedMode.this.controller.startRefactoring(RefactoringType.REFACTORING_PREVIEW);
                } else {
                    RenameLinkedMode.this.controller.startRefactoring(RefactoringType.REFACTORING_DIRECT);
                }
            } else {
                RenameLinkedMode.this.controller.cancelLinkedMode();
            }
        }

        public void suspend(LinkedModeModel model) {
        }

        public void resume(LinkedModeModel model, int flags) {
        }
    }

    protected class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        private IDocument document;

        public ExitPolicy(IDocument document) {
            this.document = document;
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            LinkedPosition position;
            boolean bl = RenameLinkedMode.this.showPreview = (event.stateMask & 0x40000) != 0 && (event.character == '\r' || event.character == '\n');
            if (length == 0 && (event.character == '\b' || event.character == '\u007f') && (position = model.findPosition(new LinkedPosition(this.document, offset, 0, -1))) != null) {
                if (event.character == '\b') {
                    if (offset - 1 < position.getOffset()) {
                        event.doit = false;
                    }
                } else if (offset + 1 > position.getOffset() + position.getLength()) {
                    event.doit = false;
                }
            }
            return null;
        }
    }

    protected class FocusEditingSupport
    implements IEditingSupport {
        protected FocusEditingSupport() {
        }

        public boolean ownsFocusShell() {
            Shell activeShell;
            if (RenameLinkedMode.this.popup == null) {
                return false;
            }
            if (RenameLinkedMode.this.popup.ownsFocusShell()) {
                return true;
            }
            Shell editorShell = RenameLinkedMode.this.editor.getSite().getShell();
            return editorShell == (activeShell = editorShell.getDisplay().getActiveShell());
        }

        public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
            return false;
        }
    }
}

