/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.ui.editor.contentassist.antlr;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.xtext.AbstractElement;
import org.eclipse.xtext.ide.editor.contentassist.antlr.ContentAssistContextFactory;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.contentassist.AbstractContentAssistContextFactory;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.PrefixMatcher;
import org.eclipse.xtext.util.ITextRegion;

@Singleton
public class DelegatingContentAssistContextFactory
extends AbstractContentAssistContextFactory {
    @Inject
    private Provider<StatefulFactory> statefulFactoryProvider;
    private ExecutorService pool = Executors.newFixedThreadPool(3);

    public Provider<? extends StatefulFactory> getStatefulFactoryProvider() {
        return this.statefulFactoryProvider;
    }

    protected ExecutorService getPool() {
        return this.pool;
    }

    @Override
    public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
        StatefulFactory factory = (StatefulFactory)this.getStatefulFactoryProvider().get();
        factory.setPool(this.pool);
        return factory.create(viewer, offset, resource);
    }

    public static class StatefulFactory {
        @Inject
        protected Provider<ContentAssistContext.Builder> contentAssistContextProvider;
        @Inject
        private ContentAssistContextFactory delegate;
        @Inject
        protected PrefixMatcher matcher;
        protected ITextViewer viewer;
        protected ITextSelection selection;
        protected XtextResource resource;

        public ContentAssistContext[] create(ITextViewer viewer, int offset, XtextResource resource) {
            this.viewer = viewer;
            this.resource = resource;
            return this.doCreateContexts(offset);
        }

        public void setPool(ExecutorService pool) {
            this.getDelegate().setPool(pool);
        }

        public ContentAssistContextFactory getDelegate() {
            return this.delegate;
        }

        protected ContentAssistContext[] doCreateContexts(int offset) {
            ITextSelection selection = (ITextSelection)this.viewer.getSelectionProvider().getSelection();
            SelectionBasedRegion region = new SelectionBasedRegion(selection);
            org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext[] delegateContexts = this.getDelegate().create(this.viewer.getDocument().get(), (ITextRegion)region, offset, this.resource);
            ContentAssistContext[] contexts = new ContentAssistContext[delegateContexts.length];
            int i = 0;
            while (i < delegateContexts.length) {
                contexts[i] = this.convert(delegateContexts[i]).toContext();
                ++i;
            }
            return contexts;
        }

        protected ContentAssistContext.Builder convert(org.eclipse.xtext.ide.editor.contentassist.ContentAssistContext delegateContext) {
            ContentAssistContext.Builder context = (ContentAssistContext.Builder)this.contentAssistContextProvider.get();
            context.setRootNode(delegateContext.getRootNode());
            context.setLastCompleteNode(delegateContext.getLastCompleteNode());
            context.setCurrentNode(delegateContext.getCurrentNode());
            context.setRootModel(delegateContext.getRootModel());
            context.setCurrentModel(delegateContext.getCurrentModel());
            context.setPreviousModel(delegateContext.getPreviousModel());
            context.setOffset(delegateContext.getOffset());
            context.setViewer(this.viewer);
            context.setPrefix(delegateContext.getPrefix());
            Region region = new Region(delegateContext.getReplaceRegion().getOffset(), delegateContext.getReplaceRegion().getLength());
            context.setReplaceRegion(region);
            context.setSelectedText(delegateContext.getSelectedText());
            context.setMatcher(this.matcher);
            context.setResource(this.resource);
            for (AbstractElement grammarElement : delegateContext.getFirstSetGrammarElements()) {
                context.accept(grammarElement);
            }
            return context;
        }

        protected static class SelectionBasedRegion
        implements ITextRegion {
            private ITextSelection selection;

            public SelectionBasedRegion(ITextSelection selection) {
                this.selection = selection;
            }

            public int getOffset() {
                return this.selection.getOffset();
            }

            public int getLength() {
                return this.selection.getLength();
            }

            public ITextRegion merge(ITextRegion region) {
                throw new UnsupportedOperationException();
            }

            public boolean contains(ITextRegion other) {
                throw new UnsupportedOperationException();
            }

            public boolean contains(int offset) {
                throw new UnsupportedOperationException();
            }
        }
    }
}

