/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.common.types.xtext.ui;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;

public class IntersectingJavaSearchScope
implements IJavaSearchScope {
    private static final Logger log = Logger.getLogger(IntersectingJavaSearchScope.class);
    private final IJavaSearchScope[] scopes;
    private final boolean[] dontAsk;

    public IntersectingJavaSearchScope(IJavaSearchScope ... scopes) {
        this.scopes = scopes;
        this.dontAsk = new boolean[scopes.length];
    }

    public boolean encloses(String resourcePath) {
        boolean result = false;
        int i = 0;
        while (i < this.scopes.length) {
            if (!this.dontAsk[i]) {
                block5: {
                    IJavaSearchScope scope = this.scopes[i];
                    if (scope.encloses(resourcePath)) break block5;
                    return false;
                }
                try {
                    result = true;
                }
                catch (Exception e) {
                    this.dontAsk[i] = true;
                    log.info((Object)"Exception in JDT code", (Throwable)e);
                }
            }
            ++i;
        }
        return result;
    }

    public boolean encloses(IJavaElement element) {
        boolean result = false;
        int i = 0;
        while (i < this.scopes.length) {
            if (!this.dontAsk[i]) {
                block5: {
                    IJavaSearchScope scope = this.scopes[i];
                    if (scope.encloses(element)) break block5;
                    return false;
                }
                try {
                    result = true;
                }
                catch (Exception e) {
                    this.dontAsk[i] = true;
                    log.info((Object)"Exception in JDT code", (Throwable)e);
                }
            }
            ++i;
        }
        return result;
    }

    public IPath[] enclosingProjectsAndJars() {
        if (this.scopes.length == 0) {
            return new IPath[0];
        }
        if (this.scopes.length == 1) {
            return this.scopes[0].enclosingProjectsAndJars();
        }
        Collection result = null;
        IJavaSearchScope[] iJavaSearchScopeArray = this.scopes;
        int n = this.scopes.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaSearchScope scope = iJavaSearchScopeArray[n2];
            if (result == null) {
                result = Sets.newLinkedHashSet(Arrays.asList(scope.enclosingProjectsAndJars()));
            } else {
                result.retainAll(Arrays.asList(scope.enclosingProjectsAndJars()));
            }
            ++n2;
        }
        if (result == null) {
            return new IPath[0];
        }
        return result.toArray(new IPath[result.size()]);
    }

    @Deprecated
    public boolean includesBinaries() {
        IJavaSearchScope[] iJavaSearchScopeArray = this.scopes;
        int n = this.scopes.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaSearchScope scope = iJavaSearchScopeArray[n2];
            if (!scope.includesBinaries()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Deprecated
    public boolean includesClasspaths() {
        IJavaSearchScope[] iJavaSearchScopeArray = this.scopes;
        int n = this.scopes.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaSearchScope scope = iJavaSearchScopeArray[n2];
            if (!scope.includesClasspaths()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Deprecated
    public void setIncludesBinaries(boolean includesBinaries) {
        IJavaSearchScope[] iJavaSearchScopeArray = this.scopes;
        int n = this.scopes.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaSearchScope scope = iJavaSearchScopeArray[n2];
            scope.setIncludesBinaries(includesBinaries);
            ++n2;
        }
    }

    @Deprecated
    public void setIncludesClasspaths(boolean includesClasspaths) {
        IJavaSearchScope[] iJavaSearchScopeArray = this.scopes;
        int n = this.scopes.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaSearchScope scope = iJavaSearchScopeArray[n2];
            scope.setIncludesClasspaths(includesClasspaths);
            ++n2;
        }
    }
}

