/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xtext.ui.graph.figures.layouts;

import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;

public class SequenceLayout
extends AbstractLayout {
    private int minHeight;

    public SequenceLayout(int minHeight) {
        this.minHeight = minHeight;
    }

    public SequenceLayout() {
        this(0);
    }

    public void layout(IFigure container) {
        int height = this.minHeight;
        for (Object child : container.getChildren()) {
            if (!(child instanceof IFigure)) continue;
            Dimension childSize = ((IFigure)child).getPreferredSize();
            height = Math.max(height, childSize.height);
        }
        Rectangle bounds = Rectangle.SINGLETON;
        int x = 0;
        for (Object child : container.getChildren()) {
            if (!(child instanceof IFigure)) continue;
            Dimension childSize = ((IFigure)child).getPreferredSize();
            bounds.setLocation(x, (height - childSize.height) / 2);
            bounds.setSize(childSize);
            ((IFigure)child).setBounds(bounds);
            x += childSize.width + 10;
        }
    }

    protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
        int width = 0;
        int height = this.minHeight;
        for (Object child : container.getChildren()) {
            if (!(child instanceof IFigure)) continue;
            Dimension childSize = ((IFigure)child).getPreferredSize();
            height = Math.max(height, childSize.height);
            width += childSize.width + 10;
        }
        return new Dimension(width -= 10, height);
    }
}

