/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.service;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtext.AbstractRule;
import org.eclipse.xtext.Grammar;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.TerminalRule;

public class AllRulesCache {
    private final Map<String, AbstractRule> allRulesCache = Maps.newHashMap();

    public AllRulesCache(Grammar grammar) {
        List<AbstractRule> allRules = GrammarUtil.allRules(grammar);
        for (AbstractRule rule : allRules) {
            if (rule instanceof TerminalRule) {
                this.allRulesCache.put(rule.getName().toUpperCase(), rule);
                continue;
            }
            this.allRulesCache.put(rule.getName(), rule);
        }
    }

    public static AllRulesCache findInEmfObject(Notifier emfObject) {
        for (Adapter adapter : emfObject.eAdapters()) {
            if (!(adapter instanceof AllRulesCacheAdapter)) continue;
            return ((AllRulesCacheAdapter)adapter).get();
        }
        return null;
    }

    public static AllRulesCache removeFromEmfObject(Notifier emfObject) {
        EList adapters = emfObject.eAdapters();
        int i = 0;
        int max = adapters.size();
        while (i < max) {
            Adapter adapter = (Adapter)adapters.get(i);
            if (adapter instanceof AllRulesCacheAdapter) {
                emfObject.eAdapters().remove(i);
                return ((AllRulesCacheAdapter)adapter).get();
            }
            ++i;
        }
        return null;
    }

    public void attachToEmfObject(Notifier emfObject) {
        AllRulesCache result = AllRulesCache.findInEmfObject(emfObject);
        if (result != null) {
            throw new IllegalStateException("The given EMF object already contains an adapter for AllRulesCache");
        }
        AllRulesCacheAdapter adapter = new AllRulesCacheAdapter(this);
        emfObject.eAdapters().add((Object)adapter);
    }

    public Map<String, AbstractRule> getAllRules() {
        return this.allRulesCache;
    }

    public static class AllRulesCacheAdapter
    extends AdapterImpl {
        private final AllRulesCache element;

        public AllRulesCacheAdapter(AllRulesCache element) {
            this.element = element;
        }

        public AllRulesCache get() {
            return this.element;
        }

        public boolean isAdapterForType(Object object) {
            return object == AllRulesCache.class;
        }
    }
}

