/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.project;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.m2m.internal.qvt.oml.ast.env.InternalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelExtentContents;
import org.eclipse.m2m.internal.qvt.oml.ast.env.ModelParameterExtent;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtEvaluationResult;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEvaluationEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalFileEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalParserUtil;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledUnit;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.emf.util.EmfUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;
import org.eclipse.m2m.internal.qvt.oml.evaluator.ModelParameterHelper;
import org.eclipse.m2m.internal.qvt.oml.expressions.DirectionKind;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.Module;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.generator.TransformationRunner;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.WorkspaceQvtModule;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.config.QvtConfigurationProperty;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.qvt.oml.util.IContext;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EvaluationEnvironment;
import org.eclipse.ocl.EvaluationVisitor;
import org.eclipse.ocl.utilities.Visitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QvtInterpretedTransformation
implements QvtTransformation {
    private final QvtModule myModule;
    private QvtOperationalEnvFactory myEnvFactory;

    public QvtInterpretedTransformation(IFile transformationFile) {
        this.myModule = new WorkspaceQvtModule(transformationFile);
    }

    public QvtInterpretedTransformation(QvtModule qvtModule) {
        if (qvtModule == null) {
            throw new IllegalArgumentException("Null QvtModule");
        }
        this.myModule = qvtModule;
    }

    public QvtModule getModule() {
        return this.myModule;
    }

    @Override
    public ModelContent loadInput(URI inputObjectURI) throws MdaException {
        return EmfUtil.loadModel((URI)inputObjectURI, (ResourceSet)this.myModule.getResourceSet());
    }

    public void setQvtCompilerOptions(QvtCompilerOptions options) {
        this.myModule.setQvtCompilerOptions(options);
    }

    @Override
    public TransformationRunner.Out run(TransformationRunner.In in) throws MdaException {
        Module module = this.myModule.getModule();
        Iterator<QvtTransformation.TransformationParameter> itrParam = this.getParameters().iterator();
        ArrayList<ModelContent> inputs = new ArrayList<ModelContent>(in.getSources().length);
        ModelContent[] modelContentArray = in.getSources();
        int n = modelContentArray.length;
        int n2 = 0;
        while (n2 < n) {
            ModelContent inSource = modelContentArray[n2];
            QvtTransformation.TransformationParameter transfParam = null;
            while (itrParam.hasNext()) {
                transfParam = itrParam.next();
                if (transfParam.getDirectionKind() != QvtTransformation.TransformationParameter.DirectionKind.OUT) break;
                transfParam = null;
            }
            EClassifier mmClass = null;
            if (transfParam != null) {
                if (transfParam.getEntryType() != null) {
                    mmClass = transfParam.getEntryType();
                } else if (!transfParam.getMetamodels().isEmpty()) {
                    mmClass = (EObject)transfParam.getMetamodels().get(0);
                }
            }
            try {
                inputs.add(inSource.getResolvedContent(mmClass));
            }
            catch (WrappedException e) {
                throw new MdaException(e.getCause());
            }
            ++n2;
        }
        return this.evaluate(this.myModule.getResourceSet(), module, inputs, in.getContext());
    }

    @Override
    public String getModuleName() throws MdaException {
        return this.myModule.getModule().getName();
    }

    @Override
    public URI getURI() throws MdaException {
        return this.myModule.getUnit().getURI();
    }

    @Override
    public List<QvtTransformation.TransformationParameter> getParameters() throws MdaException {
        return this.myModule.getParameters();
    }

    @Override
    public boolean hasEntryOperation() throws MdaException {
        return QvtOperationalParserUtil.getMainOperation((Module)this.myModule.getModule()) != null;
    }

    @Override
    public boolean isBlackbox() throws MdaException {
        return this.myModule.getModule().isIsBlackbox();
    }

    @Override
    public Set<QvtConfigurationProperty> getConfigurationProperties() throws MdaException {
        return this.myModule.getConfigurationProperties();
    }

    @Override
    public ResourceSet getResourceSet() throws MdaException {
        return this.myModule.getResourceSet();
    }

    @Override
    public void cleanup() throws MdaException {
        this.myModule.cleanup();
    }

    protected QvtOperationalEnvFactory getEnvironmentFactory() {
        if (this.myEnvFactory == null) {
            this.myEnvFactory = new QvtOperationalEnvFactory();
        }
        return this.myEnvFactory;
    }

    protected void setEnvironmentFactory(QvtOperationalEnvFactory factory) {
        this.myEnvFactory = factory;
    }

    private TransformationRunner.Out evaluate(ResourceSet rs, Module module, List<ModelContent> args, IContext context) {
        CompiledUnit unit;
        QvtOperationalEnvFactory factory = this.getEnvironmentFactory();
        QvtOperationalEvaluationEnv evaluationEnv = factory.createEvaluationEnvironment(context, null);
        QvtInterpretedTransformation.setArguments(evaluationEnv, (OperationalTransformation)module, args, rs);
        try {
            unit = this.myModule.getUnit();
        }
        catch (MdaException e) {
            throw new IllegalStateException("unit must be available");
        }
        QvtOperationalFileEnv rootEnv = factory.createEnvironment(unit.getURI());
        EvaluationVisitor evaluator = factory.createEvaluationVisitor((Environment)rootEnv, (EvaluationEnvironment)evaluationEnv, null);
        Trace traces = ((InternalEvaluationEnv)evaluationEnv.getAdapter(InternalEvaluationEnv.class)).getTraces();
        Object outObj = module.accept((Visitor)evaluator);
        if (!(outObj instanceof QvtEvaluationResult)) {
            return new TransformationRunner.Out(Collections.<ModelExtentContents>emptyList(), Collections.<Object>emptyList(), traces);
        }
        return new TransformationRunner.Out(((QvtEvaluationResult)outObj).getModelExtents(), ((QvtEvaluationResult)outObj).getOutParamValues(), traces);
    }

    private static void setArguments(QvtOperationalEvaluationEnv evalEnv, OperationalTransformation transformation, List<ModelContent> args, ResourceSet compilerRS) {
        ArrayList<ModelParameterExtent> tranformArgs = new ArrayList<ModelParameterExtent>();
        int argCount = 0;
        for (ModelParameter modelParam : transformation.getModelParameter()) {
            ModelParameterExtent extent;
            if (modelParam.getKind() != DirectionKind.OUT) {
                ModelContent nextArg;
                if (argCount >= args.size()) {
                    throw new IllegalArgumentException("Invalid count of input arguments");
                }
                if ((nextArg = args.get(argCount++)) == null) {
                    throw new IllegalArgumentException("Non-null model argument is required");
                }
                extent = new ModelParameterExtent(nextArg.getContent(), compilerRS, modelParam);
            } else {
                extent = new ModelParameterExtent(compilerRS);
            }
            evalEnv.addModelExtent(extent);
            tranformArgs.add(extent);
        }
        List modelArgs = ModelParameterHelper.createModelArguments((OperationalTransformation)transformation, tranformArgs);
        evalEnv.getOperationArgs().addAll(modelArgs);
    }

    public String toString() {
        try {
            return this.getModuleName();
        }
        catch (MdaException mdaException) {
            return super.toString();
        }
    }
}

