/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessage;
import org.eclipse.m2m.internal.qvt.oml.common.launch.ISetMessageEx;
import org.eclipse.m2m.internal.qvt.oml.common.launch.TargetUriData;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.IUriGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.OptionalFileGroup;
import org.eclipse.m2m.internal.qvt.oml.common.ui.launch.TransformationControls;
import org.eclipse.m2m.internal.qvt.oml.emf.util.Logger;
import org.eclipse.m2m.internal.qvt.oml.emf.util.StatusUtil;
import org.eclipse.m2m.internal.qvt.oml.emf.util.WorkspaceUtils;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtLaunchUtil;
import org.eclipse.m2m.internal.qvt.oml.runtime.launch.QvtValidator;
import org.eclipse.m2m.internal.qvt.oml.runtime.project.QvtTransformation;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.TransformationSignatureLaunchControl;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.wizards.Messages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransformationParametersPage
extends WizardPage {
    private final ISetMessageEx SET_MESSAGE = new ISetMessageEx(){

        public void setErrorMessage(String message) {
            TransformationParametersPage.this.setErrorMessage(message);
        }

        public void setWarningMessage(String message) {
            TransformationParametersPage.this.setMessage(message, 2);
        }

        public void setMessage(String message) {
            TransformationParametersPage.this.setMessage(message);
        }
    };
    private QvtTransformation myTransformation;
    private final ResourceSet myValidationRS;
    private final List<IUriGroup.IModifyListener> myUriListeners;
    private OptionalFileGroup myTraceFile;
    private boolean myTraceNameNonChanged;
    private TransformationSignatureLaunchControl myTransfSignatureControl;
    private final List<URI> myInitialParamUris;
    private Button myOpenEditor;

    public TransformationParametersPage(String pageId, List<URI> paramUris, ResourceSet validationRS) {
        super(pageId);
        this.setDescription(Messages.TransformationParametersPage_Description);
        this.myInitialParamUris = paramUris != null ? paramUris : Collections.emptyList();
        this.myValidationRS = validationRS;
        this.myUriListeners = new ArrayList<IUriGroup.IModifyListener>(1);
        this.myUriListeners.add(new IUriGroup.IModifyListener(){

            public void modified() {
                TransformationParametersPage.this.initTraceFileText();
                TransformationParametersPage.this.setPageComplete(TransformationParametersPage.this.validatePage());
            }
        });
    }

    public void setTransformation(QvtTransformation transformation) {
        this.myTransformation = transformation;
        if (this.myTransformation != null) {
            this.setTitle(NLS.bind((String)Messages.TransformationParametersPage_TitleWithTransf, (Object)this.myTransformation));
        }
        if (this.myTransfSignatureControl != null) {
            this.myTransfSignatureControl.setTransformation(this.myTransformation, this.myUriListeners);
        }
        if (this.myTransfSignatureControl != null && this.myTransformation != null) {
            try {
                List<TargetUriData> initTargetUriData = this.initTargetUriData(this.myInitialParamUris);
                if (!initTargetUriData.isEmpty()) {
                    this.applyTargetUris(initTargetUriData);
                }
            }
            catch (MdaException mdaException) {}
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        this.createTransformationSection(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        this.setPageComplete(this.validatePage());
    }

    protected void createTransformationSection(Composite parent) {
        this.myTraceFile = new OptionalFileGroup(parent, org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages.QvtLauncherTab_TraceFile);
        this.myTraceFile.addModifyListener(new OptionalFileGroup.IModifyListener(){

            public void modified() {
                TransformationParametersPage.this.myTraceNameNonChanged = TransformationParametersPage.this.myTraceFile.getText().equals(TransformationParametersPage.this.getTraceFileName());
            }
        });
        TransformationControls.createLabel((Composite)parent, (String)org.eclipse.m2m.internal.qvt.oml.runtime.ui.launch.Messages.QvtLauncherTab_ParametersLabel, (int)2);
        this.myTransfSignatureControl = new TransformationSignatureLaunchControl(parent, 2048, this.myValidationRS);
        this.setTransformation(this.myTransformation);
        TransformationControls.createLabel((Composite)parent, (String)"", (int)2);
        this.myOpenEditor = new Button(parent, 32);
        this.myOpenEditor.setText(Messages.ApplyTransformationFinalPage_OpenEditor);
        this.myOpenEditor.setSelection(false);
        this.myOpenEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TransformationParametersPage.this.setPageComplete(TransformationParametersPage.this.validatePage());
            }
        });
        this.myOpenEditor.setLayoutData((Object)new GridData());
    }

    private void applyTargetUris(List<TargetUriData> paramTargetUris) {
        try {
            ILaunchConfigurationWorkingCopy workingCopy = QvtLaunchUtil.getInMemoryLaunchConfigurationType().newInstance(null, "QVTO");
            workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.elemCount", paramTargetUris.size());
            int index = 1;
            for (TargetUriData targetUri : paramTargetUris) {
                QvtLaunchUtil.saveTargetUriData((ILaunchConfigurationWorkingCopy)workingCopy, (TargetUriData)targetUri, (int)index);
                ++index;
            }
            this.myTransfSignatureControl.initializeFrom((ILaunchConfiguration)workingCopy);
        }
        catch (CoreException e) {
            Logger.getLogger().log(Logger.SEVERE, "Fail to initialize luanch configuration", e);
        }
    }

    private List<TargetUriData> initTargetUriData(List<URI> paramUris) throws MdaException {
        if (paramUris.isEmpty()) {
            return Collections.emptyList();
        }
        URI firstUri = paramUris.get(0);
        IFile ifile = WorkspaceUtils.getWorkspaceFile((URI)firstUri);
        ArrayList<TargetUriData> proposedUris = new ArrayList<TargetUriData>(this.myTransformation.getParameters().size());
        int index = 0;
        for (QvtTransformation.TransformationParameter transfParam : this.myTransformation.getParameters()) {
            if (transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.IN || transfParam.getDirectionKind() == QvtTransformation.TransformationParameter.DirectionKind.INOUT) {
                if (index >= paramUris.size()) {
                    proposedUris.add(new TargetUriData(""));
                } else {
                    URI localURI = paramUris.get(index);
                    if (localURI.isFile()) {
                        try {
                            localURI = URI.createPlatformResourceURI((String)localURI.toFileString(), (boolean)false);
                        }
                        catch (RuntimeException runtimeException) {
                            localURI = null;
                        }
                    }
                    proposedUris.add(new TargetUriData(localURI != null ? localURI.toString() : ""));
                }
                ++index;
                continue;
            }
            if (ifile != null) {
                try {
                    String extension = transfParam.getMetamodels().isEmpty() ? "xmi" : ((EPackage)transfParam.getMetamodels().get(0)).getName();
                    String fileName = String.valueOf(this.myTransformation.getModuleName()) + "." + extension;
                    Path targetPath = new Path(ifile.getParent().getFullPath() + "/" + fileName);
                    URI targetUri = URI.createPlatformResourceURI((String)targetPath.toString(), (boolean)false);
                    proposedUris.add(new TargetUriData(targetUri == null ? "" : targetUri.toString()));
                }
                catch (Exception e) {
                    Logger.getLogger().log(Logger.SEVERE, "Failed to get outClass for " + transfParam, e);
                    proposedUris.add(new TargetUriData(""));
                }
                continue;
            }
            proposedUris.add(new TargetUriData(""));
        }
        return proposedUris;
    }

    public void applyConfiguration(ILaunchConfigurationWorkingCopy workingCopy) {
        this.myTransfSignatureControl.performApply(workingCopy);
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.traceFile", this.myTraceFile.getText());
        workingCopy.setAttribute("org.eclipse.m2m.qvt.oml.interpreter.useTraceFile", this.myTraceFile.getUseFileFlag());
    }

    public boolean isOpenInEditor() {
        return this.myOpenEditor.getSelection();
    }

    protected boolean validatePage() {
        String moduleName;
        if (this.myTransformation == null) {
            return false;
        }
        this.setMessage(null);
        this.setErrorMessage(null);
        try {
            moduleName = this.myTransformation.getModuleName();
        }
        catch (MdaException e) {
            IStatus status = StatusUtil.makeErrorStatus((String)e.getMessage(), (Exception)((Object)e));
            return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
        }
        if (this.myTraceFile.getText().length() == 0) {
            this.myTraceFile.update(moduleName, "qvtotrace");
        }
        IStatus status = this.myTransfSignatureControl.validate(moduleName, this.getShell());
        IStatus traceStatus = QvtValidator.validateTrace((String)this.myTraceFile.getText(), (boolean)this.myTraceFile.getUseFileFlag());
        if (traceStatus.getSeverity() > status.getSeverity()) {
            status = traceStatus;
        }
        return TransformationControls.statusToTab((IStatus)status, (ISetMessage)this.SET_MESSAGE);
    }

    private String getTraceFileName() {
        URI targetUri = URI.createURI((String)this.myTransfSignatureControl.getTraceName());
        return QvtLaunchUtil.getTraceFileName((URI)targetUri);
    }

    private void initTraceFileText() {
        if (this.myTraceNameNonChanged || this.myTraceFile.getText().length() == 0) {
            String traceFileName = this.getTraceFileName();
            this.myTraceFile.setText(traceFileName);
            this.myTraceFile.setUseFileFlag(traceFileName != null);
            if (traceFileName != null) {
                IPath path = Path.fromOSString((String)traceFileName);
                this.myTraceFile.update(path.lastSegment().replaceAll(".qvtotrace", ""), "qvtotrace");
            }
        }
    }
}

