/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.m2m.internal.qvt.oml.common.MdaException;
import org.eclipse.m2m.internal.qvt.oml.common.io.CFile;
import org.eclipse.m2m.internal.qvt.oml.common.io.eclipse.EclipseFile;
import org.eclipse.m2m.internal.qvt.oml.compiler.CompiledModule;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolver;
import org.eclipse.m2m.internal.qvt.oml.compiler.IImportResolverFactory;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilationResult;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompiler;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;

public class QvtEngine {
    private static Map<IProject, QvtEngine> ourEnginesMap = new HashMap<IProject, QvtEngine>();
    private QvtCompiler myCompiler;
    private IProject myProject;
    private final IImportResolver myImportResolver;

    public static QvtEngine getInstance(IResource resource) {
        IProject project = resource.getProject();
        QvtEngine engine = ourEnginesMap.get(project);
        if (engine == null) {
            engine = new QvtEngine(project);
            ourEnginesMap.put(project, engine);
        }
        return engine;
    }

    private QvtEngine(IProject project) {
        this.myProject = project;
        IImportResolverFactory resolverFactory = IImportResolverFactory.Registry.INSTANCE.getFactory(this.myProject);
        this.myImportResolver = resolverFactory.createResolver(this.myProject);
        this.reset(null);
    }

    public QvtCompilationResult compile(CFile source, QvtCompilerOptions options, IProgressMonitor monitor) throws MdaException {
        this.reset(options);
        return this.myCompiler.compile(source, options, monitor);
    }

    public CompiledModule compile(IFile file, IProgressMonitor monitor) throws MdaException {
        return this.compile(file, monitor, null);
    }

    public CompiledModule compile(IFile file, IProgressMonitor monitor, QvtCompilerOptions options) throws MdaException {
        return this.compile(new IFile[]{file}, monitor, options)[0].getModule();
    }

    public QvtCompilationResult[] compile(IFile[] files, IProgressMonitor monitor) throws MdaException {
        return this.compile(files, monitor, null);
    }

    public QvtCompilationResult[] compile(IFile[] files, IProgressMonitor monitor, QvtCompilerOptions options) throws MdaException {
        EclipseFile[] sources = new EclipseFile[files.length];
        int i = 0;
        while (i < sources.length) {
            sources[i] = new EclipseFile(files[i]);
            ++i;
        }
        this.reset(options);
        if (options == null) {
            options = new QvtCompilerOptions();
            options.setGenerateCompletionData(false);
        }
        return this.myCompiler.compile((CFile[])sources, options, monitor);
    }

    public QvtCompiler getCompiler() {
        return this.myCompiler;
    }

    private void reset(QvtCompilerOptions options) {
        this.myCompiler = new QvtCompiler(this.myImportResolver);
        if (options != null) {
            this.myCompiler.getKernel().setMetamodelResourceSet(options.getMetamodelResourceSet());
        }
    }
}

