/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvt.declarative.editor.ui.imp;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ocl.lpg.AbstractParser;
import org.eclipse.qvt.declarative.editor.ui.imp.CommonKeyword;
import org.eclipse.qvt.declarative.editor.ui.imp.ICommonKeyword;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommonParseHelper {
    private List<ICommonKeyword> keywords = null;
    private String[] tokenKindNames = null;
    private boolean[] fIsKeyword = null;

    public CommonParseHelper(AbstractParser parser) {
        this.tokenKindNames = parser.orderedTerminalSymbols();
        this.fIsKeyword = new boolean[this.tokenKindNames.length];
        this.keywords = new ArrayList<ICommonKeyword>();
        int[] keywordKinds = parser.getLexer().getKeywordKinds();
        int i = 1;
        while (i < keywordKinds.length) {
            int index = parser.getIPrsStream().mapKind(keywordKinds[i]);
            this.fIsKeyword[index] = true;
            this.keywords.add(this.createKeyword(this.tokenKindNames[index]));
            ++i;
        }
    }

    protected ICommonKeyword createKeyword(String text) {
        return new CommonKeyword(text);
    }

    public List<ICommonKeyword> getKeywords() {
        return this.keywords;
    }

    public boolean isKeyword(int kind) {
        return kind < this.tokenKindNames.length && this.fIsKeyword[kind];
    }
}

