/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.imp.editor;

public class ModelTreeNode {
    public static final int DEFAULT_CATEGORY = 0;
    private static final ModelTreeNode[] NO_CHILDREN = new ModelTreeNode[0];
    private ModelTreeNode[] fChildren = NO_CHILDREN;
    private ModelTreeNode fParent;
    private final Object fASTNode;
    private final int fCategory;

    public ModelTreeNode(Object astNode) {
        this(astNode, 0);
    }

    public ModelTreeNode(Object astNode, int category) {
        this.fASTNode = astNode;
        this.fCategory = category;
    }

    public ModelTreeNode(Object astNode, ModelTreeNode parent) {
        this(astNode, parent, 0);
    }

    public ModelTreeNode(Object astNode, ModelTreeNode parent, int category) {
        this.fASTNode = astNode;
        this.fParent = parent;
        this.fCategory = category;
    }

    public void setChildren(ModelTreeNode[] children) {
        this.fChildren = children;
        int i = 0;
        while (i < children.length) {
            children[i].fParent = this;
            ++i;
        }
    }

    public void addChild(ModelTreeNode child) {
        ModelTreeNode[] newChildren = new ModelTreeNode[this.fChildren.length + 1];
        System.arraycopy(this.fChildren, 0, newChildren, 0, this.fChildren.length);
        newChildren[this.fChildren.length] = child;
        this.fChildren = newChildren;
    }

    public ModelTreeNode[] getChildren() {
        return this.fChildren;
    }

    public ModelTreeNode getParent() {
        return this.fParent;
    }

    public Object getASTNode() {
        return this.fASTNode;
    }

    public int getCategory() {
        return this.fCategory;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.fASTNode.toString());
        if (this.fChildren.length > 0) {
            sb.append(" [");
            int i = 0;
            while (i < this.fChildren.length) {
                sb.append(this.fChildren[i].toString());
                ++i;
            }
            sb.append(" ]");
        }
        return sb.toString();
    }
}

