/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvti;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.AnyType;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.LetExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.PropertyCallExp;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypeExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.Variable;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.complete.StandardLibraryInternal;
import org.eclipse.ocl.pivot.internal.manager.PivotMetamodelManager;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Node;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.NodeConnection;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.Region;
import org.eclipse.qvtd.compiler.internal.qvtp2qvts.SchedulerConstants;
import org.eclipse.qvtd.compiler.internal.qvts2qvti.QVTs2QVTiVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionAssignment;
import org.eclipse.qvtd.pivot.qvtimperative.ConnectionVariable;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCall;
import org.eclipse.qvtd.pivot.qvtimperative.MappingCallBinding;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeHelper;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;

public abstract class AbstractRegion2Mapping {
    protected final @NonNull QVTs2QVTiVisitor visitor;
    protected final @NonNull QVTimperativeHelper helper;
    protected final @NonNull Region region;
    protected final @NonNull Mapping mapping;
    private final @NonNull Map<@NonNull TypedElement, @NonNull Node> qvtp2node = new HashMap<TypedElement, Node>();
    private final @NonNull Map<@NonNull Node, @NonNull String> node2name = new HashMap<Node, String>();
    private final @NonNull Set<@NonNull String> names;
    protected Map<@NonNull NodeConnection, @NonNull Variable> connection2variable = null;

    public AbstractRegion2Mapping(@NonNull QVTs2QVTiVisitor visitor, @NonNull Region region) {
        this.visitor = visitor;
        this.helper = new QVTimperativeHelper(visitor.getEnvironmentFactory());
        this.region = region;
        String name = region.getSymbolName();
        assert (name != null);
        this.mapping = QVTimperativeUtil.createMapping((String)name);
        this.names = new HashSet<String>(visitor.getReservedNames());
        for (Node node : region.getNodes()) {
            for (TypedElement typedElement : node.getTypedElements()) {
                Node oldNode = this.qvtp2node.put(typedElement, node);
                assert (oldNode == null || oldNode == node);
            }
        }
    }

    protected @NonNull CallExp createCallExp(@NonNull OCLExpression asSource, @NonNull Property asProperty) {
        if (asProperty.eContainer() == null) {
            Type asType = asProperty.getType();
            SchedulerConstants schedulerConstants = this.getRegion().getSchedulerConstants();
            if (asProperty == schedulerConstants.getOclContainerProperty()) {
                return this.helper.createOperationCallExp(asSource, "oclContainer", new OCLExpression[0]);
            }
            if (asType != null && asProperty == schedulerConstants.getCastProperty(asType)) {
                return this.createOclAsTypeCallExp(asSource, asType);
            }
            throw new UnsupportedOperationException();
        }
        return PivotUtil.createNavigationCallExp((OCLExpression)asSource, (Property)asProperty);
    }

    protected void createConnectionAssignment(@NonNull ConnectionVariable connectionVariable, @NonNull OCLExpression childrenExpression) {
        ConnectionAssignment connectionAssignment = this.helper.createConnectionAssignment(connectionVariable, childrenExpression);
        this.mapping.getBottomPattern().getAssignment().add((Object)connectionAssignment);
    }

    protected @NonNull ConnectionVariable createConnectionVariable(@NonNull NodeConnection connection) {
        Type asType = this.getConnectionSourcesType(connection);
        String name = connection.getName();
        assert (name != null);
        return this.helper.createConnectionVariable(this.getSafeName(name), asType, null);
    }

    protected void createConnectionGuardVariables() {
        List<@NonNull NodeConnection> intermediateConnections = this.region.getIntermediateConnections();
        if (intermediateConnections.size() > 0) {
            this.connection2variable = new HashMap<NodeConnection, Variable>();
            for (NodeConnection connection : intermediateConnections) {
                ConnectionVariable connectionVariable = this.createConnectionVariable(connection);
                this.connection2variable.put(connection, (Variable)connectionVariable);
                this.mapping.getGuardPattern().getVariable().add((Object)connectionVariable);
            }
        }
    }

    protected @NonNull CallExp createOclAsTypeCallExp(@NonNull OCLExpression asSource, @NonNull Type asType) {
        SchedulerConstants schedulerConstants = this.getRegion().getSchedulerConstants();
        CompleteClass completeClass = schedulerConstants.getEnvironmentFactory().getCompleteModel().getCompleteClass(asType);
        TypeExp asTypeExp = this.helper.createTypeExp((Type)completeClass.getPrimaryClass());
        return this.helper.createOperationCallExp(asSource, "oclAsType", new OCLExpression[]{asTypeExp});
    }

    public abstract void createStatements();

    protected @NonNull Variable createVariable(@NonNull Node node) {
        Class asType = node.getClassDatumAnalysis().getCompleteClass().getPrimaryClass();
        assert (asType != null);
        return PivotUtil.createVariable((String)this.getSafeName(node), (Type)asType, (boolean)true, null);
    }

    protected int getCollectionDepth(@NonNull Type type) {
        if (type instanceof CollectionType) {
            Type elementType = ((CollectionType)type).getElementType();
            assert (elementType != null);
            return this.getCollectionDepth(elementType) + 1;
        }
        return 0;
    }

    protected @NonNull Type getConnectionSourcesType(@NonNull NodeConnection connection) {
        IdResolver idResolver = this.visitor.getEnvironmentFactory().getIdResolver();
        Type asType = connection.getSourcesType(idResolver);
        assert (asType != null);
        return asType;
    }

    public @NonNull Variable getConnectionVariable(@NonNull NodeConnection connection) {
        assert (this.connection2variable != null);
        Variable connectionVariable = this.connection2variable.get(connection);
        assert (connectionVariable != null);
        return connectionVariable;
    }

    public abstract @NonNull List<@NonNull Node> getGuardNodes();

    public abstract @NonNull Variable getGuardVariable(@NonNull Node var1);

    public @NonNull Mapping getMapping() {
        return this.mapping;
    }

    protected @NonNull PivotMetamodelManager getMetamodelManager() {
        return (PivotMetamodelManager)this.visitor.getMetamodelManager();
    }

    public @Nullable Node getNode(@Nullable TypedElement qvtpTypedElement) {
        OppositePropertyCallExp propertyCallExp;
        Node sourceNode;
        if (qvtpTypedElement instanceof VariableExp) {
            return this.getNode((TypedElement)((VariableExp)qvtpTypedElement).getReferredVariable());
        }
        if (qvtpTypedElement instanceof LetExp) {
            return this.getNode((TypedElement)((LetExp)qvtpTypedElement).getOwnedIn());
        }
        if (qvtpTypedElement instanceof OppositePropertyCallExp && (sourceNode = this.getNode((TypedElement)(propertyCallExp = (OppositePropertyCallExp)qvtpTypedElement).getOwnedSource())) != null) {
            return sourceNode.getNavigationTarget((Property)ClassUtil.nonNullState((Object)propertyCallExp.getReferredProperty().getOpposite()));
        }
        if (qvtpTypedElement instanceof PropertyCallExp && (sourceNode = this.getNode((TypedElement)(propertyCallExp = (PropertyCallExp)qvtpTypedElement).getOwnedSource())) != null) {
            return sourceNode.getNavigationTarget((Property)ClassUtil.nonNullState((Object)propertyCallExp.getReferredProperty()));
        }
        if (qvtpTypedElement != null) {
            return this.qvtp2node.get(qvtpTypedElement);
        }
        return null;
    }

    protected @NonNull Operation getObjectsOfKindOperation() {
        StandardLibraryInternal standardLibrary = (StandardLibraryInternal)this.visitor.getStandardLibrary();
        Class modelType = standardLibrary.getLibraryType("Model");
        OperationId objectsOfKindOperationId = modelType.getTypeId().getOperationId(1, "objectsOfKind", IdManager.getParametersId((TypeId[])new TypeId[]{TypeId.T_1}));
        Operation objectsOfKindOperation = this.visitor.getEnvironmentFactory().getIdResolver().getOperation(objectsOfKindOperationId);
        return objectsOfKindOperation;
    }

    protected @NonNull Operation getOclIsKindOfOperation() {
        AnyType oclAnyType = ((StandardLibraryInternal)this.visitor.getStandardLibrary()).getOclAnyType();
        Operation oclIsKindOfOperation = (Operation)NameUtil.getNameable((Iterable)oclAnyType.getOwnedOperations(), (String)"oclIsKindOf");
        assert (oclIsKindOfOperation != null);
        return oclIsKindOfOperation;
    }

    public @NonNull Region getRegion() {
        return this.region;
    }

    protected @NonNull Operation getRootObjectsOperation() {
        StandardLibraryInternal standardLibrary = (StandardLibraryInternal)this.visitor.getStandardLibrary();
        Class modelType = standardLibrary.getLibraryType("Model");
        OperationId rootObjectsOperationId = modelType.getTypeId().getOperationId(1, "rootObjects", IdManager.getParametersId((TypeId[])new TypeId[0]));
        Operation rootObjectsOperation = this.visitor.getEnvironmentFactory().getIdResolver().getOperation(rootObjectsOperationId);
        return rootObjectsOperation;
    }

    protected @NonNull String getSafeName(@NonNull Node node) {
        String name = this.node2name.get(node);
        if (name == null) {
            name = this.getSafeName(node.getName());
        }
        return name;
    }

    protected @NonNull String getSafeName(@NonNull String rawName) {
        String stem;
        String name = stem = rawName;
        assert (name != null);
        int suffix = 1;
        while (this.names.contains(name)) {
            name = String.valueOf(stem) + suffix++;
        }
        this.names.add(name);
        return name;
    }

    protected @NonNull Operation getSelectByKindOperation() {
        CollectionType collectionType = ((StandardLibraryInternal)this.visitor.getStandardLibrary()).getCollectionType();
        Operation selectByKindOperation = (Operation)NameUtil.getNameable((Iterable)collectionType.getOwnedOperations(), (String)"selectByKind");
        assert (selectByKindOperation != null);
        return selectByKindOperation;
    }

    public boolean isInfinite() {
        return false;
    }

    protected void setLegacyIsPolled(@NonNull Mapping calledMapping, @NonNull MappingCallBinding mappingCallBinding) {
    }

    public String toString() {
        return this.mapping.toString();
    }

    public @NonNull MappingCall createMappingCall(@NonNull List<@NonNull MappingCallBinding> mappingCallBindings) {
        return QVTimperativeUtil.createMappingCall((Mapping)this.getMapping(), mappingCallBindings);
    }
}

